/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.api.utils.ArmorEquippedListener;
import me.sciguymjm.uberenchant.api.utils.UberConfiguration;
import me.sciguymjm.uberenchant.api.utils.UberRunnable;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.MetaTag;
import me.sciguymjm.uberenchant.commands.AddCommand;
import me.sciguymjm.uberenchant.commands.ClearCommand;
import me.sciguymjm.uberenchant.commands.CostCommand;
import me.sciguymjm.uberenchant.commands.DelCommand;
import me.sciguymjm.uberenchant.commands.ExtractCommand;
import me.sciguymjm.uberenchant.commands.HelpCommand;
import me.sciguymjm.uberenchant.commands.InsertCommand;
import me.sciguymjm.uberenchant.commands.ListCommand;
import me.sciguymjm.uberenchant.commands.ReloadCommand;
import me.sciguymjm.uberenchant.commands.SetCommand;
import me.sciguymjm.uberenchant.commands.abstraction.UberCommand;
import me.sciguymjm.uberenchant.commands.abstraction.UberTabCommand;
import me.sciguymjm.uberenchant.enchantments.abstraction.EffectEnchantment;
import me.sciguymjm.uberenchant.shaded.bstats.bukkit.Metrics;
import me.sciguymjm.uberenchant.shaded.bstats.charts.MultiLineChart;
import me.sciguymjm.uberenchant.utils.FileUtils;
import me.sciguymjm.uberenchant.utils.UberLocale;
import me.sciguymjm.uberenchant.utils.VersionUtils;
import me.sciguymjm.uberenchant.utils.enchanting.AnvilEvents;
import me.sciguymjm.uberenchant.utils.enchanting.EnchantmentTableEvents;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UberEnchant
extends JavaPlugin {
    private static UberEnchant plugin;
    private static Economy economy;

    public void onEnable() {
        plugin = this;
        this.initResources();
        this.update();
        if (VersionUtils.isV1_20_4()) {
            EffectEnchantment.init();
        }
        Metrics metrics = new Metrics(this, 1952);
        metrics.addCustomChart(new MultiLineChart("players_and_servers", () -> {
            HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
            valueMap.put("servers", 1);
            valueMap.put("players", Bukkit.getOnlinePlayers().size());
            return valueMap;
        }));
        if (this.getConfig().getBoolean("use_economy") && !this.economyLoaded()) {
            UberEnchant.log(Level.WARNING, UberLocale.get("uberenchant.economy_not_found"));
        }
        this.registerTabCommand("uadd", new AddCommand());
        this.registerTabCommand("uclear", new ClearCommand());
        this.registerTabCommand("ucost", new CostCommand());
        this.registerTabCommand("udel", new DelCommand());
        this.registerTabCommand("uextract", new ExtractCommand());
        this.registerCommand("uhelp", new HelpCommand());
        this.registerCommand("uinsert", new InsertCommand());
        this.registerTabCommand("ulist", new ListCommand());
        this.registerCommand("ureload", new ReloadCommand());
        this.registerTabCommand("uset", new SetCommand());
        final boolean enchants = FileUtils.get("/mechanics/enchantment_table.yml", "enabled", false, Boolean.class);
        final boolean anvil = FileUtils.get("/mechanics/anvil.yml", "enabled", false, Boolean.class);
        if (enchants) {
            UberEnchant.registerEvents(new EnchantmentTableEvents());
        }
        if (anvil) {
            UberEnchant.registerEvents(new AnvilEvents());
        }
        UberEnchant.registerEvents(new ArmorEquippedListener());
        UberEnchant.registerEvents(new Listener(){

            @EventHandler
            public void OnLoad(ServerLoadEvent event) {
                new BukkitRunnable(){

                    public void run() {
                        UberConfiguration.integrate();
                        UberConfiguration.loadFromEnchantmentsFolder();
                        long loaded = UberConfiguration.getRecords(a -> a.getEnchant() instanceof UberEnchantment && a.getKey() != null && !a.getKey().getNamespace().equalsIgnoreCase(UberEnchant.this.getName())).size();
                        long def = UberConfiguration.getRecords(a -> a.getEnchant() instanceof EffectEnchantment && a.getKey() != null && a.getKey().getNamespace().equalsIgnoreCase(UberEnchant.this.getName())).size();
                        long vanilla = UberConfiguration.getRecords(a -> a.getKey() != null && a.getKey().getNamespace().equalsIgnoreCase("minecraft")).size();
                        ArrayList<String> strings = new ArrayList<String>(List.of(new String[]{UberLocale.getF("console.enchantment_table_status", enchants ? "enabled" : "disabled"), UberLocale.getF("console.anvil_status", anvil ? "enabled" : "disabled"), UberLocale.getF("console.vanilla_enchantments", vanilla), UberLocale.getF("console.default_enchantments", def), UberLocale.getF("console.loaded_enchantments", loaded)}));
                        UberConfiguration.getIntegrated().forEach(name -> {
                            int enchantments = UberConfiguration.getRecords(record -> record.getKey() != null && record.getKey().getNamespace().equalsIgnoreCase((String)name)).size();
                            strings.add(UberLocale.getF("console.integrated_loaded", enchantments, name));
                        });
                        strings.add(UberLocale.getF("console.total_enchantments", UberConfiguration.getRecords().stream().filter(value -> value.getEnchant() != null).count()));
                        int length = strings.stream().max(Comparator.comparing(String::length)).get().length();
                        UberEnchant.log(Level.INFO, "=".repeat(length + 8));
                        strings.forEach(string -> UberEnchant.log(Level.INFO, "||  " + string + " ".repeat(length - string.length() + 2) + "||"));
                        UberEnchant.log(Level.INFO, "=".repeat(length + 8));
                    }
                }.runTask((Plugin)plugin);
            }
        });
        UberRunnable.getInstance();
    }

    public void onDisable() {
    }

    private void initResources() {
        this.saveDefaultConfig();
        FileUtils.initResource("locale/en_us.properties");
        FileUtils.initResource("locale/zh_cn.properties");
        FileUtils.initResource("enchantments/default/vanilla_enchantments.yml");
        FileUtils.initResource("enchantments/default/vanilla_effects.yml");
        FileUtils.initResource("mechanics/anvil.yml");
        FileUtils.initResource("mechanics/enchantment_table.yml");
        UberLocale.update();
        UberLocale.load(FileUtils.getFile("/locale/" + this.getConfig().getString("locale") + ".properties"));
    }

    private void initTags() {
        MetaTag.create("Test", PersistentDataType.BOOLEAN);
    }

    private void update() {
        File enchantments = new File(this.getDataFolder() + "/enchantments/default/vanilla_enchantments.yml");
        File old = new File(this.getDataFolder(), "enchantments.yml");
        FileConfiguration config = this.getConfig();
        if (config.isSet("mechanics")) {
            boolean anvil = config.getBoolean("mechanics.anvil", false);
            boolean table = config.getBoolean("mechanics.enchantment_table", false);
            FileUtils.set("/mechanics/enchantment_table.yml", "enabled", table);
            FileUtils.set("/mechanics/anvil.yml", "enabled", anvil);
            config.set("mechanics.enchantment_table", null);
            config.set("mechanics.anvil", null);
            config.set("mechanics", null);
            config.setComments("mechanics", null);
            this.saveConfig();
        }
        if (old.exists()) {
            try {
                YamlConfiguration.loadConfiguration((File)old).save(enchantments);
                old.delete();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean economyLoaded() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider economyService = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyService == null) {
            return false;
        }
        economy = (Economy)economyService.getProvider();
        return economy.isEnabled();
    }

    private void registerCommand(String name, UberCommand command) {
        this.getCommand(name).setExecutor((CommandExecutor)command);
    }

    private void registerTabCommand(String name, UberTabCommand executor) {
        this.registerCommand(name, executor);
        this.getCommand(name).setTabCompleter((TabCompleter)executor);
    }

    public static UberEnchant instance() {
        return plugin;
    }

    public static void registerEvents(Listener listener) {
        Bukkit.getServer().getPluginManager().registerEvents(listener, (Plugin)plugin);
    }

    public static Economy getEconomy() {
        return economy;
    }

    public static boolean hasEconomy() {
        return economy != null;
    }

    public static void log(Level level, String message) {
        if (level.equals(Level.WARNING)) {
            message = "!!!WARNING!!! " + (String)message;
        }
        plugin.getLogger().log(level, (String)message);
    }
}

