/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.api.utils;

import java.util.List;
import java.util.Map;
import me.sciguymjm.uberenchant.api.utils.EnchantmentData;
import me.sciguymjm.uberenchant.api.utils.UberRecord;
import me.sciguymjm.uberenchant.utils.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.plugin.Plugin;

public class ExcellentEnchantsRecord
extends UberRecord
implements EnchantmentData {
    private static Plugin plugin = Bukkit.getPluginManager().getPlugin("ExcellentEnchants");
    private static YamlConfiguration types = FileUtils.loadConfig(plugin, "item_types.yml");
    private double weight;
    private int minBase;
    private int minPer;
    private int maxBase;
    private int maxPer;
    private boolean treasure;
    private List<String> targets;

    public ExcellentEnchantsRecord(Enchantment enchantment, NamespacedKey key, String displayName, int minLevel, int maxLevel, double cost, double costMultiplier, double removelCost, double extractionCost, boolean useOnAnything, List<String> aliases, Map<Integer, Double> levelCost) {
        super(enchantment, key, displayName, minLevel, maxLevel, cost, costMultiplier, removelCost, extractionCost, useOnAnything, aliases, levelCost);
        this.displayName = FileUtils.get(plugin, "enchants/" + this.getKey().getKey() + ".yml", "Definition.DisplayName", this.displayName, String.class);
        YamlConfiguration config = FileUtils.loadConfig(plugin, "enchants/" + key.getKey() + ".yml");
        if (config != null) {
            this.weight = config.getInt("Definition.Weight");
            this.minBase = config.getInt("Definition.MinCost.Base");
            this.minPer = config.getInt("Definition.MinCost.Per_Level");
            this.maxBase = config.getInt("Definition.MaxCost.Base");
            this.maxPer = config.getInt("Definition.MaxCost.Per_Level");
            this.treasure = config.getBoolean("Distribution.Treasure");
            this.targets = types.getStringList("Categories." + config.getString("Definition.PrimaryItems") + ".Items");
        }
    }

    public ExcellentEnchantsRecord(UberRecord record) {
        this(record.enchantment, record.key, record.displayName, record.minLevel, record.maxLevel, record.cost, record.costMultiplier, record.removelCost, record.extractionCost, record.useOnAnything, record.aliases, record.levelCost);
    }

    public List<String> getTargets() {
        return this.targets;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public int getMinBase() {
        return this.minBase;
    }

    @Override
    public int getMinPer() {
        return this.minPer;
    }

    @Override
    public int getMaxBase() {
        return this.maxBase;
    }

    @Override
    public int getMaxPer() {
        return this.maxPer;
    }

    @Override
    public boolean isTreasure() {
        return this.treasure;
    }

    @Override
    public Plugin getPlugin() {
        return plugin;
    }
}

