/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.api.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;

public class UberRecord {
    private static Set<UberRecord> values = new HashSet<UberRecord>();
    protected Enchantment enchantment;
    protected NamespacedKey key;
    protected String displayName;
    protected int minLevel;
    protected int maxLevel;
    protected double cost;
    protected double costMultiplier;
    protected double removelCost;
    protected double extractionCost;
    protected boolean useOnAnything;
    protected List<String> aliases;
    protected Map<Integer, Double> levelCost;

    public UberRecord(Enchantment enchantment, NamespacedKey key, String displayName, int minLevel, int maxLevel, double cost, double costMultiplier, double removelCost, double extractionCost, boolean useOnAnything, List<String> aliases, Map<Integer, Double> levelCost) {
        this.enchantment = enchantment;
        this.key = key;
        this.displayName = displayName;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.cost = cost;
        this.costMultiplier = costMultiplier;
        this.removelCost = removelCost;
        this.extractionCost = extractionCost;
        this.useOnAnything = useOnAnything;
        this.aliases = aliases;
        this.levelCost = levelCost;
    }

    public Enchantment getEnchant() {
        return this.enchantment;
    }

    public String getName() {
        return this.key.getKey();
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public double getCost() {
        return this.cost;
    }

    public double getCostMultiplier() {
        return this.costMultiplier;
    }

    public double getRemovalCost() {
        return this.removelCost;
    }

    public double getExtractionCost() {
        return this.extractionCost;
    }

    public boolean getCanUseOnAnything() {
        return this.useOnAnything;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public Map<Integer, Double> getLevelCost() {
        return this.levelCost;
    }

    public static Set<UberRecord> values() {
        return values;
    }

    public static boolean addRecord(UberRecord record) {
        if (values.stream().noneMatch(r -> r.getEnchant().equals(record.getEnchant()))) {
            return values.add(record);
        }
        return false;
    }

    public static UberRecord byEnchantment(Enchantment enchantment) {
        return values.stream().filter(r -> r.getEnchant().equals(enchantment)).findFirst().orElse(null);
    }

    public static Set<UberRecord> getRecords() {
        return values;
    }

    public static List<UberRecord> getRecords(Predicate<UberRecord> filter) {
        return values.stream().filter(filter).toList();
    }

    protected static void reset() {
        values = new HashSet<UberRecord>();
    }
}

