/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.sciguymjm.uberenchant.api.utils.UberConfiguration;
import me.sciguymjm.uberenchant.api.utils.UberRecord;
import me.sciguymjm.uberenchant.commands.abstraction.UberTabCommand;
import me.sciguymjm.uberenchant.utils.EconomyUtils;
import me.sciguymjm.uberenchant.utils.Reply;
import me.sciguymjm.uberenchant.utils.enchanting.EnchantmentUtils;
import org.bukkit.enchantments.Enchantment;

public class CostCommand
extends UberTabCommand {
    @Override
    public boolean onCmd() {
        if (this.args.length != 0) {
            switch (this.args[0].toLowerCase()) {
                case "add": {
                    if (this.args[1].equalsIgnoreCase("enchant")) {
                        if (this.hasPermission("uber.cost.add.enchant")) {
                            this.addEnchant();
                            break;
                        }
                        this.response(Reply.PERMISSIONS);
                        break;
                    }
                    this.response("&a/ucost add &cenchant &a<enchantment> <level>");
                    this.response(Reply.INVALID);
                    break;
                }
                case "del": {
                    if (this.args[1].equalsIgnoreCase("enchant")) {
                        if (this.hasPermission("uber.cost.del.enchant")) {
                            this.removeEnchant();
                            break;
                        }
                        this.response(Reply.PERMISSIONS);
                        break;
                    }
                    this.response("&a/ucost extract &cenchant &a<enchantment>");
                    this.response(Reply.INVALID);
                    break;
                }
                case "extract": {
                    if (this.args[1].equalsIgnoreCase("enchant")) {
                        if (this.hasPermission("uber.cost.extract.enchant")) {
                            this.extractEnchant();
                            break;
                        }
                        this.response(Reply.PERMISSIONS);
                        break;
                    }
                    this.response("&a/ucost extract &cenchant &a<enchantment> <level>");
                    this.response(Reply.INVALID);
                    break;
                }
                default: {
                    EnchantmentUtils.help(this.player, "ucost");
                    break;
                }
            }
        } else {
            this.response("&6%1$s", this.command.getUsage());
        }
        return true;
    }

    @Override
    public List<String> onTab() {
        List<String> list = new ArrayList<String>();
        block0 : switch (this.args.length) {
            case 1: {
                if (this.hasPermission("uber.add.enchant")) {
                    list.add("add");
                }
                if (this.hasPermission("uber.del.enchant")) {
                    list.add("del");
                }
                if (!this.hasPermission("uber.extract.enchant")) break;
                list.add("extract");
                break;
            }
            case 2: {
                if (!this.hasPermission("uber.add.enchant") && !this.hasPermission("uber.del.enchant") && !this.hasPermission("uber.extract.enchant")) break;
                list.add("enchant");
                break;
            }
            case 3: {
                switch (this.args[1].toLowerCase()) {
                    case "enchant": {
                        list = EnchantmentUtils.find(this.player, this.args[2]);
                        break block0;
                    }
                }
            }
        }
        return list;
    }

    private void addEnchant() {
        if (this.args.length < 4) {
            this.response("&a/ucost add enchant &c<enchantment> <level>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        int level = 0;
        try {
            level = Integer.parseInt(this.args[3]);
        }
        catch (NumberFormatException e) {
            this.response("&a/ucost %1$s %2$s %3$s &c%4$s", this.args);
            this.response(Reply.WHOLE_NUMBER);
            return;
        }
        Set<Enchantment> set = EnchantmentUtils.getMatches(this.args[2]);
        if (EnchantmentUtils.multi(this.player, set)) {
            return;
        }
        Enchantment enchantment = set.iterator().next();
        if (enchantment == null) {
            this.localized("&c", "actions.enchant.invalid");
            this.response("&a/ulist enchants");
            return;
        }
        UberRecord e = UberConfiguration.getByEnchant(enchantment);
        if (EconomyUtils.hasEconomy()) {
            if (level >= e.getMinLevel() && level <= e.getMaxLevel()) {
                double cost = e.getLevelCost().containsKey(level) ? e.getLevelCost().get(level) : e.getCost() + e.getCostMultiplier() * e.getCost() * (double)(level - 1);
                this.localized("&a", "actions.cost.add.display", e.getName(), level, cost);
            } else {
                this.localized("&c", "actions.enchant.range", e.getMinLevel(), e.getMaxLevel());
            }
            return;
        }
        this.response(Reply.NO_ECONOMY);
    }

    private void extractEnchant() {
        if (this.args.length < 4) {
            this.response("&a/ucost extract enchant &c<enchantment> <level>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        if (EconomyUtils.hasEconomy()) {
            int level = 0;
            try {
                level = Integer.parseInt(this.args[3]);
            }
            catch (NumberFormatException e) {
                this.response("&a/ucost %1$s %2$s %3$s &c%4$s", this.args);
                this.response(Reply.WHOLE_NUMBER);
                return;
            }
            Set<Enchantment> set = EnchantmentUtils.getMatches(this.args[2]);
            if (EnchantmentUtils.multi(this.player, set)) {
                return;
            }
            Enchantment enchantment = set.iterator().next();
            if (enchantment == null) {
                this.localized("&c", "actions.enchant.invalid");
                this.response("&a/ulist enchants");
                return;
            }
            UberRecord e = UberConfiguration.getByEnchant(enchantment);
            this.localized("&a", "actions.cost.extract.display", e.getName(), level, e.getExtractionCost() + e.getCostMultiplier() * e.getExtractionCost() * (double)(level - 1));
            return;
        }
        this.response(Reply.NO_ECONOMY);
    }

    private void removeEnchant() {
        if (this.args.length != 3) {
            this.response("&a/ucost del enchant &c<enchantment>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        if (EconomyUtils.hasEconomy()) {
            Set<Enchantment> set = EnchantmentUtils.getMatches(this.args[2]);
            if (EnchantmentUtils.multi(this.player, set)) {
                return;
            }
            Enchantment enchantment = set.iterator().next();
            if (enchantment != null) {
                UberRecord enchant = UberConfiguration.getByEnchant(enchantment);
                this.localized("&a", "actions.cost.remove.display", enchant.getName(), enchant.getRemovalCost());
                return;
            }
            this.localized("&c", "actions.enchant.not_exist");
        }
        this.response(Reply.NO_ECONOMY);
    }
}

