/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.api.utils.UberConfiguration;
import me.sciguymjm.uberenchant.api.utils.UberRecord;
import me.sciguymjm.uberenchant.api.utils.UberUtils;
import me.sciguymjm.uberenchant.api.utils.persistence.UberMeta;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.MetaTag;
import me.sciguymjm.uberenchant.commands.abstraction.UberTabCommand;
import me.sciguymjm.uberenchant.utils.EconomyUtils;
import me.sciguymjm.uberenchant.utils.EffectUtils;
import me.sciguymjm.uberenchant.utils.Reply;
import me.sciguymjm.uberenchant.utils.VersionUtils;
import me.sciguymjm.uberenchant.utils.enchanting.EnchantmentUtils;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;

public class DelCommand
extends UberTabCommand {
    @Override
    public boolean onCmd() {
        if (this.args.length != 0) {
            ItemStack item = this.player.getInventory().getItemInMainHand();
            switch (this.args[0].toLowerCase()) {
                case "enchant": {
                    if (this.hasPermission("uber.del.enchant")) {
                        this.enchant(item);
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "effect": {
                    if (this.hasPermission("uber.del.effect")) {
                        this.effect();
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "lore": {
                    if (this.hasPermission("uber.del.lore")) {
                        this.lore(item);
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "meta": {
                    if (this.hasPermission("uber.del.meta")) {
                        this.meta(item);
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "name": {
                    if (this.hasPermission("uber.del.name")) {
                        this.name(item);
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                default: {
                    EnchantmentUtils.help(this.player, "udel");
                    break;
                }
            }
        } else {
            this.response("&6%1$s", this.command.getUsage());
        }
        return true;
    }

    @Override
    public List<String> onTab() {
        List<String> list = new ArrayList<String>();
        if (this.args.length == 1) {
            if (this.hasPermission("uber.del.enchant")) {
                list.add("enchant");
            }
            if (this.hasPermission("uber.del.effect")) {
                list.add("effect");
            }
            if (this.hasPermission("uber.del.lore")) {
                list.add("lore");
            }
            if (VersionUtils.isV1_20_4() && this.hasPermission("uber.del.meta")) {
                list.add("meta");
            }
            if (this.hasPermission("uber.del.name")) {
                list.add("name");
            }
        }
        ItemStack item = this.player.getInventory().getItemInMainHand();
        if (this.args.length == 2) {
            switch (this.args[0].toLowerCase()) {
                case "enchant": {
                    if (item.getType().equals((Object)Material.AIR) || UberUtils.getAllMap(item).isEmpty()) break;
                    list = EnchantmentUtils.find(this.player, item, this.args[1]);
                    break;
                }
                case "effect": {
                    list = this.player.getActivePotionEffects().stream().map(effect -> effect.getType().getName().toLowerCase()).toList();
                    break;
                }
                case "meta": {
                    if (!VersionUtils.isV1_20_4()) {
                        return list;
                    }
                    Map<UberEnchantment, Integer> map = UberUtils.getMap(item);
                    if (item.getType().equals((Object)Material.AIR) || map.isEmpty()) break;
                    list = map.keySet().stream().map(key -> key.getKey().getKey().toLowerCase()).toList();
                }
            }
        }
        if (this.args.length == 3 && this.args[0].equalsIgnoreCase("meta")) {
            list = UberUtils.getTags(item, this.args[1]).stream().map(MetaTag::getName).filter(tag -> !tag.equalsIgnoreCase("level") && !tag.equalsIgnoreCase("duration")).toList();
        }
        return list;
    }

    private void enchant(ItemStack item) {
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        if (this.args.length < 2) {
            this.response("&a/udel enchant &c<enchantment>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        Set<Enchantment> set = EnchantmentUtils.getMatches(this.args[1]);
        set.retainAll(UberUtils.getAllMap(item).keySet());
        if (EnchantmentUtils.multi(this.player, set)) {
            return;
        }
        Enchantment enchantment = set.iterator().next();
        if (enchantment != null) {
            UberRecord enchant = UberConfiguration.getByEnchant(enchantment);
            if (!this.hasPermission("uber.del.enchant.%1$s", enchant.getName().toLowerCase())) {
                this.response(Reply.PERMISSIONS);
                return;
            }
            if (this.hasPermission("uber.del.enchant.free") || !EconomyUtils.useEconomy()) {
                if (EnchantmentUtils.removeEnchantment(enchantment, item)) {
                    this.localized("&a", "actions.enchant.remove.success", enchant.getDisplayName());
                } else {
                    this.localized("&c", "actions.enchant.remove.no_enchant", enchant.getDisplayName());
                }
                return;
            }
            if (EconomyUtils.hasEconomy()) {
                if (EconomyUtils.has(this.player, enchant.getRemovalCost())) {
                    if (EnchantmentUtils.removeEnchantment(enchantment, item)) {
                        EconomyUtils.withdraw(this.player, enchant.getRemovalCost());
                        this.localized("&a", "actions.enchant.remove.pay_success", enchant.getDisplayName(), enchant.getRemovalCost());
                    } else {
                        this.localized("&c", "actions.enchant.remove.no_enchant", enchant.getDisplayName());
                    }
                } else {
                    this.localized("&c", "actions.enchant.remove.pay_more", enchant.getRemovalCost() - EconomyUtils.getBalance(this.player));
                }
            } else {
                this.response(Reply.NO_ECONOMY);
            }
            return;
        }
        this.localized("&c", "actions.enchant.not_exist");
    }

    private void meta(ItemStack item) {
        if (!VersionUtils.isV1_20_4()) {
            return;
        }
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        if (this.args.length < 3) {
            this.response("&a/udel meta &c<enchantment> <tag>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        Set<UberEnchantment> set = EnchantmentUtils.getMatches(item, this.args[1]);
        if (EnchantmentUtils.multi(this.player, set)) {
            return;
        }
        if (set == null) {
            return;
        }
        UberEnchantment enchant = set.iterator().next();
        if (!enchant.containsEnchantment(item)) {
            this.localized("&c", "actions.meta.enchantment_not_found");
            return;
        }
        if (!UberMeta.contains(this.args[2])) {
            this.localized("&c", "actions.meta.invalid_tag");
            return;
        }
        UberMeta<?> meta = UberMeta.getByName(this.args[2]);
        if (meta == null) {
            this.localized("&c", "actions.meta.invalid_tag");
            return;
        }
        if (UberUtils.removeMeta(item, enchant, meta)) {
            this.localized("&a", "actions.meta.remove.success");
            return;
        }
        this.localized("&c", "actions.meta.remove.fail");
    }

    private void owner(ItemStack item) {
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        if (!UberUtils.hasOwner(item)) {
            this.localized("&c", "actions.owner.del.no_owner");
            return;
        }
        UberUtils.removeOwner(item);
        this.localized("&a", "actions.owner.del.success");
    }

    private void effect() {
        if (this.args.length < 2) {
            this.response("&a/udel effect &c<effect>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        PotionEffectType effect = EffectUtils.getEffect(this.args[1]);
        if (effect != null && this.player.hasPotionEffect(effect)) {
            EffectUtils.removeEffect(this.player, effect);
            this.localized("&a", "actions.effect.remove.success");
            return;
        }
        this.localized("&c", "actions.effect.remove.not_exist");
    }

    private void lore(ItemStack item) {
        int line;
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        if (this.args.length < 2) {
            this.response("&a/udel lore &c<line#>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        int index = UberUtils.offset(item);
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasLore() || meta.hasLore() && meta.getLore().size() - index == 0) {
            this.localized("&c", "actions.lore.remove.no_lore");
            return;
        }
        List lore = meta.getLore();
        int size = lore.size() - index;
        if (size == 1) {
            lore.remove(index);
            meta.setLore(null);
            item.setItemMeta(meta);
            this.localized("&a", "actions.lore.remove.success");
            return;
        }
        try {
            line = Integer.parseInt(this.args[1]);
        }
        catch (NumberFormatException err) {
            this.response("&a/udel %1$s &c%2$s", this.args);
            this.localized("&c", "actions.lore.remove.line_number");
            return;
        }
        if (line > size - 1 || line < 0) {
            this.response("&a/udel %1$s &c%2$s", this.args);
            this.localized("&c", "actions.lore.remove.no_line");
            return;
        }
        if (Integer.toString(line).contains(".")) {
            this.response("&a/udel %1$s &c%2$s", this.args);
            this.response(Reply.WHOLE_NUMBER);
            return;
        }
        lore.remove(index + line);
        meta.setLore(lore);
        item.setItemMeta(meta);
        this.localized("&a", "actions.lore.remove.success");
    }

    private void name(ItemStack item) {
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        if (!item.hasItemMeta()) {
            this.localized("&c", "actions.name.no_name");
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasDisplayName()) {
            this.localized("&c", "actions.name.no_name");
            return;
        }
        if (EconomyUtils.useEconomy() && EconomyUtils.hasEconomy()) {
            double cost = EconomyUtils.getCost("cost.name.remove");
            if (EconomyUtils.has(this.player, cost)) {
                EconomyUtils.withdraw(this.player, cost);
                meta.setDisplayName(null);
                item.setItemMeta(meta);
                this.localized("&a", "actions.name.remove.pay_success", cost);
            } else {
                this.localized("&c", "actions.name.remove.pay_fail", cost - EconomyUtils.getBalance(this.player));
            }
        } else {
            meta.setDisplayName(null);
            item.setItemMeta(meta);
            this.localized("&a", "actions.name.remove.success");
        }
    }
}

