/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.enchantments.effects;

import me.sciguymjm.uberenchant.api.utils.Rarity;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.BoolTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.IntTag;
import me.sciguymjm.uberenchant.enchantments.abstraction.EffectEnchantment;
import org.bukkit.Material;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class FastDiggingEnchantment
extends EffectEnchantment {
    public FastDiggingEnchantment() {
        super("FAST_DIGGING");
        this.setTag(BoolTag.HAS_CHANCE, true);
        this.setTag(IntTag.DURATION, 3);
    }

    @Override
    public Rarity getRarity() {
        return Rarity.RARE;
    }

    public EnchantmentTarget getItemTarget() {
        return EnchantmentTarget.TOOL;
    }

    public boolean canEnchantItem(ItemStack itemStack) {
        return EnchantmentTarget.TOOL.includes(itemStack);
    }

    @EventHandler
    public void onDig(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR || !this.containsEnchantment(item)) {
            return;
        }
        if (this.conditions(item)) {
            return;
        }
        if (BoolTag.HAS_CHANCE.test(item, this)) {
            this.apply(player);
        } else {
            this.apply(item, (LivingEntity)player);
        }
    }
}

