/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.utils;

import java.io.File;
import java.io.IOException;
import me.sciguymjm.uberenchant.UberEnchant;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class FileUtils {
    public static void initResource(String path) {
        File f;
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!(f = FileUtils.getFile((String)path)).exists()) {
            UberEnchant.instance().saveResource(((String)path).replaceFirst("/", ""), false);
        }
    }

    public static File getFile(String path) {
        return FileUtils.getFile((Plugin)UberEnchant.instance(), path);
    }

    public static File getFile(Plugin plugin, String path) {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return new File(plugin.getDataFolder() + (String)path);
    }

    public static YamlConfiguration loadConfig(Plugin plugin, String path) {
        File f = FileUtils.getFile(plugin, path);
        if (!f.exists()) {
            return null;
        }
        return YamlConfiguration.loadConfiguration((File)f);
    }

    public static YamlConfiguration loadConfig(String path) {
        return FileUtils.loadConfig((Plugin)UberEnchant.instance(), path);
    }

    public static YamlConfiguration loadConfig(File file) {
        if (!file.exists()) {
            return null;
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static YamlConfiguration createConfig(Plugin plugin, String path) {
        File file = FileUtils.getFile(plugin, path);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        try {
            config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return config;
    }

    public static YamlConfiguration createConfig(String path) {
        return FileUtils.createConfig((Plugin)UberEnchant.instance(), path);
    }

    public static <T> T get(String path, String key, Class<T> type) {
        return FileUtils.get(path, key, null, type);
    }

    public static <T> T get(String path, String key, T def, Class<T> type) {
        return FileUtils.get((Plugin)UberEnchant.instance(), path, key, def, type);
    }

    public static <T> T get(Plugin plugin, String path, String key, Class<T> type) {
        return FileUtils.get(plugin, path, key, null, type);
    }

    public static <T> T get(Plugin plugin, String path, String key, T def, Class<T> type) {
        YamlConfiguration config = FileUtils.loadConfig(plugin, path);
        if (config == null) {
            return null;
        }
        return (T)config.getObject(key, type, def);
    }

    public static <T> T updateAndGet(String path, String key, T def, Class<T> type) {
        if (!FileUtils.contains(path, key)) {
            FileUtils.set(path, key, def);
        }
        return FileUtils.get(path, key, def, type);
    }

    public static <T> void update(String path, String key, Object def, Class<T> type) {
        if (!FileUtils.contains(path, key)) {
            FileUtils.set(path, key, def);
        }
    }

    public static boolean contains(String path, String key) {
        return FileUtils.contains((Plugin)UberEnchant.instance(), path, key);
    }

    public static boolean contains(Plugin plugin, String path, String key) {
        YamlConfiguration config = FileUtils.loadConfig(plugin, path);
        if (config == null) {
            return false;
        }
        return config.contains(key);
    }

    public static void set(String path, String key, Object value) {
        FileUtils.set((Plugin)UberEnchant.instance(), path, key, value);
    }

    public static void set(Plugin plugin, String path, String key, Object value) {
        File file = FileUtils.getFile(plugin, path);
        YamlConfiguration config = FileUtils.loadConfig(file);
        if (config == null) {
            config = FileUtils.createConfig(plugin, path);
        }
        config.set(key, value);
        try {
            config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

