/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.registry.RegistryAware;

public class VersionUtils {
    private static boolean isPaper;
    private static final boolean v1_21_4;
    private static final boolean v1_20_4;
    private static final int[] version;

    private static int[] parseVersion(String version) {
        Matcher m = Pattern.compile("(\\d+)\\.(\\d+)\\.?(\\d?)").matcher(version);
        if (m.find()) {
            return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), m.group(3).isBlank() ? 0 : Integer.parseInt(m.group(3))};
        }
        return new int[]{0, 0, 0};
    }

    public static boolean isAtLeast(String v) {
        int[] v1 = version;
        int[] v2 = VersionUtils.parseVersion(v);
        return v1[0] > v2[0] || v1[0] == v2[0] && v1[1] > v2[1] || v1[0] == v2[0] && v1[1] == v2[1] && v1[2] >= v2[2];
    }

    public static boolean isV1_20_4() {
        return v1_20_4;
    }

    public static <K extends Keyed> NamespacedKey getKey(K keyed) {
        NamespacedKey key;
        if (!isPaper && v1_21_4 && keyed instanceof RegistryAware) {
            RegistryAware k = (RegistryAware)keyed;
            key = k.getKeyOrNull();
        } else {
            key = keyed.getKey();
        }
        return key;
    }

    static {
        version = VersionUtils.parseVersion(Bukkit.getBukkitVersion());
        v1_21_4 = VersionUtils.isAtLeast("1.21.4");
        v1_20_4 = VersionUtils.isAtLeast("1.20.4");
        try {
            Class.forName("io.papermc.paper.plugin.provider.classloader.PaperClassLoaderStorage");
            isPaper = true;
        }
        catch (ClassNotFoundException ignore) {
            isPaper = false;
        }
    }
}

