/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.api.utils;

import java.util.Arrays;
import me.sciguymjm.uberenchant.UberEnchant;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.api.events.PlayerEquipArmorEvent;
import me.sciguymjm.uberenchant.api.events.UberArmorEquippedEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ArmorEquippedListener
implements Listener {
    private boolean change(ItemStack[] a, ItemStack[] b) {
        return !Arrays.equals(a, b);
    }

    private int slot(ItemStack[] a, ItemStack[] b) {
        int index = Arrays.mismatch(a, b);
        return index > -1 ? index + 36 : -1;
    }

    private ItemStack getItem(ItemStack[] a, ItemStack[] b, PlayerInventory inventory) {
        return inventory.getItem(this.slot(a, b));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            humanEntity = event.getClickedInventory();
            if (humanEntity instanceof PlayerInventory) {
                PlayerInventory inventory = (PlayerInventory)humanEntity;
                this.fireEvents(player, inventory);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteract(PlayerInteractEvent event) {
        Action action = event.getAction();
        if (action.equals((Object)Action.RIGHT_CLICK_AIR) || action.equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            this.fireEvents(event.getPlayer(), event.getPlayer().getInventory());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        new BukkitRunnable(){

            public void run() {
                ItemStack[] armor = player.getInventory().getArmorContents();
                for (int n = 0; n < 4; ++n) {
                    if (armor[n] == null) continue;
                    Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerEquipArmorEvent(player, armor[n], n + 36));
                    if (!UberEnchantment.hasEnchantments(armor[n])) continue;
                    Bukkit.getServer().getPluginManager().callEvent((Event)new UberArmorEquippedEvent(player, armor[n], n + 36));
                }
            }
        }.runTaskLater((Plugin)UberEnchant.instance(), 20L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onRespawn(PlayerRespawnEvent event) {
        final Player player = event.getPlayer();
        new BukkitRunnable(){

            public void run() {
                ItemStack[] armor = player.getInventory().getArmorContents();
                for (int n = 0; n < 4; ++n) {
                    if (armor[n] == null) continue;
                    Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerEquipArmorEvent(player, armor[n], n + 36));
                    if (!UberEnchantment.hasEnchantments(armor[n])) continue;
                    Bukkit.getServer().getPluginManager().callEvent((Event)new UberArmorEquippedEvent(player, armor[n], n + 36));
                }
            }
        }.runTask((Plugin)UberEnchant.instance());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onReload(ServerLoadEvent event) {
        if (event.getType().equals((Object)ServerLoadEvent.LoadType.RELOAD)) {
            new BukkitRunnable(){

                public void run() {
                    Bukkit.getOnlinePlayers().forEach(player -> {
                        ItemStack[] armor = player.getInventory().getArmorContents();
                        for (int n = 0; n < 4; ++n) {
                            if (armor[n] == null) continue;
                            Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerEquipArmorEvent((Player)player, armor[n], n + 36));
                            if (!UberEnchantment.hasEnchantments(armor[n])) continue;
                            Bukkit.getServer().getPluginManager().callEvent((Event)new UberArmorEquippedEvent((Player)player, armor[n], n + 36));
                        }
                    });
                }
            }.runTask((Plugin)UberEnchant.instance());
        }
    }

    private void fireEvents(final Player player, final PlayerInventory inventory) {
        final ItemStack[] a = inventory.getArmorContents();
        new BukkitRunnable(){

            public void run() {
                ItemStack[] b = inventory.getArmorContents();
                if (ArmorEquippedListener.this.change(a, b)) {
                    ItemStack item = ArmorEquippedListener.this.getItem(a, b, inventory);
                    int slot = ArmorEquippedListener.this.slot(a, b);
                    if (item != null) {
                        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerEquipArmorEvent(player, item, slot));
                        if (UberEnchantment.hasEnchantments(item)) {
                            Bukkit.getServer().getPluginManager().callEvent((Event)new UberArmorEquippedEvent(player, item, slot));
                        }
                    }
                }
            }
        }.runTask((Plugin)UberEnchant.instance());
    }
}

