/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.api.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.api.utils.persistence.PDCItemUtils;
import me.sciguymjm.uberenchant.api.utils.persistence.UberMeta;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.BoolTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.IntTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.MetaTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.UUIDTag;
import me.sciguymjm.uberenchant.enchantments.abstraction.EffectEnchantment;
import me.sciguymjm.uberenchant.utils.ChatUtils;
import me.sciguymjm.uberenchant.utils.enchanting.EnchantmentUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class UberUtils
extends PDCItemUtils {
    public static final NamespacedKey uberEnchantment = UberUtils.generateKey("uberenchantment");
    public static final NamespacedKey storedUberEnchantment = UberUtils.generateKey("storeduberenchantment");

    public static PersistentDataContainer getData(ItemStack item) {
        return UberUtils.getPDC(item, uberEnchantment);
    }

    public static boolean hasData(ItemStack item) {
        return UberUtils.has(item, uberEnchantment);
    }

    public static boolean hasMeta(ItemStack item, UberEnchantment enchantment) {
        return UberUtils.hasData(item) && UberUtils.has(UberUtils.getData(item), enchantment.getKey(), TAG);
    }

    public static boolean hasStoredData(ItemStack item) {
        return UberUtils.has(item, storedUberEnchantment);
    }

    public static boolean containsData(ItemStack item, UberEnchantment enchantment) {
        return UberUtils.hasData(item) && UberUtils.has(UberUtils.getData(item), enchantment.getKey());
    }

    public static boolean containsMeta(ItemStack item, UberEnchantment enchantment, MetaTag<?> tag) {
        return UberUtils.containsMeta(item, enchantment, tag.asMeta());
    }

    public static boolean containsMeta(ItemStack item, UberEnchantment enchantment, UberMeta<?> meta) {
        return UberUtils.hasMeta(item, enchantment) && UberUtils.has(UberUtils.getPDC(UberUtils.getData(item), enchantment.getKey()), meta.getKey(), meta.getType());
    }

    public static boolean containsStoredData(ItemStack item, UberEnchantment enchantment) {
        return UberUtils.hasStoredData(item) && UberUtils.has(UberUtils.getData(item), enchantment.getKey());
    }

    public static <T> T getTag(ItemStack item, UberEnchantment enchantment, NamespacedKey namespace, UberMeta<T> meta) {
        PersistentDataContainer data2 = UberUtils.getPDC(item, namespace);
        if (UberUtils.containsMeta(item, enchantment, meta)) {
            return UberUtils.get(UberUtils.getPDC(data2, enchantment.getKey()), meta.getKey(), meta.getType());
        }
        if (meta == UberMeta.LEVEL) {
            return UberUtils.get(data2, enchantment.getKey(), meta.getType());
        }
        return null;
    }

    public static <T> T getTag(ItemStack item, UberEnchantment enchantment, NamespacedKey namespace, MetaTag<T> tag) {
        return UberUtils.getTag(item, enchantment, namespace, tag.asMeta());
    }

    public static <T> T getMetaTag(ItemStack item, UberEnchantment enchantment, UberMeta<T> meta) {
        return UberUtils.getTag(item, enchantment, uberEnchantment, meta);
    }

    public static <T> T getMetaTag(ItemStack item, UberEnchantment enchantment, MetaTag<T> tag) {
        return UberUtils.getTag(item, enchantment, uberEnchantment, tag);
    }

    public static <T> T getStoredMetaTag(ItemStack item, UberEnchantment enchantment, MetaTag<T> tag) {
        return UberUtils.getTag(item, enchantment, storedUberEnchantment, tag);
    }

    public static <T> T getStoredMetaTag(ItemStack item, UberEnchantment enchantment, UberMeta<T> meta) {
        return UberUtils.getTag(item, enchantment, storedUberEnchantment, meta);
    }

    public static PersistentDataContainer getStoredData(ItemStack item) {
        return UberUtils.getPDC(item, storedUberEnchantment);
    }

    private static Map<UberEnchantment, Integer> getCustomMap(ItemStack item, NamespacedKey namespace) {
        HashMap<UberEnchantment, Integer> map = new HashMap<UberEnchantment, Integer>();
        if (UberUtils.has(item, namespace)) {
            PersistentDataContainer data2 = UberUtils.getPDC(item, namespace);
            if (UberUtils.notNull(data2)) {
                data2.getKeys().forEach(key -> {
                    if (UberEnchantment.containsKey(key)) {
                        if (UberUtils.has(data2, key, PersistentDataType.INTEGER)) {
                            map.put(UberEnchantment.getByKey(key), (Integer)UberUtils.get(data2, key, PersistentDataType.INTEGER));
                        } else {
                            UberMeta<Integer> level;
                            PersistentDataContainer meta = UberUtils.getPDC(data2, key);
                            if (UberUtils.has(meta, (level = UberMeta.LEVEL).getKey())) {
                                map.put(UberEnchantment.getByKey(key), UberUtils.get(meta, level.getKey(), level.getType()));
                            }
                        }
                    }
                });
            }
        }
        return map;
    }

    private static List<MetaTag<?>> getTags(ItemStack item, NamespacedKey enchantment, NamespacedKey namespace) {
        PersistentDataContainer data2;
        ArrayList list = new ArrayList();
        if (UberUtils.notNull(item, enchantment, namespace) && UberUtils.has(item, namespace) && UberUtils.notNull(data2 = UberUtils.getPDC(item, namespace)) && UberUtils.has(data2, enchantment)) {
            UberUtils.getPDC(data2, enchantment).getKeys().forEach(key -> list.add(MetaTag.byKey(key)));
        }
        return list;
    }

    private static List<MetaTag<?>> getTags(ItemStack item, UberEnchantment enchantment, NamespacedKey namespace) {
        if (UberUtils.notNull(new Object[]{enchantment})) {
            return UberUtils.getTags(item, enchantment.getKey(), namespace);
        }
        return new ArrayList();
    }

    private static List<MetaTag<?>> getTags(ItemStack item, String name, NamespacedKey namespace) {
        return UberUtils.getTags(item, UberEnchantment.getByName(name), namespace);
    }

    public static List<MetaTag<?>> getTags(ItemStack item, UberEnchantment enchantment) {
        return UberUtils.getTags(item, enchantment, uberEnchantment);
    }

    public static List<MetaTag<?>> getTags(ItemStack item, String name) {
        return UberUtils.getTags(item, name, uberEnchantment);
    }

    public static Map<UberEnchantment, Integer> getMap(ItemStack item) {
        return UberUtils.getCustomMap(item, uberEnchantment);
    }

    public static Set<UberEnchantment> getEnchants(ItemStack item) {
        return UberUtils.getCustomMap(item, uberEnchantment).keySet();
    }

    public static Map<UberEnchantment, Integer> getStoredMap(ItemStack item) {
        return UberUtils.getCustomMap(item, storedUberEnchantment);
    }

    public static Map<Enchantment, Integer> getAllMap(ItemStack item) {
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>(item.getEnchantments());
        map.putAll(UberUtils.getMap(item));
        return map;
    }

    public static Map<Enchantment, Integer> getAllStoredMap(ItemStack item) {
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)itemMeta;
            if (meta.hasStoredEnchants()) {
                map.putAll(meta.getStoredEnchants());
            }
            map.putAll(UberUtils.getStoredMap(item));
        }
        return map;
    }

    private static <T> void addMeta(ItemStack item, UberEnchantment enchantment, NamespacedKey namespace, UberMeta<T> tag, T value) {
        UberUtils.removeEnchantmentLore(item);
        if (!UberUtils.has(item, namespace)) {
            UberUtils.createPDC(item, namespace);
        }
        if (!UberUtils.notNull(UberUtils.getPDC(item, namespace))) {
            UberUtils.addEnchantmentLore(item);
            return;
        }
        if (!UberUtils.has(UberUtils.getPDC(item, namespace), enchantment.getKey())) {
            UberUtils.set(item, namespace, TAG, UberUtils.set(UberUtils.getPDC(item, namespace), enchantment.getKey(), TAG, UberUtils.createPDC(item)));
        }
        UberUtils.setTag(item, enchantment, namespace, tag, value);
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasEnchants()) {
            UberUtils.setEnchantmentGlintOverride(meta, true);
        }
        item.setItemMeta(meta);
        UberUtils.addEnchantmentLore(item);
    }

    private static void addCustom(ItemStack item, UberEnchantment enchantment, int level, NamespacedKey namespace) {
        UberUtils.removeEnchantmentLore(item);
        if (!UberUtils.has(item, namespace)) {
            UberUtils.createPDC(item, namespace);
        }
        if (!UberUtils.notNull(UberUtils.getPDC(item, namespace))) {
            UberUtils.addEnchantmentLore(item);
            return;
        }
        if (!UberUtils.has(UberUtils.getPDC(item, namespace), enchantment.getKey())) {
            UberUtils.set(item, namespace, TAG, UberUtils.set(UberUtils.getPDC(item, namespace), enchantment.getKey(), TAG, UberUtils.createPDC(item)));
        }
        UberUtils.setTag(item, enchantment, namespace, UberMeta.LEVEL, level);
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasEnchants()) {
            UberUtils.setEnchantmentGlintOverride(meta, true);
        }
        item.setItemMeta(meta);
        UberUtils.addEnchantmentLore(item);
    }

    private static <T> void setTag(ItemStack item, UberEnchantment enchantment, NamespacedKey namespace, UberMeta<T> tag, T value) {
        PersistentDataContainer data2 = UberUtils.getPDC(item, namespace);
        PersistentDataContainer meta = UberUtils.getPDC(data2, enchantment.getKey());
        UberUtils.set(meta, tag.getKey(), tag.getType(), value);
        UberUtils.set(data2, enchantment.getKey(), TAG, meta);
        UberUtils.set(item, namespace, TAG, data2);
    }

    public static UUID getOwner(ItemStack item, UUID id) {
        PersistentDataContainer data2 = UberUtils.getPDC(item, uberEnchantment);
        return UberUtils.get(data2, UberUtils.generateKey("owner"), UUIDTag.PLAYER.getType());
    }

    public static void setOwner(ItemStack item, UUID id) {
        PersistentDataContainer data2 = UberUtils.getPDC(item, uberEnchantment);
        UberUtils.set(data2, UberUtils.generateKey("owner"), UUIDTag.PLAYER.getType(), id);
        UberUtils.set(item, uberEnchantment, TAG, data2);
    }

    public static void removeOwner(ItemStack item) {
        PersistentDataContainer data2 = UberUtils.getPDC(item, uberEnchantment);
        UberUtils.remove(data2, UberUtils.generateKey("owner"));
    }

    public static boolean hasOwner(ItemStack item) {
        PersistentDataContainer data2 = UberUtils.getPDC(item, uberEnchantment);
        return UberUtils.has(data2, UberUtils.generateKey("owner"));
    }

    private static <T> void setMeta(ItemStack item, UberEnchantment enchantment, NamespacedKey namespace, UberMeta<T> tag, T value) {
        UberUtils.removeEnchantmentLore(item);
        PersistentDataContainer data2 = UberUtils.getPDC(item, namespace);
        if (!(UberUtils.has(item, namespace) && UberUtils.notNull(data2) && UberUtils.has(data2, enchantment.getKey()))) {
            UberUtils.addEnchantmentLore(item);
            return;
        }
        UberUtils.setTag(item, enchantment, namespace, tag, value);
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasEnchants()) {
            UberUtils.setEnchantmentGlintOverride(meta, true);
        }
        item.setItemMeta(meta);
        UberUtils.addEnchantmentLore(item);
    }

    public static <T> void setMetaTag(ItemStack item, UberEnchantment enchantment, UberMeta<T> tag, T value) {
        UberUtils.setMeta(item, enchantment, uberEnchantment, tag, value);
    }

    public static <T> void setStoredMetaTag(ItemStack item, UberEnchantment enchantment, UberMeta<T> tag, T value) {
        UberUtils.setMeta(item, enchantment, storedUberEnchantment, tag, value);
    }

    public static <T> void addMetaData(ItemStack item, UberEnchantment enchantment, UberMeta<T> tag, T value) {
        UberUtils.addMeta(item, enchantment, uberEnchantment, tag, value);
    }

    public static void addData(ItemStack item, UberEnchantment enchantment, int level) {
        UberUtils.addCustom(item, enchantment, level, uberEnchantment);
        if (enchantment instanceof EffectEnchantment) {
            EffectEnchantment effect = (EffectEnchantment)enchantment;
            UberUtils.addMeta(item, enchantment, uberEnchantment, UberMeta.DURATION, level);
            effect.getTagDefaults(PersistentDataType.BOOLEAN).forEach((k, v) -> UberUtils.addMeta(item, enchantment, uberEnchantment, k.asMeta(), v));
            effect.getTagDefaults(PersistentDataType.INTEGER).forEach((k, v) -> UberUtils.addMeta(item, enchantment, uberEnchantment, k.asMeta(), v));
        }
    }

    public static void addStoredData(ItemStack item, UberEnchantment enchantment, int level) {
        UberUtils.addCustom(item, enchantment, level, storedUberEnchantment);
    }

    private static int removeCustom(ItemStack item, UberEnchantment enchantment, NamespacedKey namespace) {
        int level = 0;
        if (UberUtils.has(item, namespace)) {
            UberUtils.removeEnchantmentLore(item);
            PersistentDataContainer data2 = UberUtils.getPDC(item, namespace);
            if (data2 == null) {
                UberUtils.addEnchantmentLore(item);
                return 0;
            }
            if (UberUtils.has(data2, enchantment.getKey())) {
                level = enchantment.getLevel(item);
                UberUtils.remove(data2, enchantment.getKey());
                UberUtils.set(item, namespace, TAG, data2);
            }
            if (data2.isEmpty()) {
                UberUtils.remove(item, namespace);
            }
            ItemMeta meta = item.getItemMeta();
            if (!UberUtils.has(item, namespace)) {
                UberUtils.setEnchantmentGlintOverride(meta, null);
                item.setItemMeta(meta);
            }
            UberUtils.addEnchantmentLore(item);
        }
        return level;
    }

    private static void setEnchantmentGlintOverride(ItemMeta meta, Boolean value) {
        try {
            Method m = meta.getClass().getMethod("setEnchantmentGlintOverride", Boolean.class);
            m.setAccessible(true);
            m.invoke((Object)meta, value);
            m.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
            ignored.printStackTrace();
        }
    }

    private static <T> void delTag(ItemStack item, UberEnchantment enchantment, NamespacedKey namespace, UberMeta<T> tag) {
        PersistentDataContainer data2 = UberUtils.getPDC(item, namespace);
        PersistentDataContainer meta = UberUtils.getPDC(data2, enchantment.getKey());
        UberUtils.remove(meta, tag.getKey());
        UberUtils.set(data2, enchantment.getKey(), TAG, meta);
        UberUtils.set(item, namespace, TAG, data2);
    }

    private static <T> boolean removeTag(ItemStack item, UberEnchantment enchantment, NamespacedKey namespace, UberMeta<T> tag) {
        if (tag == UberMeta.LEVEL || tag == UberMeta.DURATION) {
            return false;
        }
        if (UberUtils.has(item, namespace)) {
            UberUtils.removeEnchantmentLore(item);
            PersistentDataContainer data2 = UberUtils.getPDC(item, namespace);
            if (data2 == null || !UberUtils.has(data2, enchantment.getKey())) {
                UberUtils.addEnchantmentLore(item);
                return false;
            }
            PersistentDataContainer meta = UberUtils.getPDC(data2, enchantment.getKey());
            if (!UberUtils.has(meta, tag.getKey())) {
                return false;
            }
            UberUtils.remove(meta, tag.getKey());
            UberUtils.set(data2, enchantment.getKey(), TAG, meta);
            UberUtils.set(item, namespace, TAG, data2);
            ItemMeta itemMeta = item.getItemMeta();
            if (UberUtils.notNull(itemMeta) && !UberUtils.has(item, namespace)) {
                UberUtils.setEnchantmentGlintOverride(itemMeta, null);
                item.setItemMeta(itemMeta);
            }
            UberUtils.addEnchantmentLore(item);
        }
        return true;
    }

    public static int removeData(ItemStack item, UberEnchantment enchantment) {
        return UberUtils.removeCustom(item, enchantment, uberEnchantment);
    }

    public static <T> boolean removeMeta(ItemStack item, UberEnchantment enchantment, UberMeta<T> tag) {
        return UberUtils.removeTag(item, enchantment, uberEnchantment, tag);
    }

    public static int removeStoredData(ItemStack item, UberEnchantment enchantment) {
        return UberUtils.removeCustom(item, enchantment, storedUberEnchantment);
    }

    public static void addEnchantment(UberEnchantment enchant, ItemStack item, int level) {
        UberUtils.addData(item, enchant, level);
    }

    public static void addEnchantments(Map<? extends Enchantment, Integer> enchants, ItemStack item) {
        EnchantmentUtils.setEnchantments(enchants, item);
    }

    public static void addStoredEnchantment(UberEnchantment enchant, ItemStack book, int level) {
        if (!book.getType().equals((Object)Material.ENCHANTED_BOOK)) {
            return;
        }
        UberUtils.addStoredData(book, enchant, level);
    }

    public static void addStoredEnchantments(Map<? extends Enchantment, Integer> enchants, ItemStack item) {
        if (!item.getType().equals((Object)Material.ENCHANTED_BOOK)) {
            return;
        }
        EnchantmentUtils.setStoredEnchantments(enchants, item);
    }

    public static int removeEnchantment(UberEnchantment enchantment, ItemStack item) {
        return UberUtils.removeData(item, enchantment);
    }

    public static int removeStoredEnchantment(UberEnchantment enchantment, ItemStack book) {
        if (!book.getType().equals((Object)Material.ENCHANTED_BOOK)) {
            return 0;
        }
        return UberUtils.removeStoredData(book, enchantment);
    }

    public static ItemStack extractEnchantment(UberEnchantment enchantment, ItemStack item) {
        if (item.hasItemMeta() && enchantment.containsEnchantment(item)) {
            ItemStack book = new ItemStack(Material.ENCHANTED_BOOK, 1);
            UberUtils.addStoredEnchantment(enchantment, book, enchantment.getLevel(item));
            return book;
        }
        return null;
    }

    public static void addEnchantmentLore(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        List<String> lore = new ArrayList();
        if (meta.hasLore()) {
            lore = meta.getLore();
        }
        Map<UberEnchantment, Integer> enchantments = item.getType() == Material.ENCHANTED_BOOK ? UberUtils.getStoredMap(item) : UberUtils.getMap(item);
        List<String> effects = enchantments.entrySet().stream().filter(data2 -> !BoolTag.HIDDEN.test(item, (UberEnchantment)((Object)((Object)data2.getKey())))).map(data2 -> {
            UberEnchantment enchantment = (UberEnchantment)((Object)((Object)data2.getKey()));
            Integer level = (Integer)data2.getValue();
            Integer duration = (Integer)data2.getValue();
            if (IntTag.DURATION.has(item, enchantment)) {
                duration = UberMeta.DURATION.get(item, enchantment);
            }
            if (duration == null) {
                duration = 0;
            }
            return UberUtils.displayName((UberEnchantment)((Object)((Object)data2.getKey())), level, duration);
        }).toList();
        lore.addAll(0, effects);
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public static void removeEnchantmentLore(ItemStack item) {
        UberUtils.update(item, uberEnchantment);
        UberUtils.update(item, storedUberEnchantment);
        ItemMeta meta = item.getItemMeta();
        int n = UberUtils.offset(item);
        if (meta.hasLore() && n > 0) {
            List lore = meta.getLore();
            if (n <= lore.size()) {
                lore.subList(0, n).clear();
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
    }

    public static String displayName(UberEnchantment enchantment, int level) {
        return UberUtils.displayName(enchantment, level, level);
    }

    public static String displayName(UberEnchantment enchantment, int level, int duration) {
        if (enchantment instanceof EffectEnchantment) {
            EffectEnchantment e = (EffectEnchantment)enchantment;
            return ChatUtils.color(UberUtils.format(enchantment.getDisplayName(), level, duration * 20));
        }
        return ChatUtils.color(enchantment.getDisplayName() + " " + UberUtils.toRomanNumeral(level));
    }

    public static int offset(ItemStack item) {
        return item.getType() == Material.ENCHANTED_BOOK ? UberUtils.getStoredMap(item).size() : (int)UberUtils.getMap(item).keySet().stream().filter(enchantment -> !BoolTag.HIDDEN.test(item, (UberEnchantment)((Object)enchantment))).count();
    }

    public static String toRomanNumeral(int number) {
        if (number < 1) {
            return "";
        }
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(1000000, "(M)");
        map.put(900000, "(C)(M)");
        map.put(500000, "(D)");
        map.put(400000, "(C)(D)");
        map.put(100000, "(C)");
        map.put(90000, "(X)(C)");
        map.put(50000, "(L)");
        map.put(40000, "(X)(L)");
        map.put(10000, "(X)");
        map.put(9000, "M(X)");
        map.put(5000, "(V)");
        map.put(4000, "M(V)");
        map.put(1000, "M");
        map.put(900, "CM");
        map.put(500, "D");
        map.put(400, "CD");
        map.put(100, "C");
        map.put(90, "XC");
        map.put(50, "L");
        map.put(40, "XL");
        map.put(10, "X");
        map.put(9, "IX");
        map.put(5, "V");
        map.put(4, "IV");
        map.put(1, "I");
        int l = map.floorKey(number);
        if (number == l) {
            return (String)map.get(number);
        }
        return (String)map.get(l) + UberUtils.toRomanNumeral(number - l);
    }

    public static String format(String name, int amplifier, int ticks) {
        double seconds = (double)ticks / 20.0;
        int minutes = (int)(seconds / 60.0);
        int hours = minutes / 60;
        int days = hours / 24;
        String s = Double.toString(seconds % 60.0);
        String a = (seconds % 60.0 < 10.0 ? "0" : "") + s.substring(0, Math.min(s.length(), 5));
        String roman = UberUtils.toRomanNumeral(amplifier);
        if (days > 0) {
            return String.format("%1$s %2$s (%3$sd %4$sh %5$sm %6$ss)", name, roman, days, hours % 24, minutes % 60, a);
        }
        if (hours > 0) {
            return String.format("%1$s %2$s (%3$sh %4$sm %5$ss)", name, roman, hours % 24, minutes % 60, a);
        }
        if (minutes > 0) {
            return String.format("%1$s %2$s (%3$sm %4$ss)", name, roman, minutes % 60, a);
        }
        return String.format("%1$s %2$s (%3$ss)", name, roman, a);
    }

    private static void update(ItemStack item, NamespacedKey namespaced) {
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer data2 = UberUtils.getPDC(item, namespaced);
        if (data2 == null) {
            return;
        }
        UberUtils.getCustomMap(item, namespaced).forEach((k, v) -> {
            if (data2.has(k.getKey(), PersistentDataType.INTEGER)) {
                data2.remove(k.getKey());
                PersistentDataContainer mdata = data2.getAdapterContext().newPersistentDataContainer();
                mdata.set(UberUtils.generateKey("level"), PersistentDataType.INTEGER, v);
                data2.set(k.getKey(), TAG, (Object)mdata);
            }
        });
        meta.getPersistentDataContainer().set(namespaced, TAG, (Object)data2);
        item.setItemMeta(meta);
    }
}

