/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.api.utils.persistence.tags;

import java.util.Map;
import java.util.Set;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.BoolTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.MetaTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.utils.BoolTagMap;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;

public enum ConditionalTag implements MetaTag<BoolTagMap>
{
    CONDITIONS;


    @Override
    public String getName() {
        return this.name().toLowerCase();
    }

    @Override
    public PersistentDataType<?, BoolTagMap> getType() {
        return new ConditionalType();
    }

    public static boolean matches(String tag) {
        return MetaTag.matches(ConditionalTag.values(), tag);
    }

    public boolean test(ItemStack item, UberEnchantment enchantment) {
        BoolTagMap boolTagMap = (BoolTagMap)this.get(item, enchantment);
        return boolTagMap != null && this.test(boolTagMap, item, enchantment);
    }

    private boolean test(BoolTagMap boolTagMap, ItemStack item, UberEnchantment enchantment) {
        Map<BoolTag, Boolean> map = boolTagMap.getMap();
        Set<Map.Entry<BoolTag, Boolean>> entries = map.entrySet();
        return !map.isEmpty() && entries.stream().allMatch(entry -> ((BoolTag)entry.getKey()).testValue(item, enchantment, (Boolean)entry.getValue()));
    }

    protected static class ConditionalType
    implements PersistentDataType<String, BoolTagMap> {
        protected ConditionalType() {
        }

        public Class<String> getPrimitiveType() {
            return String.class;
        }

        public Class<BoolTagMap> getComplexType() {
            return BoolTagMap.class;
        }

        public String toPrimitive(BoolTagMap complex, PersistentDataAdapterContext context) {
            return complex.toString();
        }

        public BoolTagMap fromPrimitive(String primitive, PersistentDataAdapterContext context) {
            return new BoolTagMap(primitive);
        }
    }
}

