/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.api.utils.persistence.tags.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.BoolTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.MetaTag;
import me.sciguymjm.uberenchant.utils.MiscUtils;

public class BoolTagMap {
    private Map<BoolTag, Boolean> map;

    public BoolTagMap() {
        this.map = new HashMap<BoolTag, Boolean>();
    }

    public BoolTagMap(Map<BoolTag, Boolean> map) {
        this.map = map;
    }

    public BoolTagMap(String string) {
        this();
        this.parse(string);
    }

    public static BoolTagMap fromString(String string) {
        return new BoolTagMap(string);
    }

    public static boolean isValid(String string) {
        for (String token : string.toLowerCase().replace(" ", "").split(",")) {
            String[] pair = token.split("=");
            if (pair.length == 2 && BoolTag.matches(pair[0]) && MiscUtils.isBool(pair[1])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.map.entrySet().stream().map(e -> String.format("%1$s=%2$s", ((BoolTag)e.getKey()).getName(), ((Boolean)e.getValue()).toString())).collect(Collectors.joining(","));
    }

    protected void parse(String string) {
        for (String token : string.toLowerCase().replace(" ", "").split(",")) {
            String[] pair = token.split("=");
            if (pair.length != 2 || !BoolTag.matches(pair[0]) || !MiscUtils.isBool(pair[1])) continue;
            BoolTag tag = BoolTag.fromString(pair[0]);
            Boolean value = Boolean.parseBoolean(pair[1]);
            this.map.put(tag, value);
        }
    }

    public Map<BoolTag, Boolean> getMap() {
        return this.map;
    }

    public void addAll(Map<? extends BoolTag, ? extends Boolean> map) {
        this.map.putAll(map);
    }

    public void addAll(String string) {
        this.parse(string);
    }

    public void setMap(Map<BoolTag, Boolean> map) {
        this.map = map;
    }

    public Boolean get(BoolTag tag) {
        return this.map.get(tag);
    }

    public void put(BoolTag tag, Boolean value) {
        this.map.put(tag, value);
    }

    public void remove(BoolTag tag) {
        this.map.remove(tag);
    }

    private record data<T>(MetaTag<T> tag, T value) {
    }
}

