/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.commands;

import java.util.List;
import me.sciguymjm.uberenchant.api.utils.UberUtils;
import me.sciguymjm.uberenchant.commands.abstraction.UberCommand;
import me.sciguymjm.uberenchant.utils.ChatUtils;
import me.sciguymjm.uberenchant.utils.Reply;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InsertCommand
extends UberCommand {
    @Override
    public boolean onCmd() {
        if (this.args.length != 0) {
            if (this.args[0].equalsIgnoreCase("lore")) {
                if (this.hasPermission("uber.insert.lore")) {
                    this.lore(this.player.getInventory().getItemInMainHand());
                    return true;
                }
                this.response(Reply.PERMISSIONS);
            }
        } else {
            this.response("&6%1$s", this.command.getUsage());
        }
        return true;
    }

    private void lore(ItemStack item) {
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        if (this.args.length < 3) {
            this.response("&a/uinsert lore &c<line#> <text...>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        int index = UberUtils.offset(item);
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasLore() || meta.hasLore() && meta.getLore().size() - index == 0) {
            this.localized("&c", "actions.lore.insert.no_lore");
            return;
        }
        List lore = meta.getLore();
        int size = lore.size() - index;
        int line = -1;
        try {
            line = Integer.parseInt(this.args[1]);
        }
        catch (NumberFormatException err) {
            StringBuilder message = new StringBuilder("&a/uinsert lore &c%1$s &a%2$s");
            if (this.args.length > 3) {
                for (int arg = 3; arg < this.args.length; ++arg) {
                    message.append(" ").append(this.args[arg]);
                }
            }
            this.response(message.toString().trim(), this.args[1], this.args[2]);
            this.localized("&c", "actions.lore.insert.line_number");
            return;
        }
        if (line > size - 1 || line < 0) {
            StringBuilder message = new StringBuilder("&a/uinsert lore &c%1$s &a%2$s");
            if (this.args.length > 3) {
                for (int arg = 3; arg < this.args.length; ++arg) {
                    message.append(" ").append(this.args[arg]);
                }
            }
            this.response(message.toString().trim(), this.args[1], this.args[2]);
            this.localized("&c", "actions.lore.insert.no_line");
            return;
        }
        if (Integer.toString(line).contains(".")) {
            StringBuilder message = new StringBuilder("&a/uinsert lore &c%1$s &a%2$s");
            if (this.args.length > 3) {
                for (int arg = 3; arg < this.args.length; ++arg) {
                    message.append(" ").append(this.args[arg]);
                }
            }
            this.response(message.toString().trim(), this.args[1], this.args[2]);
            this.response(Reply.WHOLE_NUMBER);
            return;
        }
        StringBuilder message = new StringBuilder(this.args[2]);
        if (this.args.length > 3) {
            for (int arg = 3; arg < this.args.length; ++arg) {
                message.append(" ").append(this.args[arg]);
            }
        }
        String name = ChatUtils.color(message.toString().trim());
        lore.add(index + line, name.replace("%null", ""));
        meta.setLore(lore);
        item.setItemMeta(meta);
        this.localized("a", "actions.lore.insert.success");
    }
}

