/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.commands.abstraction;

import me.sciguymjm.uberenchant.commands.abstraction.IUberCommand;
import me.sciguymjm.uberenchant.utils.ChatUtils;
import me.sciguymjm.uberenchant.utils.Reply;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class UberCommand
implements IUberCommand {
    protected Player player;
    protected Command command;
    protected String[] args;

    public final boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.command = command;
        if (sender instanceof Player) {
            Player player;
            this.player = player = (Player)sender;
            if (!this.hasPermission()) {
                this.response(Reply.PERMISSIONS);
                return true;
            }
            this.args = args;
            return this.onCmd();
        }
        return false;
    }

    public final boolean hasPermission(String node) {
        return this.player.hasPermission(node);
    }

    public final boolean hasPermission(String node, Object ... args) {
        return this.player.hasPermission(node.formatted(args));
    }

    public final boolean hasPermission(String node, String[] args) {
        return this.player.hasPermission(node.formatted(args));
    }

    public final boolean hasPermission() {
        return this.player.hasPermission(this.command.getPermission());
    }

    public final void response(String message) {
        ChatUtils.response(this.player, message);
    }

    public final void response(Reply reply) {
        ChatUtils.response(this.player, reply.get());
    }

    public final void localized(String color, String key) {
        ChatUtils.localized(this.player, color, key);
    }

    public final void localized(String color, String key, Object ... args) {
        ChatUtils.localized(this.player, color, key, args);
    }

    public final void response(String message, Object ... args) {
        ChatUtils.response(this.player, message, args);
    }

    public final void response(String message, String[] args) {
        ChatUtils.response(this.player, message, args);
    }

    public final void response(String[] messages) {
        ChatUtils.response(this.player, messages);
    }
}

