/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.enchantments.abstraction;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.api.utils.persistence.UberMeta;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.BoolTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.DoubleTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.MetaTag;
import me.sciguymjm.uberenchant.api.utils.random.WeightedChance;
import me.sciguymjm.uberenchant.api.utils.random.WeightedEntry;
import me.sciguymjm.uberenchant.enchantments.effects.BadOmenEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.BlindnessEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.ConfusionEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.DarknessEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.FastDiggingEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.HarmEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.HungerEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.IncreaseDamageEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.InfestedEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.LevitationEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.OozingEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.PoisonEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.SlowDiggingEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.SlowEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.UnLuckEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.WeaknessEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.WeavingEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.WindChargedEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.WitherEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.AbsorptionEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.ConduitPowerEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.DamageResistanceEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.DolphinsGraceEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.FireResistanceEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.GlowingEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.HealEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.HealthBoostEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.InvisibilityEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.LuckEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.RaidOmenEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.RegenerationEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.SaturationEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.TrialOmenEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.boots.JumpEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.boots.SlowFallingEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.boots.SpeedEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.helmet.HeroOfTheVillageEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.helmet.NightVisionEnchantment;
import me.sciguymjm.uberenchant.enchantments.effects.armor.helmet.WaterBreathingEnchantment;
import me.sciguymjm.uberenchant.enchantments.tasks.HeldEffectTask;
import me.sciguymjm.uberenchant.utils.UberEffects;
import me.sciguymjm.uberenchant.utils.VersionUtils;
import me.sciguymjm.uberenchant.utils.WorldGuardUtils;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;

public abstract class EffectEnchantment
extends UberEnchantment {
    private final UberEffects effect;
    private static Set<EffectEnchantment> effects;
    private final Map<MetaTag<?>, Object> TAGS;

    public Map<MetaTag<?>, Object> getDefaultTags() {
        return this.TAGS;
    }

    public <T> Map<MetaTag<T>, T> getTagDefaults(PersistentDataType<?, T> type) {
        Class t = type.getComplexType();
        return this.TAGS.entrySet().stream().filter(entry -> ((MetaTag)entry.getKey()).getType().equals(type)).collect(Collectors.toMap(entry -> {
            MetaTag tag = (MetaTag)entry.getKey();
            return MetaTag.create(tag.getName(), type, tag.getPlugin());
        }, entry -> t.cast(entry.getValue())));
    }

    public boolean hasTag(MetaTag<?> tag) {
        return this.TAGS.containsKey(tag);
    }

    public <T> void setTag(MetaTag<T> tag, T value) {
        this.TAGS.put(tag, value);
    }

    public <T> T getTag(MetaTag<T> tag) {
        return tag.getType().getComplexType().cast(this.TAGS.get(tag));
    }

    public EffectEnchantment(String key) {
        super(key);
        effects = new HashSet<EffectEnchantment>();
        this.TAGS = new HashMap();
        this.setTag(BoolTag.ON_HIT, true);
        this.effect = UberEffects.get(key);
        effects.add(this);
    }

    @Override
    public final String getPermission() {
        return String.format("uber.effect.%1$s", this.getKey().getKey().toLowerCase());
    }

    public final int getMaxLevel() {
        return 10;
    }

    public final int getStartLevel() {
        return 1;
    }

    public boolean isTreasure() {
        return false;
    }

    public boolean isCursed() {
        return false;
    }

    public boolean conflictsWith(Enchantment enchantment) {
        return false;
    }

    public String getTranslationKey() {
        return "";
    }

    public UberEffects getEffect() {
        return this.effect;
    }

    @Override
    public final String getDisplayName() {
        return this.getEffect().getDisplayName();
    }

    public int getDuration(ItemStack item) {
        Integer duration;
        if (EffectEnchantment.containsEnchantment(item, this) && (duration = UberMeta.DURATION.get(item, this)) != null) {
            return duration * 20;
        }
        return 0;
    }

    public boolean apply(ItemStack item, LivingEntity entity, int duration) {
        return new PotionEffect(this.getEffect().getEffect(), duration, this.getLevel(item) - 1, false, false).apply(entity);
    }

    public boolean apply(ItemStack item, LivingEntity entity) {
        return this.apply(item, entity, this.getDuration(item));
    }

    public static void init() {
        new SpeedEnchantment();
        new SlowEnchantment();
        new FastDiggingEnchantment();
        new SlowDiggingEnchantment();
        new IncreaseDamageEnchantment();
        new HealEnchantment();
        new HarmEnchantment();
        new JumpEnchantment();
        new ConfusionEnchantment();
        new RegenerationEnchantment();
        new DamageResistanceEnchantment();
        new FireResistanceEnchantment();
        new WaterBreathingEnchantment();
        new InvisibilityEnchantment();
        new BlindnessEnchantment();
        new NightVisionEnchantment();
        new HungerEnchantment();
        new WeaknessEnchantment();
        new PoisonEnchantment();
        new WitherEnchantment();
        new HealthBoostEnchantment();
        new AbsorptionEnchantment();
        new SaturationEnchantment();
        new GlowingEnchantment();
        new LevitationEnchantment();
        new LuckEnchantment();
        new UnLuckEnchantment();
        new SlowFallingEnchantment();
        new ConduitPowerEnchantment();
        new DolphinsGraceEnchantment();
        new BadOmenEnchantment();
        new HeroOfTheVillageEnchantment();
        if (VersionUtils.isAtLeast("1.19")) {
            new DarknessEnchantment();
        }
        if (VersionUtils.isAtLeast("1.20.5")) {
            new TrialOmenEnchantment();
            new RaidOmenEnchantment();
            new WindChargedEnchantment();
            new WeavingEnchantment();
            new OozingEnchantment();
            new InfestedEnchantment();
        }
        effects.forEach(e -> e.register());
    }

    public void apply(Entity damager, Entity damaged) {
        if (damager instanceof Player) {
            Player player = (Player)damager;
            if (damaged instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)damaged;
                ItemStack item = player.getInventory().getItemInMainHand();
                if (item.getType() != Material.AIR && this.containsEnchantment(item)) {
                    if (WorldGuardUtils.worldGuardLoaded() && !WorldGuardUtils.flag((LivingEntity)player, entity.getLocation())) {
                        return;
                    }
                    double chance = DoubleTag.CHANCE.get(item, this, (double)this.getLevel(item) / (double)this.getMaxLevel());
                    boolean outcome = (Boolean)WeightedChance.fromArray(new WeightedEntry<Boolean>(true, chance), new WeightedEntry<Boolean>(false, 1.0 - chance)).select();
                    if (outcome) {
                        this.apply(item, entity);
                    }
                }
            }
        }
    }

    public void apply(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.AIR && this.containsEnchantment(item)) {
            if (WorldGuardUtils.worldGuardLoaded() && !WorldGuardUtils.flag((LivingEntity)player, player.getLocation())) {
                return;
            }
            double chance = DoubleTag.CHANCE.get(item, this, (double)this.getLevel(item) / (double)this.getMaxLevel());
            boolean outcome = (Boolean)WeightedChance.fromArray(new WeightedEntry<Boolean>(true, chance), new WeightedEntry<Boolean>(false, 1.0 - chance)).select();
            if (outcome) {
                this.apply(item, (LivingEntity)player);
            }
        }
    }

    public boolean apply(Player player, EquipmentSlot slot, int duration, int n) {
        if (!player.isValid()) {
            return false;
        }
        ItemStack i = player.getInventory().getItem(slot);
        if (i == null || !this.containsEnchantment(i) || WorldGuardUtils.worldGuardLoaded() && !WorldGuardUtils.flag((LivingEntity)player, player.getLocation())) {
            return false;
        }
        if (n % duration == 0) {
            return this.apply(i, (LivingEntity)player);
        }
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void OnConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || item.getType() == Material.AIR || !this.containsEnchantment(item)) {
            return;
        }
        if (this.conditions(item)) {
            return;
        }
        if (BoolTag.ON_CONSUME.test(item, this)) {
            this.apply(item, (LivingEntity)player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void OnPickup(EntityPickupItemEvent event) {
        LivingEntity entity = event.getEntity();
        ItemStack item = event.getItem().getItemStack();
        if (item == null || item.getType() == Material.AIR || !this.containsEnchantment(item)) {
            return;
        }
        if (this.conditions(item)) {
            return;
        }
        if (this.testBoolTag(item, BoolTag.ON_PICKUP)) {
            this.apply(item, entity);
        }
        if (this.testBoolTag(item, BoolTag.ON_HELD)) {
            this.addTask(new HeldEffectTask(entity, this, (p, i, e) -> i.getType().equals((Object)Material.AIR) || !e.containsEnchantment(i)));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void OnDrop(EntityDropItemEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            ItemStack item = event.getItemDrop().getItemStack();
            if (item == null || item.getType() == Material.AIR || !this.containsEnchantment(item)) {
                return;
            }
            if (this.conditions(item)) {
                return;
            }
            if (this.testBoolTag(item, BoolTag.ON_DROP)) {
                this.apply(item, entity2);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void OnDrop(PlayerDropItemEvent event) {
        ItemStack item = event.getItemDrop().getItemStack();
        if (item == null || item.getType() == Material.AIR || !this.containsEnchantment(item)) {
            return;
        }
        if (this.conditions(item)) {
            return;
        }
        if (this.testBoolTag(item, BoolTag.ON_DROP)) {
            this.apply(item, (LivingEntity)event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void OnHeld(PlayerItemHeldEvent event) {
        ItemStack item = event.getPlayer().getInventory().getItem(event.getNewSlot());
        if (item == null || item.getType() == Material.AIR || !this.containsEnchantment(item)) {
            return;
        }
        if (this.conditions(item)) {
            return;
        }
        if (BoolTag.ON_HELD.test(item, this)) {
            this.addTask(new HeldEffectTask((LivingEntity)event.getPlayer(), this, (p, i, e) -> i.getType().equals((Object)Material.AIR) || !e.containsEnchantment(i) || !BoolTag.ON_HELD.test(i, e)));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void OnHit(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            entity = event.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                ItemStack item = player.getInventory().getItemInMainHand();
                if (item.getType() == Material.AIR || !this.containsEnchantment(item) || !BoolTag.ON_HIT.test(item, this)) {
                    return;
                }
                if (WorldGuardUtils.worldGuardLoaded() && !WorldGuardUtils.flag((LivingEntity)player, entity2.getLocation())) {
                    return;
                }
                if (this.conditions(item)) {
                    return;
                }
                if (!BoolTag.HAS_CHANCE.test(item, this)) {
                    this.apply(item, entity2);
                    return;
                }
                double chance = DoubleTag.CHANCE.get(item, this, (double)this.getLevel(item) / (double)this.getMaxLevel());
                boolean outcome = (Boolean)WeightedChance.fromArray(new WeightedEntry<Boolean>(true, chance), new WeightedEntry<Boolean>(false, 1.0 - chance)).select();
                if (outcome) {
                    this.apply(item, entity2);
                }
            }
        }
    }
}

