/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.enchantments.tasks;

import me.sciguymjm.uberenchant.api.utils.UberTask;
import me.sciguymjm.uberenchant.enchantments.abstraction.EffectEnchantment;
import me.sciguymjm.uberenchant.enchantments.tasks.Conditional;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class EffectTask
implements UberTask {
    protected LivingEntity entity;
    protected ItemStack item;
    protected EffectEnchantment enchantment;
    protected PotionEffectType effect;
    protected Conditional conditional;
    protected int n;
    protected int duration;

    public EffectTask(LivingEntity entity, EffectEnchantment enchantment, Conditional conditional) {
        this.entity = entity;
        this.enchantment = enchantment;
        this.effect = enchantment.getEffect().getEffect();
        this.conditional = conditional;
        this.n = 300;
        this.duration = 300;
    }

    @Override
    public boolean update() {
        if (!this.entity.isValid() || this.entity.isDead()) {
            return false;
        }
        this.item = this.getItem();
        if (this.item == null || this.conditional.test(this.entity, this.item, this.enchantment)) {
            this.entity.removePotionEffect(this.effect);
            return false;
        }
        if (this.n++ >= this.duration - 60) {
            this.n = 0;
            return this.enchantment.apply(this.item, this.entity, this.duration);
        }
        if (!this.entity.hasPotionEffect(this.effect)) {
            return this.enchantment.apply(this.item, this.entity, this.duration);
        }
        return true;
    }

    @Override
    public ItemStack getItem() {
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof HumanEntity) {
            HumanEntity human = (HumanEntity)livingEntity;
            return human.getInventory().getItemInMainHand();
        }
        return this.entity.getEquipment().getItemInMainHand();
    }
}

