/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.utils;

import java.io.File;
import java.io.IOException;
import me.sciguymjm.uberenchant.UberEnchant;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileUtils {
    public static void initResource(String path) {
        File f = new File(UberEnchant.instance().getDataFolder() + "/" + path);
        if (!f.exists()) {
            UberEnchant.instance().saveResource(path, false);
        }
    }

    public static File getFile(String path) {
        return new File(UberEnchant.instance().getDataFolder() + path);
    }

    public static YamlConfiguration loadConfig(String path) {
        File f = FileUtils.getFile(path);
        if (!f.exists()) {
            return null;
        }
        return YamlConfiguration.loadConfiguration((File)f);
    }

    public static YamlConfiguration loadConfig(File file) {
        if (!file.exists()) {
            return null;
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static <T> T get(String path, String key, Object def, Class<T> type) {
        return type.cast(FileUtils.loadConfig(path).get(key, def));
    }

    public static <T> T updateAndGet(String path, String key, Object def, Class<T> type) {
        if (!FileUtils.contains(path, key)) {
            FileUtils.set(path, key, def);
        }
        return FileUtils.get(path, key, def, type);
    }

    public static boolean contains(String path, String key) {
        return FileUtils.loadConfig(path).contains(key);
    }

    public static void set(String path, String key, Object value) {
        File file = FileUtils.getFile(path);
        YamlConfiguration config = FileUtils.loadConfig(file);
        config.set(key, value);
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.getCause().printStackTrace();
        }
    }
}

