/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.sciguymjm.uberenchant.utils.UberEffectsWrapper;
import me.sciguymjm.uberenchant.utils.UberLocale;
import me.sciguymjm.uberenchant.utils.VersionUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.potion.PotionEffectType;

public class UberEffects {
    private final PotionEffectType effect;
    private final String name;
    private final String display;
    private final int id;
    private final int value;
    public static Map<String, UberEffects> values = new HashMap<String, UberEffects>();

    private static PotionEffectType getType(String key) {
        NamespacedKey namespacedKey = NamespacedKey.minecraft((String)key.toLowerCase());
        return VersionUtils.isAtLeast("1.20.4") ? (PotionEffectType)Registry.EFFECT.get(namespacedKey) : PotionEffectType.getByName((String)namespacedKey.getKey().toUpperCase());
    }

    private static PotionEffectType getType(String ... s) {
        Version[] v = new Version[s.length];
        for (int i = 0; i < s.length; ++i) {
            String[] split = s[i].split(":");
            v[i] = UberEffects.v(split[0], split[1]);
        }
        Version version = Arrays.stream(v).sorted((a, b) -> b.version.compareTo(a.version)).filter(ver -> VersionUtils.isAtLeast(ver.version)).findFirst().orElse(null);
        NamespacedKey key = NamespacedKey.minecraft((String)version.type.toLowerCase());
        return VersionUtils.isAtLeast("1.20.4") ? (PotionEffectType)Registry.EFFECT.get(key) : PotionEffectType.getByName((String)key.getKey().toUpperCase());
    }

    private static Version v(String type, String version) {
        return new Version(type, version);
    }

    private static UberEffectsWrapper wrap(PotionEffectType effect, String name, String display, int id, int value) {
        return new UberEffectsWrapper(effect, name, UberLocale.get(display), id, value);
    }

    UberEffects(PotionEffectType effect, String name, String display, int id, int value) {
        this.effect = effect;
        this.name = name;
        this.display = this.color(display, value);
        this.id = id;
        this.value = value;
    }

    public PotionEffectType getEffect() {
        return this.effect;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.display;
    }

    public int getId() {
        return this.id;
    }

    public int getValue() {
        return this.value;
    }

    public static UberEffects byName(String s) {
        return values.values().stream().filter(e -> e.name.equalsIgnoreCase(s)).findFirst().orElse(null);
    }

    public static UberEffects get(String s) {
        return values.get(s);
    }

    public static UberEffects getByType(PotionEffectType type) {
        return values.values().stream().filter(e -> type.equals(e.effect)).findFirst().orElse(null);
    }

    public static List<UberEffects> ofValue(int v) {
        return values.values().stream().filter(e -> e.value == v).collect(Collectors.toList());
    }

    public static boolean valuesContain(int v, PotionEffectType effect) {
        return values.values().stream().anyMatch(e -> e.value == v && e.effect.equals(effect));
    }

    private String color(String display, int value) {
        return switch (value) {
            case -1 -> "&c" + display;
            case 0 -> "&f" + display;
            case 1 -> "&9" + display;
            default -> display;
        };
    }

    public static UberEffects[] values() {
        return (UberEffects[])values.values().toArray(UberEffects[]::new);
    }

    static {
        values.put("SPEED", UberEffects.wrap(PotionEffectType.SPEED, "speed", "effects.speed", 1, 1));
        values.put("SLOW", UberEffects.wrap(UberEffects.getType("SLOW:0", "SLOWNESS:1.20.4"), "slowness", "effects.slow", 2, -1));
        values.put("FAST_DIGGING", UberEffects.wrap(UberEffects.getType("FAST_DIGGING:0", "HASTE:1.20.4"), "haste", "effects.fast_digging", 3, 1));
        values.put("SLOW_DIGGING", UberEffects.wrap(UberEffects.getType("SLOW_DIGGING:0", "MINING_FATIGUE:1.20.4"), "miningfatigue", "effects.slow_digging", 4, -1));
        values.put("INCREASE_DAMAGE", UberEffects.wrap(UberEffects.getType("INCREASE_DAMAGE:0", "STRENGTH:1.20.4"), "strength", "effects.increase_damage", 5, 1));
        values.put("HEAL", UberEffects.wrap(UberEffects.getType("HEAL:0", "INSTANT_HEALTH:1.20.4"), "instanthealth", "effects.heal", 6, 1));
        values.put("HARM", UberEffects.wrap(UberEffects.getType("HARM:0", "INSTANT_DAMAGE:1.20.4"), "instantdamage", "effects.harm", 7, -1));
        values.put("JUMP", UberEffects.wrap(UberEffects.getType("JUMP:0", "JUMP_BOOST:1.20.4"), "jumpboost", "effects.jump", 8, 1));
        values.put("CONFUSION", UberEffects.wrap(UberEffects.getType("CONFUSION:0", "NAUSEA:1.20.4"), "nausea", "effects.confusion", 9, -1));
        values.put("REGENERATION", UberEffects.wrap(PotionEffectType.REGENERATION, "regeneration", "effects.regeneration", 10, 1));
        values.put("DAMAGE_RESISTANCE", UberEffects.wrap(UberEffects.getType("DAMAGE_RESISTANCE:0", "RESISTANCE:1.20.4"), "resistance", "effects.damage_resistance", 11, 1));
        values.put("FIRE_RESISTANCE", UberEffects.wrap(PotionEffectType.FIRE_RESISTANCE, "fireresistance", "effects.fire_resistance", 12, 1));
        values.put("WATER_BREATHING", UberEffects.wrap(PotionEffectType.WATER_BREATHING, "waterbreathing", "effects.water_breathing", 13, 1));
        values.put("INVISIBILITY", UberEffects.wrap(PotionEffectType.INVISIBILITY, "invisibility", "effects.invisibility", 14, 1));
        values.put("BLINDNESS", UberEffects.wrap(PotionEffectType.BLINDNESS, "blindness", "effects.blindness", 15, -1));
        values.put("NIGHT_VISION", UberEffects.wrap(PotionEffectType.NIGHT_VISION, "nightvision", "effects.night_vision", 16, 1));
        values.put("HUNGER", UberEffects.wrap(PotionEffectType.HUNGER, "hunger", "effects.hunger", 17, -1));
        values.put("WEAKNESS", UberEffects.wrap(PotionEffectType.WEAKNESS, "weakness", "effects.weakness", 18, -1));
        values.put("POISON", UberEffects.wrap(PotionEffectType.POISON, "poison", "effects.poison", 19, -1));
        values.put("WITHER", UberEffects.wrap(PotionEffectType.WITHER, "wither", "effects.wither", 20, -1));
        values.put("HEALTH_BOOST", UberEffects.wrap(PotionEffectType.HEALTH_BOOST, "healthboost", "effects.health_boost", 21, 1));
        values.put("ABSORPTION", UberEffects.wrap(PotionEffectType.ABSORPTION, "absorption", "effects.absorption", 22, 1));
        values.put("SATURATION", UberEffects.wrap(PotionEffectType.SATURATION, "saturation", "effects.saturation", 23, 1));
        values.put("GLOWING", UberEffects.wrap(PotionEffectType.GLOWING, "glowing", "effects.glowing", 24, 0));
        values.put("LEVITATION", UberEffects.wrap(PotionEffectType.LEVITATION, "levitation", "effects.levitation", 25, 0));
        values.put("LUCK", UberEffects.wrap(PotionEffectType.LUCK, "luck", "effects.luck", 26, 1));
        values.put("UNLUCK", UberEffects.wrap(PotionEffectType.UNLUCK, "badluck", "effects.unluck", 27, -1));
        values.put("SLOW_FALLING", UberEffects.wrap(PotionEffectType.SLOW_FALLING, "slowfalling", "effects.slow_falling", 28, 1));
        values.put("CONDUIT_POWER", UberEffects.wrap(PotionEffectType.CONDUIT_POWER, "conduitpower", "effects.conduit_power", 29, 1));
        values.put("DOLPHINS_GRACE", UberEffects.wrap(PotionEffectType.DOLPHINS_GRACE, "dolphinsgrace", "effects.dolphins_grace", 30, 1));
        values.put("BAD_OMEN", UberEffects.wrap(PotionEffectType.BAD_OMEN, "badomen", "effects.bad_omen", 31, -1));
        values.put("HERO_OF_THE_VILLAGE", UberEffects.wrap(PotionEffectType.HERO_OF_THE_VILLAGE, "heroofthevillage", "effects.hero_of_the_village", 32, 1));
        if (VersionUtils.isAtLeast("1.19")) {
            values.put("DARKNESS", UberEffects.wrap(PotionEffectType.DARKNESS, "darkness", "effects.darkness", 33, -1));
        }
        if (VersionUtils.isAtLeast("1.20.5")) {
            values.put("TRIAL_OMEN", UberEffects.wrap(UberEffects.getType("TRIAL_OMEN"), "trialomen", "effects.trial_omen", 34, 0));
            values.put("RAID_OMEN", UberEffects.wrap(UberEffects.getType("RAID_OMEN"), "raidomen", "effects.raid_omen", 35, 0));
            values.put("WIND_CHARGED", UberEffects.wrap(UberEffects.getType("WIND_CHARGED"), "windcharged", "effects.wind_charged", 36, -1));
            values.put("WEAVING", UberEffects.wrap(UberEffects.getType("WEAVING"), "weaving", "effects.weaving", 37, -1));
            values.put("OOZING", UberEffects.wrap(UberEffects.getType("OOZING"), "oozing", "effects.oozing", 38, -1));
            values.put("INFESTED", UberEffects.wrap(UberEffects.getType("INFESTED"), "infested", "effects.infested", 39, -1));
        }
    }

    private record Version(String type, String version) {
    }
}

