/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.utils.enchanting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.api.events.UberEnchantmentsAddedEvent;
import me.sciguymjm.uberenchant.api.utils.UberUtils;
import me.sciguymjm.uberenchant.utils.FileUtils;
import me.sciguymjm.uberenchant.utils.VersionUtils;
import me.sciguymjm.uberenchant.utils.enchanting.CustomOffer;
import me.sciguymjm.uberenchant.utils.enchanting.EnchantmentTableUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;

public class EnchantmentTableEvents
implements Listener {
    private Map<UUID, CustomOffer> players = new HashMap<UUID, CustomOffer>();
    private Map<UUID, Map<UberEnchantment, Integer>> books = new HashMap<UUID, Map<UberEnchantment, Integer>>();
    public static List<String> disabled;

    public EnchantmentTableEvents() {
        EnchantmentTableEvents.reloadEnabled();
    }

    public static void reloadEnabled() {
        disabled = FileUtils.loadConfig("/mechanics/enchantment_table.yml").getStringList("disabled_enchantments");
        if (FileUtils.get("/mechanics/enchantment_table.yml", "disable_effect_enchantments", true, Boolean.class).booleanValue()) {
            disabled.addAll(UberEnchantment.getRegisteredEnchantments().stream().map(e -> e.getKey().getKey()).toList());
        }
    }

    public static boolean isDisabled(Enchantment enchant) {
        return disabled.contains(VersionUtils.getKey(enchant).getKey());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPrepare(PrepareItemEnchantEvent event) {
        UUID id = event.getEnchanter().getUniqueId();
        if (!EnchantmentTableUtils.seed.containsKey(id)) {
            EnchantmentTableUtils.seed.put(id, new Random().nextLong());
        }
        CustomOffer e = new CustomOffer(event, -1);
        this.players.put(id, e);
        if (event.getItem().getType().equals((Object)Material.ENCHANTED_BOOK) && this.books.containsKey(id)) {
            UberUtils.addStoredEnchantments(this.books.get(id), event.getItem());
            this.books.remove(id);
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (event.getInventory().getType().equals((Object)InventoryType.ENCHANTING)) {
            this.players.remove(event.getPlayer().getUniqueId());
            this.books.remove(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEnchant(EnchantItemEvent event) {
        UUID id = event.getEnchanter().getUniqueId();
        if (this.players.containsKey(id)) {
            Map map = event.getEnchantsToAdd();
            int size = map.size() * 2;
            if (size > 5) {
                size = 5;
            }
            map.clear();
            CustomOffer e = this.players.get(event.getEnchanter().getUniqueId());
            e.setSlot(event.whichButton());
            this.players.get(id).setHasEnchanted(true);
            EnchantmentTableUtils.CustomList list = e.getList();
            List<EnchantmentTableUtils.WeightedEnchantment> vList = list.vanilla();
            List<EnchantmentTableUtils.WeightedEnchantment> cList = list.custom();
            HashMap<UberEnchantment, Integer> cMap = new HashMap<UberEnchantment, Integer>();
            for (int n = 0; n < size; ++n) {
                Enchantment enchantment;
                EnchantmentTableUtils.WeightedEnchantment enchant;
                if (!vList.isEmpty() && n < vList.size()) {
                    enchant = list.vanilla().get(n);
                    map.put(enchant.getEnchantment(), enchant.getLevel());
                }
                if (cList.isEmpty() || n >= cList.size() || !((enchantment = (enchant = list.custom().get(n)).getEnchantment()) instanceof UberEnchantment)) continue;
                UberEnchantment uber = (UberEnchantment)enchantment;
                cMap.put(uber, enchant.getLevel());
            }
            this.players.remove(id);
            if (e.getOffer() != null) {
                map.put(e.getOffer().getEnchantment(), e.getOffer().getEnchantmentLevel());
            } else {
                map.put(event.getEnchantmentHint(), event.getLevelHint());
            }
            if (event.getItem().getType().equals((Object)Material.BOOK)) {
                this.books.put(id, cMap);
            } else {
                UberUtils.addEnchantments(cMap, event.getItem());
            }
            EnchantmentTableUtils.seed.put(id, new Random().nextLong());
            HashMap<Enchantment, Integer> big = new HashMap<Enchantment, Integer>(map);
            big.putAll(cMap);
            UberEnchantmentsAddedEvent ce = new UberEnchantmentsAddedEvent(event.getEnchanter(), event.getItem(), big);
            Bukkit.getServer().getPluginManager().callEvent((Event)ce);
        }
    }
}

