/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.api.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import me.sciguymjm.uberenchant.UberEnchant;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.utils.UberLocale;
import me.sciguymjm.uberenchant.utils.VersionUtils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.plugin.Plugin;

public class UberConfiguration {
    private static Set<UberRecord> values = new HashSet<UberRecord>();
    private static Set<String> plugins = new HashSet<String>();
    private static final Set<File> files = new HashSet<File>();

    public static Set<String> getIntegrated() {
        return plugins;
    }

    public static Set<UberRecord> getRecords() {
        return values;
    }

    public static List<UberRecord> getRecords(Predicate<UberRecord> filter) {
        return values.stream().filter(filter).toList();
    }

    public static void loadFromFile(File file) {
        YamlConfiguration data2 = YamlConfiguration.loadConfiguration((File)file);
        files.add(file);
        List<Object> temp = VersionUtils.isAtLeast("1.20") ? new ArrayList(Registry.ENCHANTMENT.stream().toList()) : Arrays.asList(Enchantment.values());
        Collections.addAll(temp, UberEnchantment.values());
        for (Enchantment enchant : temp) {
            if (values.stream().anyMatch(e -> e.enchantment.equals(enchant)) || !data2.contains(enchant.getKey().getKey(), true)) continue;
            HashMap<Integer, Double> list = new HashMap<Integer, Double>();
            ConfigurationSection section = data2.getConfigurationSection(enchant.getKey().getKey().toLowerCase());
            if (!section.contains("cost_for_level")) {
                ConfigurationSection cost = section.createSection("cost_for_level");
                cost.createSection("1");
                cost.createSection("5");
                cost.createSection("10");
                if (enchant.getKey().getKey().toLowerCase().contains("curse") || enchant.isCursed()) {
                    cost.set("1", (Object)100.0);
                    cost.set("5", (Object)600.0);
                    cost.set("10", (Object)1700.0);
                } else {
                    cost.set("1", (Object)1000.0);
                    cost.set("5", (Object)6000.0);
                    cost.set("10", (Object)17000.0);
                }
                try {
                    data2.save(file);
                    data2 = YamlConfiguration.loadConfiguration((File)file);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            ConfigurationSection section2 = data2.getConfigurationSection(enchant.getKey().getKey().toLowerCase() + ".cost_for_level");
            section2.getKeys(false).forEach(key -> {
                try {
                    Integer level = Integer.parseInt(key);
                    Double cost = section2.getDouble(key);
                    list.put(level, cost);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            NamespacedKey key2 = VersionUtils.isAtLeast("1.21.4") ? enchant.getKeyOrNull() : enchant.getKey();
            UberRecord record = new UberRecord(enchant, key2, enchant instanceof UberEnchantment ? ((UberEnchantment)enchant).getDisplayName() : UberLocale.get(enchant.getKey().toString().replace(":", ".")), section.getInt("min_level"), section.getInt("max_level"), section.getDouble("cost"), section.getDouble("cost_multiplier"), section.getDouble("removal_cost"), section.getDouble("extraction_cost"), section.getBoolean("use_on_anything"), section.getStringList("aliases"), list);
            UberConfiguration.addRecord(record);
        }
    }

    public static void loadFromFile(String path) {
        UberConfiguration.loadFromFile(new File(path));
    }

    public static void loadFromFile(String path, String file) {
        UberConfiguration.loadFromFile(new File(path, file));
    }

    public static void loadFromEnchantmentsFolder() {
        File folder = new File(UberEnchant.instance().getDataFolder() + "/enchantments/");
        for (File path : folder.listFiles()) {
            if (path.isDirectory()) {
                for (File file : path.listFiles(f -> f.getName().endsWith(".yml"))) {
                    UberConfiguration.loadFromFile(file);
                }
                continue;
            }
            if (!path.getName().endsWith(".yml")) continue;
            UberConfiguration.loadFromFile(path);
        }
    }

    public static void saveToEnchantmentsFolder(Plugin plugin, String file) {
        UberConfiguration.saveToFile(plugin, new File(UberEnchant.instance().getDataFolder() + "/enchantments/" + plugin.getName() + "/" + file));
    }

    public static void saveToFile(Plugin plugin, String path) {
        UberConfiguration.saveToFile(plugin, new File(plugin.getDataFolder(), path));
    }

    public static void saveToFile(Plugin plugin, File file) {
        YamlConfiguration data2 = YamlConfiguration.loadConfiguration((File)file);
        for (UberRecord record : values.stream().filter(a -> a.enchantment.getKey().getNamespace().equals(plugin.getName().toLowerCase(Locale.ROOT))).toList()) {
            ConfigurationSection path = data2.createSection(record.key.getKey());
            path.set("min_level", (Object)record.min_level);
            path.set("max_level", (Object)record.max_level);
            path.set("cost", (Object)record.cost);
            path.set("cost_multiplier", (Object)record.cost_multiplier);
            path.createSection("cost_for_level", record.cost_for_level);
            path.set("removal_cost", (Object)record.removal_cost);
            path.set("extraction_cost", (Object)record.extraction_cost);
            path.set("use_on_anything", (Object)record.can_use_on_anything);
            path.set("aliases", record.aliases);
        }
        try {
            data2.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void reloadAll() {
        values = new HashSet<UberRecord>();
        files.forEach(f -> {
            if (f.exists()) {
                UberConfiguration.loadFromFile(f);
            }
        });
    }

    public static UberRecord getByEnchant(Enchantment enchantment) {
        return values.stream().filter(e -> e.enchantment.equals(enchantment)).findFirst().orElse(null);
    }

    public static void registerUberRecord(UberEnchantment enchantment, double cost, double multiplier, double removal, double extract, boolean anything, List<String> aliases, Map<Integer, Double> level_cost) {
        if (!UberEnchantment.isRegistered(enchantment)) {
            UberEnchantment.register(enchantment);
        }
        UberConfiguration.addRecord(new UberRecord(enchantment, enchantment.getKey(), enchantment.getDisplayName(), enchantment.getStartLevel(), enchantment.getMaxLevel(), cost, multiplier, removal, extract, anything, aliases, level_cost));
    }

    public static boolean addRecord(UberRecord record) {
        if (values.stream().noneMatch(r -> r.enchantment.equals(record.enchantment))) {
            return values.add(record);
        }
        return false;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> key) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(key.apply(t), Boolean.TRUE) == null;
    }

    public static void integrate() {
        List<Object> temp = VersionUtils.isAtLeast("1.20") ? new ArrayList(Registry.ENCHANTMENT.stream().toList()) : Arrays.asList(Enchantment.values());
        List<String> plugins = temp.stream().filter(UberConfiguration.distinctByKey(e -> e.getKey().getNamespace())).filter(e -> !(e instanceof UberEnchantment) && !e.getKey().getNamespace().equalsIgnoreCase("minecraft")).map(k -> k.getKey().getNamespace()).toList();
        for (String name : plugins) {
            Plugin plugin = Arrays.stream(Bukkit.getPluginManager().getPlugins()).filter(p -> p.getName().toLowerCase(Locale.ROOT).equals(name)).findFirst().orElse(null);
            if (plugin == null) continue;
            UberConfiguration.plugins.add(name);
            File file = new File(UberEnchant.instance().getDataFolder() + "/enchantments/" + name + "/default_enchantments.yml");
            if (file.exists()) {
                return;
            }
            YamlConfiguration data2 = YamlConfiguration.loadConfiguration((File)file);
            List<Enchantment> enchantments = temp.stream().filter(a -> a.getKey().getNamespace().toString().equalsIgnoreCase(name)).toList();
            for (Enchantment enchant : enchantments) {
                ConfigurationSection path = data2.createSection(enchant.getKey().getKey());
                path.set("min_level", (Object)1);
                path.set("max_level", (Object)10);
                path.set("cost", (Object)1000.0);
                path.set("cost_multiplier", (Object)0.02);
                path.set("removal_cost", (Object)100.0);
                path.set("extraction_cost", (Object)1000.0);
                path.set("use_on_anything", (Object)false);
                path.set("aliases", new ArrayList());
            }
            try {
                data2.save(file);
                UberEnchant.log(Level.INFO, UberLocale.getF("console.plugin_integrated", enchantments.size(), plugin.getName()));
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public record UberRecord(Enchantment enchantment, NamespacedKey key, String display_name, int min_level, int max_level, double cost, double cost_multiplier, double removal_cost, double extraction_cost, boolean can_use_on_anything, List<String> aliases, Map<Integer, Double> cost_for_level) {
        public Enchantment getEnchant() {
            return this.enchantment;
        }

        public String getName() {
            return this.key.getKey();
        }

        public NamespacedKey getKey() {
            return this.key;
        }

        public String getDisplayName() {
            return this.display_name;
        }

        public int getMinLevel() {
            return this.min_level;
        }

        public int getMaxLevel() {
            return this.max_level;
        }

        public double getCost() {
            return this.cost;
        }

        public double getCostMultiplier() {
            return this.cost_multiplier;
        }

        public double getRemovalCost() {
            return this.removal_cost;
        }

        public double getExtractionCost() {
            return this.extraction_cost;
        }

        public boolean getCanUseOnAnything() {
            return this.can_use_on_anything;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public Map<Integer, Double> getCostForLevel() {
            return this.cost_for_level;
        }

        public static Set<UberRecord> values() {
            return values;
        }
    }
}

