/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.api.utils.persistence;

import me.sciguymjm.uberenchant.api.utils.persistence.PDCUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PDCItemUtils
extends PDCUtils {
    public static boolean has(ItemStack item, NamespacedKey key) {
        if (!PDCItemUtils.notNull(item, key)) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return PDCItemUtils.notNull(meta) && PDCItemUtils.has(meta.getPersistentDataContainer(), key);
    }

    public static boolean has(ItemStack item, NamespacedKey key, PersistentDataType<?, ?> type) {
        return PDCItemUtils.has(item, key) && PDCItemUtils.has(item.getItemMeta().getPersistentDataContainer(), key, type);
    }

    public static <T> T get(ItemStack item, NamespacedKey key, PersistentDataType<?, T> type) {
        return PDCItemUtils.has(item, key, type) ? (T)PDCItemUtils.get(item.getItemMeta().getPersistentDataContainer(), key, type) : null;
    }

    public static PersistentDataContainer getPDC(ItemStack item) {
        return PDCItemUtils.notNull(item, item.getItemMeta()) ? item.getItemMeta().getPersistentDataContainer() : null;
    }

    public static PersistentDataContainer getPDC(ItemStack item, NamespacedKey key) {
        return PDCItemUtils.has(item, key, TAG) ? PDCItemUtils.getPDC(item.getItemMeta().getPersistentDataContainer(), key) : null;
    }

    public static PersistentDataContainer getOrCreatePDC(ItemStack item, NamespacedKey key) {
        return PDCItemUtils.has(item, key, TAG) ? PDCItemUtils.getPDC(item, key) : PDCItemUtils.createPDC(item, key);
    }

    public static <T> PersistentDataContainer set(ItemStack item, NamespacedKey key, PersistentDataType<?, T> type, T value) {
        ItemMeta meta = item.getItemMeta();
        if (!PDCItemUtils.notNull(meta)) {
            return null;
        }
        PersistentDataContainer pdc = PDCItemUtils.set(meta.getPersistentDataContainer(), key, type, value);
        item.setItemMeta(meta);
        return pdc;
    }

    public static void remove(ItemStack item, NamespacedKey key) {
        if (!PDCItemUtils.notNull(item, item.getItemMeta())) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = PDCItemUtils.getPDC(item);
        if (PDCItemUtils.notNull(pdc)) {
            PDCItemUtils.remove(pdc, key);
        }
        item.setItemMeta(meta);
    }

    public static PersistentDataContainer createPDC(ItemStack item) {
        PersistentDataContainer pdc = PDCItemUtils.getPDC(item);
        if (PDCItemUtils.notNull(pdc)) {
            return pdc.getAdapterContext().newPersistentDataContainer();
        }
        return null;
    }

    public static PersistentDataContainer createPDC(ItemStack item, NamespacedKey key) {
        return PDCItemUtils.set(item, key, TAG, PDCItemUtils.createPDC(item));
    }
}

