/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.api.utils.persistence;

import me.sciguymjm.uberenchant.UberEnchant;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PDCUtils {
    protected static PersistentDataType<PersistentDataContainer, PersistentDataContainer> TAG = PersistentDataType.TAG_CONTAINER;

    protected static boolean notNull(Object ... objects) {
        if (objects == null) {
            return false;
        }
        for (Object object : objects) {
            if (object != null) continue;
            return false;
        }
        return true;
    }

    protected static NamespacedKey generateKey(String key) {
        return new NamespacedKey((Plugin)UberEnchant.instance(), key);
    }

    public static boolean has(PersistentDataContainer pdc, NamespacedKey key) {
        return PDCUtils.notNull(pdc, key) && pdc.has(key);
    }

    public static boolean has(PersistentDataContainer pdc, NamespacedKey key, PersistentDataType<?, ?> type) {
        return PDCUtils.notNull(pdc, key, type) && pdc.has(key, type);
    }

    public static <T> T get(PersistentDataContainer pdc, NamespacedKey key, PersistentDataType<?, T> type) {
        return (T)(PDCUtils.has(pdc, key, type) ? pdc.get(key, type) : null);
    }

    public static PersistentDataContainer getPDC(PersistentDataContainer pdc, NamespacedKey key) {
        return PDCUtils.has(pdc, key, TAG) ? PDCUtils.get(pdc, key, TAG) : null;
    }

    public static <T> PersistentDataContainer set(PersistentDataContainer pdc, NamespacedKey key, PersistentDataType<?, T> type, T value) {
        if (PDCUtils.notNull(pdc, key, type, value)) {
            pdc.set(key, type, value);
        }
        return pdc;
    }

    public static void remove(PersistentDataContainer pdc, NamespacedKey key) {
        if (PDCUtils.notNull(pdc, key)) {
            pdc.remove(key);
        }
    }

    public static PersistentDataContainer createPDC(PersistentDataContainer pdc) {
        if (PDCUtils.notNull(pdc)) {
            return pdc.getAdapterContext().newPersistentDataContainer();
        }
        return null;
    }

    public static PersistentDataContainer createPDC(PersistentDataContainer pdc, NamespacedKey key) {
        return PDCUtils.set(pdc, key, TAG, PDCUtils.createPDC(pdc));
    }
}

