/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.api.events.UberEnchantmentsAddedEvent;
import me.sciguymjm.uberenchant.api.utils.UberConfiguration;
import me.sciguymjm.uberenchant.api.utils.UberRunnable;
import me.sciguymjm.uberenchant.api.utils.UberUtils;
import me.sciguymjm.uberenchant.api.utils.persistence.UberMeta;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.BoolTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.DoubleTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.IntTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.MetaTag;
import me.sciguymjm.uberenchant.commands.abstraction.UberTabCommand;
import me.sciguymjm.uberenchant.enchantments.abstraction.EffectEnchantment;
import me.sciguymjm.uberenchant.enchantments.tasks.HeldEffectTask;
import me.sciguymjm.uberenchant.utils.ChatUtils;
import me.sciguymjm.uberenchant.utils.EconomyUtils;
import me.sciguymjm.uberenchant.utils.EffectUtils;
import me.sciguymjm.uberenchant.utils.Reply;
import me.sciguymjm.uberenchant.utils.enchanting.EnchantmentUtils;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;

public class AddCommand
extends UberTabCommand {
    @Override
    public boolean onCmd() {
        if (this.args.length != 0) {
            ItemStack item = this.player.getInventory().getItemInMainHand();
            switch (this.args[0].toLowerCase()) {
                case "enchant": {
                    if (this.hasPermission("uber.add.enchant")) {
                        this.enchant(item);
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "effect": {
                    if (this.hasPermission("uber.add.effect")) {
                        this.effect();
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "lore": {
                    if (this.hasPermission("uber.add.lore")) {
                        this.lore(item);
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "meta": {
                    if (this.hasPermission("uber.add.meta")) {
                        this.meta(item);
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "name": {
                    if (this.hasPermission("uber.add.name")) {
                        this.name(item);
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                default: {
                    EnchantmentUtils.help(this.player, "uadd");
                    break;
                }
            }
        } else {
            this.response("&6%1$s", this.command.getUsage());
        }
        return true;
    }

    @Override
    public List<String> onTab() {
        List<String> list = new ArrayList<String>();
        if (this.args.length == 1) {
            if (this.hasPermission("uber.add.enchant")) {
                list.add("enchant");
            }
            if (this.hasPermission("uber.add.effect")) {
                list.add("effect");
            }
            if (this.hasPermission("uber.add.lore")) {
                list.add("lore");
            }
            if (this.hasPermission("uber.add.meta")) {
                list.add("meta");
            }
            if (this.hasPermission("uber.add.name")) {
                list.add("name");
            }
        }
        if (this.args.length == 2) {
            switch (this.args[0].toLowerCase()) {
                case "enchant": {
                    list = EnchantmentUtils.find(this.player, this.args[1]);
                    break;
                }
                case "effect": {
                    list = EffectUtils.matchEffects(this.args[1]);
                    break;
                }
                case "meta": {
                    ItemStack item = this.player.getInventory().getItemInMainHand();
                    Map<UberEnchantment, Integer> map = UberUtils.getMap(item);
                    if (item.getType().equals((Object)Material.AIR) || map.isEmpty()) break;
                    list = map.keySet().stream().map(key -> key.getKey().getKey().toLowerCase()).toList();
                }
            }
        }
        if (this.args.length >= 3 && this.args[0].equalsIgnoreCase("meta")) {
            if (this.args.length == 3) {
                list = UberMeta.values().stream().filter(value -> this.hasPermission(String.format("uber.add.meta.%1$s", value.getName()))).map(UberMeta::getName).toList();
            }
            if (this.args.length == 4 && BoolTag.matches(this.args[2])) {
                list.add("true");
                list.add("false");
            }
        }
        return list;
    }

    private void enchant(ItemStack item) {
        UberEnchantmentsAddedEvent event = new UberEnchantmentsAddedEvent(this.player, item, null);
        if (event.isCancelled()) {
            return;
        }
        if (item.getType().equals((Object)Material.AIR)) {
            if (!this.hasPermission("uber.add.enchant.book")) {
                this.response(Reply.HOLD_ITEM);
                return;
            }
            item = new ItemStack(Material.ENCHANTED_BOOK);
        }
        if (this.args.length < 3) {
            this.response("&a/uadd enchant &c<enchantment> <level>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        int level = 0;
        try {
            level = Integer.parseInt(this.args[2]);
        }
        catch (NumberFormatException e) {
            this.response("&a/uadd %1$s %2$s &c%3$s", this.args);
            this.response(Reply.WHOLE_NUMBER);
            return;
        }
        if (this.args[1].equalsIgnoreCase("all") && this.hasPermission("uber.enchant.add.all")) {
            if (level > 255) {
                this.localized("&c", "actions.enchant.add.max_level");
                level = 255;
            }
            HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
            Integer lev = level;
            UberConfiguration.getRecords().forEach(r -> map.put(r.getEnchant(), lev));
            if (item.getType().equals((Object)Material.ENCHANTED_BOOK)) {
                UberUtils.addStoredEnchantments(map, item);
            } else {
                UberUtils.addEnchantments(map, item);
            }
            event = new UberEnchantmentsAddedEvent(this.player, item, map);
            this.player.getInventory().setItemInMainHand(item);
            this.localized("&a", "actions.enchant.add.success_all");
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            return;
        }
        Set<Enchantment> set = EnchantmentUtils.getMatches(this.args[1]);
        if (EnchantmentUtils.multi(this.player, set)) {
            return;
        }
        Enchantment enchant = set.iterator().next();
        UberConfiguration.UberRecord e = UberConfiguration.getByEnchant(enchant);
        if (!this.hasPermission("uber.add.enchant.all") && !this.hasPermission("uber.add.enchant.%1$s", e.getName().toLowerCase())) {
            this.response(Reply.PERMISSIONS);
            return;
        }
        if (this.hasPermission("uber.enchant.%1$s.free", e.getName().toLowerCase()) || !EconomyUtils.useEconomy()) {
            if (level >= e.getMinLevel() && level <= e.getMaxLevel() || this.hasPermission("uber.enchant.bypass.level")) {
                if (level > 255) {
                    this.localized("&c", "actions.enchant.add.max_level");
                    level = 255;
                }
                event = new UberEnchantmentsAddedEvent(this.player, item, Map.of(enchant, level));
                if (item.getType().equals((Object)Material.ENCHANTED_BOOK)) {
                    EnchantmentUtils.setStoredEnchantment(enchant, item, level);
                } else {
                    EnchantmentUtils.setEnchantment(enchant, item, level);
                }
                this.player.getInventory().setItemInMainHand(item);
                this.localized("&a", "actions.enchant.add.success", e.getDisplayName(), level);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
            } else {
                this.localized("&c", "actions.enchant.add.range", e.getMinLevel(), e.getMaxLevel());
            }
            return;
        }
        if (EconomyUtils.hasEconomy()) {
            if (!(e.getEnchant().canEnchantItem(item) || e.getCanUseOnAnything() && this.hasPermission("uber.enchant.bypass.any"))) {
                this.localized("&c", "actions.enchant.add.incompatible");
                return;
            }
            if (level >= e.getMinLevel() && level <= e.getMaxLevel()) {
                double cost;
                double d = cost = e.getCostForLevel().containsKey(level) ? e.getCostForLevel().get(level) : e.getCost() + e.getCostMultiplier() * e.getCost() * (double)(level - 1);
                if (EconomyUtils.has(this.player, cost)) {
                    if (level > 255) {
                        this.localized("&c", "actions.enchant.add.max_level");
                        level = 255;
                    }
                    event = new UberEnchantmentsAddedEvent(this.player, item, Map.of(enchant, level));
                    if (item.getType().equals((Object)Material.ENCHANTED_BOOK)) {
                        EnchantmentUtils.setStoredEnchantment(enchant, item, level);
                    } else {
                        EnchantmentUtils.setEnchantment(enchant, item, level);
                    }
                    EconomyResponse n = EconomyUtils.withdraw(this.player, cost);
                    this.player.getInventory().setItemInMainHand(item);
                    this.localized("&a", "actions.enchant.add.pay_success", e.getDisplayName(), level, n.amount);
                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                } else {
                    this.localized("&c", "actions.enchant.add.pay_more", cost - EconomyUtils.getBalance(this.player));
                }
            } else {
                this.localized("&c", "actions.enchant.add.range", e.getMinLevel(), e.getMaxLevel());
            }
        } else {
            this.response(Reply.NO_ECONOMY);
        }
    }

    private void meta(ItemStack item) {
        MetaTag<?> value;
        MetaTag<?> value2;
        Enum tag;
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        if (this.args.length < 4) {
            this.response("&a/uadd meta &c<enchantment> <tag> <value>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        Set<UberEnchantment> set = EnchantmentUtils.getMatches(item, this.args[1]);
        if (EnchantmentUtils.multi(this.player, set)) {
            return;
        }
        UberEnchantment enchant = set.iterator().next();
        if (!enchant.containsEnchantment(item)) {
            this.localized("&c", "actions.meta.enchantment_not_found");
            return;
        }
        if (!UberMeta.contains(this.args[2])) {
            this.localized("&c", "actions.meta.invalid_tag");
            return;
        }
        UberMeta<?> meta = UberMeta.getByName(this.args[2]);
        if (meta == null) {
            this.localized("&c", "actions.meta.invalid_tag");
            return;
        }
        if (!this.hasPermission(String.format("uber.add.meta.%1$s", meta.getName()))) {
            this.response(Reply.PERMISSIONS);
            return;
        }
        boolean success = false;
        MetaTag<?> metaTag = meta.getTag();
        if (metaTag instanceof BoolTag) {
            boolean value3;
            tag = (BoolTag)metaTag;
            switch (this.args[3].toLowerCase()) {
                case "true": 
                case "t": 
                case "1": {
                    value3 = true;
                    break;
                }
                case "false": 
                case "f": 
                case "0": {
                    value3 = false;
                    break;
                }
                default: {
                    this.localized("&c", "actions.meta.invalid_bool_value");
                    this.response("&a/uadd %1$s %2$s %3$s &c%4$s", this.args);
                    return;
                }
            }
            if (enchant instanceof EffectEnchantment) {
                EffectEnchantment effect = (EffectEnchantment)enchant;
                if (tag == BoolTag.ON_HELD && !UberUtils.containsMeta(item, enchant, BoolTag.ON_HELD) && value3) {
                    UberRunnable.addTask(new HeldEffectTask((LivingEntity)this.player, effect, (p, i, e) -> i.getType().equals((Object)Material.AIR) || !e.containsEnchantment(i) || !BoolTag.ON_HELD.test(i, e)));
                }
            }
            UberUtils.addMetaData(item, enchant, tag.asMeta(), value3);
            success = true;
        }
        if (!success && (value2 = meta.getTag()) instanceof IntTag) {
            int value4;
            tag = (IntTag)value2;
            try {
                value4 = Integer.parseInt(this.args[3]);
            }
            catch (NumberFormatException e2) {
                this.response("&a/uadd %1$s %2$s %3$s &c%4$s", this.args);
                this.response(Reply.WHOLE_NUMBER);
                return;
            }
            UberUtils.addMetaData(item, enchant, tag.asMeta(), value4);
            success = true;
        }
        if (!success && (value = meta.getTag()) instanceof DoubleTag) {
            double value5;
            tag = (DoubleTag)value;
            try {
                value5 = Double.parseDouble(this.args[3]);
            }
            catch (NumberFormatException e3) {
                this.response("&a/uadd %1$s %2$s %3$s &c%4$s", this.args);
                this.response(Reply.DECIMAL_NUMBER);
                return;
            }
            if (value5 <= 0.0 || value5 >= 1.0) {
                this.localized("&c", "actions.meta.invalid_double_value");
                return;
            }
            UberUtils.addMetaData(item, enchant, tag.asMeta(), value5);
            success = true;
        }
        if (success) {
            this.localized("&a", "actions.meta.add.success");
        } else {
            this.localized("&c", "actions.meta.add.fail");
        }
    }

    private void effect() {
        int level;
        int duration;
        if (this.args.length < 4) {
            this.response("&a/uadd effect &c<effect> <duration> <level>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        try {
            duration = Integer.parseInt(this.args[2]);
            duration *= 20;
        }
        catch (NumberFormatException e) {
            this.response("&a/uadd %1$s %2$s &c%3$s &a%4$s", this.args);
            this.response(Reply.WHOLE_NUMBER);
            return;
        }
        try {
            level = Integer.parseInt(this.args[3]);
        }
        catch (NumberFormatException e) {
            this.response("&a/uadd %1$s %2$s %3$s &c%4$s", this.args);
            this.response(Reply.WHOLE_NUMBER);
            return;
        }
        PotionEffectType type = EffectUtils.getEffect(this.args[1]);
        if (type == null) {
            this.localized("&c", "actions.effect.invalid");
            this.response("&a/ulist effects");
            return;
        }
        if (this.player.hasPotionEffect(type)) {
            EffectUtils.removeEffect(this.player, type);
        }
        EffectUtils.setEffect(this.player, type, duration, level);
        this.localized("&a", "actions.effect.add.success");
    }

    private void lore(ItemStack item) {
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        if (this.args.length < 2) {
            this.response("&a/uadd lore &c<text...>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        int index = UberUtils.offset(item);
        StringBuilder message = new StringBuilder(this.args[1]);
        if (this.args.length > 2) {
            for (int arg = 2; arg < this.args.length; ++arg) {
                message.append(" ").append(this.args[arg]);
            }
        }
        String name = ChatUtils.color(message.toString().trim());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = new ArrayList();
        if (meta.hasLore() || meta.hasLore() && meta.getLore().size() - index > 0) {
            lore = meta.getLore();
        }
        lore.add(name.replace("%null", ""));
        meta.setLore(lore);
        item.setItemMeta(meta);
        this.localized("&a", "actions.lore.add.success");
    }

    private void name(ItemStack item) {
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        if (this.args.length < 2) {
            this.response("&a/uadd name &c<text...>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        StringBuilder message = new StringBuilder(this.args[1]);
        for (int arg = 2; arg < this.args.length; ++arg) {
            message.append(" ").append(this.args[arg]);
        }
        String name = ChatUtils.color(message.toString().trim());
        ItemMeta meta = item.getItemMeta();
        String prev = meta.getDisplayName();
        if (!meta.hasDisplayName()) {
            this.localized("&c", "actions.name.no_name");
            return;
        }
        if (EconomyUtils.hasEconomy()) {
            double cost = EconomyUtils.getCost("cost.name.add");
            if (EconomyUtils.has(this.player, cost)) {
                EconomyUtils.withdraw(this.player, cost);
                meta.setDisplayName(prev + name);
                item.setItemMeta(meta);
                this.localized("&a", "actions.name.add.pay_success", cost);
            } else {
                this.localized("&c", "actions.name.add.pay_fail", cost - EconomyUtils.getBalance(this.player));
            }
        } else {
            meta.setDisplayName(prev + name);
            item.setItemMeta(meta);
            this.localized("&a", "actions.name.add.success");
        }
    }
}

