/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.sciguymjm.uberenchant.api.utils.UberConfiguration;
import me.sciguymjm.uberenchant.api.utils.UberUtils;
import me.sciguymjm.uberenchant.commands.abstraction.UberTabCommand;
import me.sciguymjm.uberenchant.utils.EconomyUtils;
import me.sciguymjm.uberenchant.utils.Reply;
import me.sciguymjm.uberenchant.utils.enchanting.EnchantmentUtils;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class ExtractCommand
extends UberTabCommand {
    @Override
    public boolean onCmd() {
        if (this.args.length != 0) {
            ItemStack item = this.player.getInventory().getItemInMainHand();
            if (this.hasPermission("uber.extract.enchant")) {
                this.enchant(item);
            } else {
                this.response(Reply.PERMISSIONS);
            }
        } else {
            this.response("&6%1$s", this.command.getUsage());
        }
        return true;
    }

    @Override
    public List<String> onTab() {
        ItemStack item;
        List<String> list = new ArrayList<String>();
        if (this.args.length == 1 && !(item = this.player.getInventory().getItemInMainHand()).getType().equals((Object)Material.AIR) && !UberUtils.getAllMap(item).isEmpty()) {
            list = UberUtils.getAllMap(item).keySet().stream().map(enchant -> enchant.getKey().getKey().toLowerCase()).toList();
        }
        return list;
    }

    private void enchant(ItemStack item) {
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        Set<Enchantment> set = EnchantmentUtils.getMatches(this.args[0]);
        if (EnchantmentUtils.multi(this.player, set)) {
            return;
        }
        Enchantment enchantment = set.iterator().next();
        if (enchantment != null) {
            if (item.getType().equals((Object)Material.ENCHANTED_BOOK)) {
                this.localized("&c", "actions.enchant.extract.book");
                return;
            }
            UberConfiguration.UberRecord enchant = UberConfiguration.getByEnchant(enchantment);
            if (!this.hasPermission("uber.extract.enchant.%1$s", enchant.getName().toLowerCase())) {
                this.response(Reply.PERMISSIONS);
                return;
            }
            ItemStack book = EnchantmentUtils.extractEnchantment(enchantment, item);
            if (book == null) {
                this.localized("&c", "actions.enchant.extract.not_found", enchant.getDisplayName());
                return;
            }
            int level = UberUtils.getAllMap(item).get(enchantment);
            if (this.hasPermission("uber.extract.enchant.free") || !EconomyUtils.useEconomy()) {
                if (this.player.getInventory().addItem(new ItemStack[]{book}).isEmpty()) {
                    EnchantmentUtils.removeEnchantment(enchantment, item);
                    this.localized("&a", "actions.enchant.extract.free_success", enchant.getDisplayName());
                } else {
                    this.localized("&c", "actions.enchant.extract.no_room");
                }
                return;
            }
            if (EconomyUtils.hasEconomy()) {
                if (!this.hasPermission("uber.extract.enchant.%1$s", enchant.getName().toLowerCase())) {
                    this.response(Reply.PERMISSIONS);
                    return;
                }
                double cost = enchant.getExtractionCost() + enchant.getCostMultiplier() * enchant.getExtractionCost() * (double)(level - 1);
                if (EconomyUtils.has(this.player, cost)) {
                    if (this.player.getInventory().addItem(new ItemStack[]{book}).isEmpty()) {
                        EnchantmentUtils.removeEnchantment(enchantment, item);
                        EconomyResponse n = EconomyUtils.withdraw(this.player, cost);
                        this.localized("&a", "actions.enchant.extract.pay_success", enchant.getDisplayName(), n.amount);
                    } else {
                        this.localized("&c", "actions.enchant.extract.no_room");
                    }
                    return;
                }
                this.localized("&c", "actions.enchant.extract.pay_more", cost - EconomyUtils.getBalance(this.player));
            } else {
                this.response(Reply.NO_ECONOMY);
            }
            return;
        }
        this.localized("&c", "actions.enchant.not_exist");
    }
}

