/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.sciguymjm.uberenchant.api.UberEnchantment;
import me.sciguymjm.uberenchant.api.utils.UberRunnable;
import me.sciguymjm.uberenchant.api.utils.UberUtils;
import me.sciguymjm.uberenchant.api.utils.persistence.UberMeta;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.BoolTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.DoubleTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.IntTag;
import me.sciguymjm.uberenchant.api.utils.persistence.tags.MetaTag;
import me.sciguymjm.uberenchant.commands.abstraction.UberTabCommand;
import me.sciguymjm.uberenchant.enchantments.abstraction.EffectEnchantment;
import me.sciguymjm.uberenchant.enchantments.tasks.HeldEffectTask;
import me.sciguymjm.uberenchant.utils.ChatUtils;
import me.sciguymjm.uberenchant.utils.EconomyUtils;
import me.sciguymjm.uberenchant.utils.EffectUtils;
import me.sciguymjm.uberenchant.utils.Reply;
import me.sciguymjm.uberenchant.utils.enchanting.EnchantmentUtils;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;

public class SetCommand
extends UberTabCommand {
    @Override
    public boolean onCmd() {
        if (this.args.length != 0) {
            ItemStack item = this.player.getInventory().getItemInMainHand();
            switch (this.args[0].toLowerCase()) {
                case "effect": {
                    if (this.hasPermission("uber.set.effect")) {
                        this.effect();
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "lore": {
                    if (this.hasPermission("uber.set.lore")) {
                        this.lore(item);
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "meta": {
                    if (this.hasPermission("uber.set.meta")) {
                        this.meta(item);
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "name": {
                    if (this.hasPermission("uber.set.name")) {
                        this.name(item);
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                case "hidden": {
                    if (this.hasPermission("uber.set.hidden")) {
                        this.hidden(item);
                        break;
                    }
                    this.response(Reply.PERMISSIONS);
                    break;
                }
                default: {
                    EnchantmentUtils.help(this.player, "uset");
                    break;
                }
            }
        } else {
            this.response("&6%1$s", this.command.getUsage());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<String> onTab() {
        List<String> list = new ArrayList<String>();
        switch (this.args.length) {
            case 1: {
                if (this.hasPermission("uber.set.effect")) {
                    list.add("effect");
                }
                if (this.hasPermission("uber.set.lore")) {
                    list.add("lore");
                }
                if (this.hasPermission("uber.set.meta")) {
                    list.add("meta");
                }
                if (this.hasPermission("uber.set.name")) {
                    list.add("name");
                }
                if (!this.hasPermission("uber.set.hidden")) break;
                list.add("hidden");
                break;
            }
            case 2: {
                switch (this.args[0].toLowerCase()) {
                    case "hidden": {
                        if (!this.hasPermission("uber.set.hidden")) break;
                        list.add("true");
                        list.add("false");
                        break;
                    }
                    case "effect": {
                        list = EffectUtils.matchEffects(this.args[1]);
                        break;
                    }
                    case "meta": {
                        ItemStack item = this.player.getInventory().getItemInMainHand();
                        Map<UberEnchantment, Integer> map = UberUtils.getMap(item);
                        if (item.getType().equals((Object)Material.AIR) || map.isEmpty()) break;
                        list = map.keySet().stream().map(key -> key.getKey().getKey().toLowerCase()).toList();
                    }
                }
                break;
            }
        }
        if (this.args.length >= 3 && this.args[0].equalsIgnoreCase("meta")) {
            if (this.args.length == 3) {
                ItemStack item = this.player.getInventory().getItemInMainHand();
                list = UberUtils.getTags(item, this.args[1]).stream().map(MetaTag::getName).filter(name -> this.hasPermission(String.format("uber.set.meta.%1$s", name))).toList();
            }
            if (this.args.length == 4 && BoolTag.matches(this.args[2])) {
                list.add("true");
                list.add("false");
            }
        }
        return list;
    }

    private void meta(ItemStack item) {
        MetaTag<?> value;
        MetaTag<?> value2;
        Enum tag;
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        if (this.args.length < 4) {
            this.response("&a/uset meta &c<enchantment> <tag> <value>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        Set<UberEnchantment> set = EnchantmentUtils.getMatches(item, this.args[1]);
        if (EnchantmentUtils.multi(this.player, set)) {
            return;
        }
        UberEnchantment enchant = set.iterator().next();
        if (!enchant.containsEnchantment(item)) {
            this.localized("&c", "actions.meta.enchantment_not_found");
            return;
        }
        if (!UberMeta.contains(this.args[2])) {
            this.localized("&c", "actions.meta.invalid_tag");
            return;
        }
        UberMeta<?> meta = UberMeta.getByName(this.args[2]);
        if (meta == null) {
            this.localized("&c", "actions.meta.invalid_tag");
            return;
        }
        if (!UberUtils.containsMeta(item, enchant, meta)) {
            this.localized("&c", "actions.meta.set.add_tag");
            return;
        }
        boolean success = false;
        MetaTag<?> metaTag = meta.getTag();
        if (metaTag instanceof BoolTag) {
            boolean value3;
            tag = (BoolTag)metaTag;
            switch (this.args[3].toLowerCase()) {
                case "true": 
                case "t": 
                case "1": {
                    value3 = true;
                    break;
                }
                case "false": 
                case "f": 
                case "0": {
                    value3 = false;
                    break;
                }
                default: {
                    this.localized("&c", "actions.meta.invalid_bool_value");
                    this.response("&a/uset %1$s %2$s %3$s &c%4$s", this.args);
                    return;
                }
            }
            if (enchant instanceof EffectEnchantment) {
                EffectEnchantment effect = (EffectEnchantment)enchant;
                if (tag == BoolTag.ON_HELD && !BoolTag.ON_HELD.test(item, effect) && value3) {
                    UberRunnable.addTask(new HeldEffectTask((LivingEntity)this.player, effect, (p, i, e) -> i.getType().equals((Object)Material.AIR) || !e.containsEnchantment(i) || !BoolTag.ON_HELD.test(i, e)));
                }
            }
            UberUtils.setMetaTag(item, enchant, tag.asMeta(), value3);
            success = true;
        }
        if (!success && (value2 = meta.getTag()) instanceof IntTag) {
            int value4;
            tag = (IntTag)value2;
            try {
                value4 = Integer.parseInt(this.args[3]);
            }
            catch (NumberFormatException e2) {
                this.response("&a/uset %1$s %2$s %3$s &c%4$s", this.args);
                this.response(Reply.WHOLE_NUMBER);
                return;
            }
            UberUtils.setMetaTag(item, enchant, tag.asMeta(), value4);
            success = true;
        }
        if (!success && (value = meta.getTag()) instanceof DoubleTag) {
            double value5;
            tag = (DoubleTag)value;
            try {
                value5 = Double.parseDouble(this.args[3]);
            }
            catch (NumberFormatException e3) {
                this.response("&a/uset %1$s %2$s %3$s &c%4$s", this.args);
                this.response(Reply.DECIMAL_NUMBER);
                return;
            }
            if (value5 <= 0.0 || value5 >= 1.0) {
                this.localized("&c", "actions.meta.invalid_double_value");
                return;
            }
            UberUtils.addMetaData(item, enchant, tag.asMeta(), value5);
            success = true;
        }
        if (success) {
            this.localized("&a", "actions.meta.set.success");
        } else {
            this.localized("&c", "actions.meta.set.fail");
        }
    }

    private void owner(ItemStack item) {
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        UberUtils.setOwner(item, this.player.getUniqueId());
        this.localized("&a", "actions.owner.set.success");
    }

    private void effect() {
        if (this.args.length < 4) {
            this.response("&a/uset effect &c<effect> <duration> <level>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        int level = 1;
        int duration = 60;
        try {
            duration = Integer.parseInt(this.args[2]);
            duration *= 20;
        }
        catch (NumberFormatException e) {
            this.response("&a/uset %1$s %2$s %3$s &c%4$s", this.args);
            this.response(Reply.WHOLE_NUMBER);
            return;
        }
        try {
            level = Integer.parseInt(this.args[3]);
        }
        catch (NumberFormatException e) {
            this.response("&a/uset %1$s %2$s &c%3$s &a%4$s", this.args);
            this.response(Reply.WHOLE_NUMBER);
            return;
        }
        PotionEffectType type = EffectUtils.getEffect(this.args[1]);
        if (type == null) {
            this.localized("&c", "actions.effect.invalid");
            this.response("&a/ulist effects");
            return;
        }
        if (this.player.hasPotionEffect(type)) {
            EffectUtils.removeEffect(this.player, type);
        }
        EffectUtils.setEffect(this.player, type, duration, level);
        this.localized("&a", "actions.effect.set.success");
    }

    private void lore(ItemStack item) {
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        if (this.args.length < 3) {
            this.response("&a/uset lore &c<line#> <text...>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        int index = UberUtils.offset(item);
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasLore() || meta.hasLore() && meta.getLore().size() - index == 0) {
            this.localized("&c", "actions.lore.set.no_lore");
            return;
        }
        List lore = meta.getLore();
        int size = lore.size() - index;
        int line = -1;
        try {
            line = Integer.parseInt(this.args[1]);
        }
        catch (NumberFormatException err) {
            StringBuilder message = new StringBuilder("&a/uset lore &c%1$s &a%2$s");
            if (this.args.length > 3) {
                for (int arg = 3; arg < this.args.length; ++arg) {
                    message.append(" ").append(this.args[arg]);
                }
            }
            this.response(message.toString().trim(), this.args[1], this.args[2]);
            this.response(Reply.WHOLE_NUMBER);
            return;
        }
        if (line > size - 1 || line < 0) {
            StringBuilder message = new StringBuilder("&a/uset lore &c%1$s &a%2$s");
            if (this.args.length > 3) {
                for (int arg = 3; arg < this.args.length; ++arg) {
                    message.append(" ").append(this.args[arg]);
                }
            }
            this.response(message.toString().trim(), this.args[1], this.args[2]);
            this.localized("&c", "actions.lore.set.no_line");
            return;
        }
        StringBuilder message = new StringBuilder(this.args[2]);
        if (this.args.length > 3) {
            for (int arg = 3; arg < this.args.length; ++arg) {
                message.append(" ").append(this.args[arg]);
            }
        }
        String name = ChatUtils.color(message.toString().trim());
        lore.set(index + line, name.replace("%null", ""));
        meta.setLore(lore);
        item.setItemMeta(meta);
        this.localized("&a", "actions.lore.set.success");
    }

    private void name(ItemStack item) {
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        if (this.args.length < 2) {
            this.response("&a/uset name &c<text...>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        StringBuilder message = new StringBuilder(this.args[1]);
        for (int arg = 2; arg < this.args.length; ++arg) {
            message.append(" ").append(this.args[arg]);
        }
        String name = ChatUtils.color(message.toString().trim());
        ItemMeta meta = item.getItemMeta();
        if (this.hasPermission("uber.set.name.free") || !EconomyUtils.useEconomy()) {
            meta.setDisplayName(name);
            item.setItemMeta(meta);
            this.localized("&a", "actions.name.set.success");
            return;
        }
        if (EconomyUtils.hasEconomy()) {
            double cost = EconomyUtils.getCost("cost.name.set");
            if (EconomyUtils.has(this.player, cost)) {
                EconomyUtils.withdraw(this.player, cost);
                meta.setDisplayName(name);
                item.setItemMeta(meta);
                this.localized("&a", "actions.name.set.pay_success", cost);
            } else {
                this.localized("&c", "actions.name.set.pay_fail", cost - EconomyUtils.getBalance(this.player));
            }
        } else {
            meta.setDisplayName(name);
            item.setItemMeta(meta);
            this.localized("&a", "actions.name.set.success");
        }
    }

    private void hidden(ItemStack item) {
        if (item.getType().equals((Object)Material.AIR)) {
            this.response(Reply.HOLD_ITEM);
            return;
        }
        if (this.args.length < 2) {
            this.response("&a/uset hidden &c<true | false>");
            this.response(Reply.ARGUMENTS);
            return;
        }
        switch (this.args[1].toLowerCase()) {
            case "false": {
                this.response(EnchantmentUtils.setHideEnchants(item, false));
                break;
            }
            case "true": {
                this.response(EnchantmentUtils.setHideEnchants(item, true));
                break;
            }
            default: {
                this.response("&a/uset hidden &c%1$s", this.args[1]);
                this.response(Reply.INVALID);
            }
        }
    }
}

