/*
 * Decompiled with CFR 0.152.
 */
package me.sciguymjm.uberenchant.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.registry.RegistryAware;

public class VersionUtils {
    private static final String version = Bukkit.getBukkitVersion();

    public static int[] getBukkitVersion() {
        return VersionUtils.parseVersion(version);
    }

    private static int[] parseVersion(String version) {
        Matcher m = Pattern.compile("(\\d+)\\.(\\d+)\\.?(\\d?)").matcher(version);
        if (m.find()) {
            return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), m.group(3).isBlank() ? 0 : Integer.parseInt(m.group(3))};
        }
        return new int[]{0, 0, 0};
    }

    public static boolean isAtLeast(String v) {
        int[] v2;
        int[] v1 = VersionUtils.getBukkitVersion();
        return v1[0] > (v2 = VersionUtils.parseVersion(v))[0] || v1[0] == v2[0] && v1[1] > v2[1] || v1[0] == v2[0] && v1[1] == v2[1] && v1[2] >= v2[2];
    }

    public static <K extends Keyed> NamespacedKey getKey(K keyed) {
        NamespacedKey key;
        if (VersionUtils.isAtLeast("1.21.4") && keyed instanceof RegistryAware) {
            RegistryAware k = (RegistryAware)keyed;
            key = k.getKeyOrNull();
        } else {
            key = keyed.getKey();
        }
        return key;
    }
}

