/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.event;

import com.xiaoshi2022.kamen_rider_weapon_craft.component.ridermodComponents;
import com.xiaoshi2022.kamen_rider_weapon_craft.items.custom.Heiseisword;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.sound.RiderSounds;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3414;

public class EntityDeathEventListener {
    private static final Map<UUID, UUID> RECENT_ATTACKERS = new HashMap<UUID, UUID>();
    private static final Map<UUID, class_1282> ENTITY_DEATH_SOURCES = new HashMap<UUID, class_1282>();

    public static void register() {
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (entity instanceof class_1309 && !world.method_8608()) {
                RECENT_ATTACKERS.put(entity.method_5667(), player.method_5667());
            }
            return class_1269.field_5811;
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                EntityDeathEventListener.setupDeathListener(livingEntity);
            }
        });
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            UUID entityUuid = entity.method_5667();
            RECENT_ATTACKERS.remove(entityUuid);
            ENTITY_DEATH_SOURCES.remove(entityUuid);
        });
    }

    private static void setupDeathListener(class_1309 entity) {
    }

    public static void recordDamageSource(class_1309 entity, class_1282 damageSource) {
        if (!entity.method_37908().method_8608()) {
            ENTITY_DEATH_SOURCES.put(entity.method_5667(), damageSource);
        }
    }

    public static void onEntityDeath(class_1309 entity, class_1282 damageSource) {
        class_1937 world = entity.method_37908();
        if (world.method_8608()) {
            return;
        }
        UUID entityUuid = entity.method_5667();
        class_1657 killingPlayer = null;
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player;
            killingPlayer = player = (class_1657)class_12972;
        } else {
            class_12972 = damageSource.method_5526();
            if (class_12972 instanceof class_1657) {
                class_1657 player;
                killingPlayer = player = (class_1657)class_12972;
            } else if (RECENT_ATTACKERS.containsKey(entityUuid)) {
                class_3218 serverWorld;
                class_1657 player;
                UUID playerUuid = RECENT_ATTACKERS.get(entityUuid);
                if (world instanceof class_3218 && (player = (serverWorld = (class_3218)world).method_18470(playerUuid)) != null) {
                    killingPlayer = player;
                }
            }
        }
        if (killingPlayer != null) {
            EntityDeathEventListener.playKillSound(world, killingPlayer);
        }
        RECENT_ATTACKERS.remove(entityUuid);
        ENTITY_DEATH_SOURCES.remove(entityUuid);
    }

    public static void playKillSound(class_1937 world, class_1657 player) {
        if (world.method_8608() || player == null) {
            return;
        }
        class_1799 mainHandStack = player.method_6047();
        if (mainHandStack.method_7909() instanceof Heiseisword) {
            try {
                boolean isUltimateMode = (Boolean)mainHandStack.method_58695(ridermodComponents.IS_ULTIMATE_MODE, (Object)false);
                List scrambleRiders = (List)mainHandStack.method_58695(ridermodComponents.SCRAMBLE_RIDERS, Collections.emptyList());
                if (isUltimateMode) {
                    RiderSounds.playUltimateFinishSoundSequence(world, player, scrambleRiders);
                } else if (!scrambleRiders.isEmpty()) {
                    RiderSounds.playScrambleFinishSoundSequence(world, player, scrambleRiders);
                } else {
                    RiderSounds.playSound(world, player, RiderSounds.DUAL_TIME_BREAK);
                }
                System.out.println("\u64ad\u653e\u51fb\u8d25\u97f3\u6548 - \u73a9\u5bb6: " + player.method_5477().getString() + ", \u7ec8\u6781\u6a21\u5f0f: " + isUltimateMode + ", \u6df7\u4e71\u9a91\u624b\u6570\u91cf: " + scrambleRiders.size());
            }
            catch (Exception e) {
                System.err.println("\u64ad\u653e\u51fb\u8d25\u97f3\u6548\u65f6\u51fa\u9519: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static void playSpecialKillSound(class_1937 world, class_1657 player, class_3414 soundEvent) {
        if (!world.method_8608() && player != null && soundEvent != null) {
            RiderSounds.playSound(world, player, soundEvent);
        }
    }

    public static int getRecentAttackersSize() {
        return RECENT_ATTACKERS.size();
    }

    public static void clearAllCaches() {
        RECENT_ATTACKERS.clear();
        ENTITY_DEATH_SOURCES.clear();
    }
}

