/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.items.custom;

import com.mojang.datafixers.util.Pair;
import com.xiaoshi2022.kamen_rider_weapon_craft.component.ridermodComponents;
import com.xiaoshi2022.kamen_rider_weapon_craft.items.client.Heiseisword.HeiseiswordRenderer;
import com.xiaoshi2022.kamen_rider_weapon_craft.key.KeyBindings;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffectManager;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.energy.HeiseiswordEnergyManager;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.sound.RiderSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2744;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Heiseisword
extends class_1792
implements GeoItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(Heiseisword.class);
    private static final RawAnimation ROTATE_POSITION_1 = RawAnimation.begin().thenPlay("rotate_pos1");
    private static final RawAnimation ROTATE_POSITION_2 = RawAnimation.begin().thenPlay("rotate_pos2");
    private static final RawAnimation ROTATE_POSITION_3 = RawAnimation.begin().thenPlay("rotate_pos3");
    private static final RawAnimation ROTATE_POSITION_4 = RawAnimation.begin().thenPlay("rotate_pos4");
    private static final RawAnimation ULTIMATE_TIME_BREAK_ANIM = RawAnimation.begin().thenPlay("ridertime");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int ATTACK_COOLDOWN_TICKS = 10;
    private static final int ULTIMATE_ATTACK_COOLDOWN_TICKS = 40;
    private static final int RIDER_SELECTION_COOLDOWN_TICKS = 15;
    private static final int FINISH_TIME_COOLDOWN_TICKS = 300;
    private static final double NORMAL_ATTACK_ENERGY_COST = 10.0;
    private static final double SCRAMBLE_ATTACK_ENERGY_COST = 25.0;
    private static final double ULTIMATE_ATTACK_ENERGY_COST = 50.0;
    private static final float ATTACK_DAMAGE = 33.0f;
    private static final float ATTACK_SPEED = 2.4f;
    private static final class_2960 ATTACK_DAMAGE_MODIFIER_ID = class_2960.method_60655((String)"kamen_rider_weapon_craft", (String)"attack_damage");
    private static final class_2960 ATTACK_SPEED_MODIFIER_ID = class_2960.method_60655((String)"kamen_rider_weapon_craft", (String)"attack_speed");
    private static final class_1322 ATTACK_DAMAGE_MODIFIER = new class_1322(ATTACK_DAMAGE_MODIFIER_ID, 33.0, class_1322.class_1323.field_6328);
    private static final class_1322 ATTACK_SPEED_MODIFIER = new class_1322(ATTACK_SPEED_MODIFIER_ID, (double)2.4f, class_1322.class_1323.field_6328);

    public Heiseisword(class_1792.class_1793 settings) {
        super(settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((SingletonGeoAnimatable)this);
    }

    public static class_9285 createAttributeModifiers() {
        return class_9285.method_57480().method_57487(class_5134.field_23721, ATTACK_DAMAGE_MODIFIER, class_9274.field_49217).method_57487(class_5134.field_23723, ATTACK_SPEED_MODIFIER, class_9274.field_49217).method_57486();
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private HeiseiswordRenderer renderer;

            @Nullable
            public GeoItemRenderer<Heiseisword> getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new HeiseiswordRenderer();
                }
                return this.renderer;
            }
        });
    }

    private int getCurrentRotationPosition(class_1799 stack) {
        Integer value = (Integer)stack.method_58694(ridermodComponents.CURRENT_ROTATION_POSITION);
        return value != null ? value : 0;
    }

    private void setCurrentRotationPosition(class_1799 stack, int position) {
        stack.method_57379(ridermodComponents.CURRENT_ROTATION_POSITION, (Object)position);
    }

    private String getSelectedRider(class_1799 stack) {
        return (String)stack.method_58694(ridermodComponents.SELECTED_RIDER);
    }

    private void setSelectedRider(class_1799 stack, String riderName) {
        if (riderName != null && !riderName.isEmpty()) {
            stack.method_57379(ridermodComponents.SELECTED_RIDER, (Object)riderName);
        } else {
            stack.method_57381(ridermodComponents.SELECTED_RIDER);
        }
    }

    private List<String> getScrambleRiders(class_1799 stack) {
        List riders = (List)stack.method_58694(ridermodComponents.SCRAMBLE_RIDERS);
        return riders != null ? new ArrayList<String>(riders) : new ArrayList();
    }

    private void setScrambleRiders(class_1799 stack, List<String> riders) {
        stack.method_57379(ridermodComponents.SCRAMBLE_RIDERS, new ArrayList<String>(riders));
    }

    private boolean isFinishTimeMode(class_1799 stack) {
        Boolean value = (Boolean)stack.method_58694(ridermodComponents.IS_FINISH_TIME_MODE);
        return value != null ? value : false;
    }

    private void setFinishTimeMode(class_1799 stack, boolean mode) {
        stack.method_57379(ridermodComponents.IS_FINISH_TIME_MODE, (Object)mode);
    }

    private boolean isUltimateMode(class_1799 stack) {
        Boolean value = (Boolean)stack.method_58694(ridermodComponents.IS_ULTIMATE_MODE);
        return value != null ? value : false;
    }

    private void setUltimateMode(class_1799 stack, boolean mode) {
        stack.method_57379(ridermodComponents.IS_ULTIMATE_MODE, (Object)mode);
    }

    private long getLastFinishTimeEnter(class_1799 stack) {
        Long value = (Long)stack.method_58694(ridermodComponents.LAST_FINISH_TIME_ENTER);
        return value != null ? value : 0L;
    }

    private void setLastFinishTimeEnter(class_1799 stack, long time) {
        stack.method_57379(ridermodComponents.LAST_FINISH_TIME_ENTER, (Object)time);
    }

    private long getLastAttackTime(class_1799 stack) {
        Long value = (Long)stack.method_58694(ridermodComponents.LAST_ATTACK_TIME);
        return value != null ? value : 0L;
    }

    private void setLastAttackTime(class_1799 stack, long time) {
        stack.method_57379(ridermodComponents.LAST_ATTACK_TIME, (Object)time);
    }

    private long getLastRiderSelectionTime(class_1799 stack) {
        Long value = (Long)stack.method_58694(ridermodComponents.LAST_RIDER_SELECTION_TIME);
        return value != null ? value : 0L;
    }

    private void setLastRiderSelectionTime(class_1799 stack, long time) {
        stack.method_57379(ridermodComponents.LAST_RIDER_SELECTION_TIME, (Object)time);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("rotation", 20, state -> PlayState.STOP).triggerableAnim("pos1", ROTATE_POSITION_1).triggerableAnim("pos2", ROTATE_POSITION_2).triggerableAnim("pos3", ROTATE_POSITION_3).triggerableAnim("pos4", ROTATE_POSITION_4));
        controllers.add(new AnimationController("ultimate", 20, state -> PlayState.STOP).triggerableAnim("ultimate_time_break", ULTIMATE_TIME_BREAK_ANIM));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            return this.toggleFinishTimeMode(world, player, stack);
        }
        player.method_6019(hand);
        return class_1269.field_21466;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    public boolean method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        class_1657 player;
        block10: {
            block9: {
                if (!(user instanceof class_1657)) break block9;
                player = (class_1657)user;
                if (!world.method_8608()) break block10;
            }
            return false;
        }
        if (this.isAttackOnCooldown(stack, world)) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"\u653b\u51fb\u51b7\u5374\u4e2d..."), true);
            }
            return false;
        }
        float chargeTime = (float)(this.method_7881(stack, user) - remainingUseTicks) / 20.0f;
        chargeTime = Math.min((chargeTime * chargeTime + chargeTime * 2.0f) / 3.0f, 1.0f);
        if (this.isFinishTimeMode(stack)) {
            if (this.isUltimateMode(stack)) {
                this.executeUltimateRangedAttack(player, stack, chargeTime);
            } else {
                this.executeScrambleRangedAttack(player, stack, chargeTime);
            }
        } else {
            this.executeNormalRangedAttack(player, stack, chargeTime);
        }
        this.triggerRangedAttackAnimation(world, player, stack);
        stack.method_7970(1, (class_1309)player, class_1304.field_6173);
        return false;
    }

    private class_1269 toggleFinishTimeMode(class_1937 world, class_1657 player, class_1799 stack) {
        boolean newMode;
        boolean currentMode = this.isFinishTimeMode(stack);
        boolean bl = newMode = !currentMode;
        if (newMode && this.isFinishTimeOnCooldown(stack, world)) {
            long remainingTicks = 300L - (world.method_8510() - this.getLastFinishTimeEnter(stack));
            int remainingSeconds = (int)remainingTicks / 20;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u5fc5\u6740\u6a21\u5f0f\u51b7\u5374\u4e2d\uff0c\u5269\u4f59 " + remainingSeconds + " \u79d2")), true);
            }
            return class_1269.field_5811;
        }
        this.setFinishTimeMode(stack, newMode);
        if (newMode) {
            this.setLastFinishTimeEnter(stack, world.method_8510());
            this.setScrambleRiders(stack, new ArrayList<String>());
            this.setUltimateMode(stack, false);
            this.setCurrentRotationPosition(stack, 0);
        } else {
            this.setScrambleRiders(stack, new ArrayList<String>());
            this.setSelectedRider(stack, null);
            this.setUltimateMode(stack, false);
            this.setCurrentRotationPosition(stack, 0);
        }
        return class_1269.field_5812;
    }

    private boolean isFinishTimeOnCooldown(class_1799 stack, class_1937 world) {
        long lastEnterTime = this.getLastFinishTimeEnter(stack);
        return world.method_8510() - lastEnterTime < 300L;
    }

    public void inventoryTick(class_1799 stack, class_1937 world, class_1297 entity, int slot, int slotForDisplay) {
        boolean isSelected;
        if (world.method_8608() || !(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        boolean bl = isSelected = player.method_6047() == stack;
        if (isSelected) {
            this.handleRiderSelection(player, stack, world);
        }
    }

    private void handleRiderSelection(class_1657 player, class_1799 stack, class_1937 world) {
        if (world.field_9236) {
            if (world.method_8510() - this.getLastRiderSelectionTime(stack) < 15L) {
                return;
            }
            boolean selectionKeyPressed = this.checkRiderSelectionKeyPressed(player);
            if (selectionKeyPressed) {
                // empty if block
            }
        }
    }

    private boolean checkRiderSelectionKeyPressed(class_1657 player) {
        if (player.method_37908().field_9236) {
            try {
                class_304 keyBinding = KeyBindings.getRiderSelectionKey();
                if (keyBinding != null) {
                    return (Boolean)keyBinding.getClass().getMethod("isPressed", new Class[0]).invoke((Object)keyBinding, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static void handleRiderSelectionKeyPress(class_3222 player) {
        class_1799 mainHandStack = player.method_6047();
        class_1792 class_17922 = mainHandStack.method_7909();
        if (class_17922 instanceof Heiseisword) {
            Heiseisword heiseisword = (Heiseisword)class_17922;
            if (player.method_51469().method_8510() - heiseisword.getLastRiderSelectionTime(mainHandStack) < 15L) {
                return;
            }
            if (heiseisword.isFinishTimeMode(mainHandStack)) {
                heiseisword.handleFinishTimeModeSelection((class_1657)player, mainHandStack, (class_1937)player.method_51469());
            } else {
                heiseisword.handleNormalModeSelection((class_1657)player, mainHandStack, (class_1937)player.method_51469());
            }
            heiseisword.setLastRiderSelectionTime(mainHandStack, player.method_51469().method_8510());
        }
    }

    private void handleNormalModeSelection(class_1657 player, class_1799 stack, class_1937 world) {
        List<String> riderOrder = HeiseiRiderEffectManager.getRiderOrder();
        String currentSelectedRider = this.getSelectedRider(stack);
        if (currentSelectedRider == null || currentSelectedRider.isEmpty()) {
            RiderSounds.playRiderTimeSound(world, player);
            this.setSelectedRider(stack, riderOrder.get(0));
            this.setCurrentRotationPosition(stack, 0);
        } else {
            int currentIndex = riderOrder.indexOf(currentSelectedRider);
            int nextIndex = (currentIndex + 1) % riderOrder.size();
            this.setSelectedRider(stack, riderOrder.get(nextIndex));
            int currentPosition = this.getCurrentRotationPosition(stack);
            this.setCurrentRotationPosition(stack, (currentPosition + 1) % 4);
        }
        String selectedRider = this.getSelectedRider(stack);
        class_3414 nameSound = HeiseiRiderEffectManager.getRiderNameSound(selectedRider);
        if (nameSound != null) {
            RiderSounds.playSelectionSound(world, player, nameSound);
        }
        this.triggerRotationAnimation(world, player, stack);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u5df2\u9009\u62e9\u9a91\u58eb: " + this.getSelectedRider(stack))), true);
        }
    }

    private void handleFinishTimeModeSelection(class_1657 player, class_1799 stack, class_1937 world) {
        List<String> riderOrder = HeiseiRiderEffectManager.getRiderOrder();
        boolean ultimateKeyPressed = this.checkUltimateKeyPressed(player);
        if (ultimateKeyPressed && !this.isUltimateMode(stack)) {
            this.setUltimateMode(stack, true);
            RiderSounds.playRapidSelectionSound(world, player);
            this.triggerUltimateAnimation(world, player, stack);
            this.setScrambleRiders(stack, new ArrayList<String>(riderOrder));
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"\u8d85\u5fc5\u6740\u6a21\u5f0f\u6fc0\u6d3b! \u5df2\u9009\u62e9\u6240\u6709\u9a91\u58eb"), true);
            }
            return;
        }
        List<String> currentScrambleRiders = this.getScrambleRiders(stack);
        if (currentScrambleRiders.isEmpty()) {
            String newRider = riderOrder.get(0);
            ArrayList<String> updatedRiders = new ArrayList<String>();
            updatedRiders.add(newRider);
            this.setScrambleRiders(stack, updatedRiders);
            class_3414 nameSound = HeiseiRiderEffectManager.getRiderNameSound(newRider);
            if (nameSound != null) {
                RiderSounds.playSelectionSound(world, player, nameSound);
            }
            this.setCurrentRotationPosition(stack, 0);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u9009\u62e9\u4e86\u7b2c\u4e00\u4e2a\u9a91\u58eb: " + newRider)), true);
            }
        } else {
            String lastRider = currentScrambleRiders.get(currentScrambleRiders.size() - 1);
            int currentIndex = riderOrder.indexOf(lastRider);
            if (currentIndex == -1) {
                currentIndex = 0;
            }
            int nextIndex = (currentIndex + 1) % riderOrder.size();
            while (nextIndex != currentIndex) {
                String candidate = riderOrder.get(nextIndex);
                if (!currentScrambleRiders.contains(candidate)) {
                    ArrayList<String> updatedRiders = new ArrayList<String>(currentScrambleRiders);
                    updatedRiders.add(candidate);
                    this.setScrambleRiders(stack, updatedRiders);
                    class_3414 nameSound = HeiseiRiderEffectManager.getRiderNameSound(candidate);
                    if (nameSound != null) {
                        RiderSounds.playSelectionSound(world, player, nameSound);
                    }
                    this.setCurrentRotationPosition(stack, (this.getCurrentRotationPosition(stack) + 1) % 4);
                    if (!(player instanceof class_3222)) break;
                    class_3222 serverPlayer = (class_3222)player;
                    serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u9009\u62e9\u4e86\u9a91\u58eb: " + candidate)), true);
                    break;
                }
                nextIndex = (nextIndex + 1) % riderOrder.size();
            }
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u5f53\u524d\u5df2\u9009\u9a91\u58eb: " + String.valueOf(this.getScrambleRiders(stack)))), true);
        }
        this.triggerRotationAnimation(world, player, stack);
    }

    private boolean checkUltimateKeyPressed(class_1657 player) {
        if (player.method_37908().field_9236) {
            try {
                class_304 keyBinding = KeyBindings.getUltimateModeKey();
                if (keyBinding != null) {
                    return (Boolean)keyBinding.getClass().getMethod("isPressed", new Class[0]).invoke((Object)keyBinding, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static void handleUltimateKeyPress(class_3222 player) {
        class_1799 mainHandStack = player.method_6047();
        class_1792 class_17922 = mainHandStack.method_7909();
        if (class_17922 instanceof Heiseisword) {
            Heiseisword heiseisword = (Heiseisword)class_17922;
            LOGGER.info("Player {} attempting to activate ultimate mode. FinishTimeMode: {}, UltimateMode: {}", new Object[]{player.method_5477().getString(), heiseisword.isFinishTimeMode(mainHandStack), heiseisword.isUltimateMode(mainHandStack)});
            if (heiseisword.isFinishTimeMode(mainHandStack)) {
                if (!heiseisword.isUltimateMode(mainHandStack)) {
                    heiseisword.setUltimateMode(mainHandStack, true);
                    List<String> riderOrder = HeiseiRiderEffectManager.getRiderOrder();
                    heiseisword.setScrambleRiders(mainHandStack, new ArrayList<String>(riderOrder));
                    Heiseisword.syncItemStackToAllClients(player, mainHandStack);
                    heiseisword.triggerUltimateAnimation((class_1937)player.method_51469(), (class_1657)player, mainHandStack);
                    RiderSounds.playRapidSelectionSound((class_1937)player.method_51469(), (class_1657)player);
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u8d85\u5fc5\u6740\u6a21\u5f0f\u6fc0\u6d3b! \u5df2\u9009\u62e9\u6240\u6709\u9a91\u58eb"), true);
                    LOGGER.info("Player {} successfully activated ultimate mode. Synced to all clients.", (Object)player.method_5477().getString());
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u5df2\u7ecf\u5904\u4e8e\u8d85\u5fc5\u6740\u6a21\u5f0f\u4e2d!"), true);
                }
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u9700\u8981\u5148\u8fdb\u5165Finish Time\u6a21\u5f0f!"), true);
            }
        } else {
            LOGGER.warn("Player {} attempted ultimate mode without Heiseisword in main hand", (Object)player.method_5477().getString());
        }
    }

    private static void syncItemStackToAllClients(class_3222 player, class_1799 stack) {
        if (player == null || stack.method_7960()) {
            return;
        }
        try {
            player.field_7498.method_34252();
            player.method_31548().method_5431();
            class_3218 world = player.method_51469();
            ArrayList<Pair> equipmentUpdates = new ArrayList<Pair>();
            equipmentUpdates.add(new Pair((Object)class_1304.field_6173, (Object)stack));
            class_2744 packet = new class_2744(player.method_5628(), equipmentUpdates);
            world.method_14178().method_18751((class_1297)player, (class_2596)packet);
            player.field_13987.method_14364((class_2596)packet);
            LOGGER.debug("Successfully synced item stack state for player: {}", (Object)player.method_5477().getString());
        }
        catch (Exception e) {
            LOGGER.error("Failed to sync item stack for player {}: {}", (Object)player.method_5477().getString(), (Object)e.getMessage());
        }
    }

    private void triggerRotationAnimation(class_1937 world, class_1657 player, class_1799 stack) {
        int position = this.getCurrentRotationPosition(stack);
        String animationName = "pos" + (position + 1);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.triggerAnim((class_1297)player, GeoItem.getOrAssignId((class_1799)stack, (class_3218)serverWorld), "rotation", animationName);
        }
    }

    private void triggerUltimateAnimation(class_1937 world, class_1657 player, class_1799 stack) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.triggerAnim((class_1297)player, GeoItem.getOrAssignId((class_1799)stack, (class_3218)serverWorld), "ultimate", "ultimate_time_break");
        }
    }

    private void triggerRangedAttackAnimation(class_1937 world, class_1657 player, class_1799 stack) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.triggerAnim((class_1297)player, GeoItem.getOrAssignId((class_1799)stack, (class_3218)serverWorld), "rotation", "pos1");
        }
    }

    private void executeNormalRangedAttack(class_1657 player, class_1799 stack, float chargeTime) {
        if (chargeTime < 0.1f) {
            return;
        }
        if (!HeiseiswordEnergyManager.canUseEnergy(player, 10.0)) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u80fd\u91cf\u4e0d\u8db3! \u5f53\u524d\u80fd\u91cf: " + HeiseiswordEnergyManager.getCurrentEnergy(player))), true);
            }
            return;
        }
        String rider = this.getSelectedRider(stack);
        if (rider == null || rider.isEmpty()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"\u8bf7\u5148\u9009\u62e9\u9a91\u58eb!"), true);
            }
            return;
        }
        HeiseiRiderEffect effect = HeiseiRiderEffectManager.getRiderEffect(rider);
        if (effect != null) {
            class_243 lookAngle = player.method_5720().method_1021((double)chargeTime * 2.0);
            effect.executeSpecialAttack(player.method_37908(), player, lookAngle);
            class_3414 nameSound = HeiseiRiderEffectManager.getRiderNameSound(rider);
            if (nameSound != null) {
                RiderSounds.playAttackSound(player.method_37908(), player, nameSound);
            }
            HeiseiswordEnergyManager.consumeEnergy(player, 10.0);
            this.setLastAttackTime(stack, player.method_37908().method_8510());
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u53d1\u52a8 " + rider + " \u653b\u51fb! \u5269\u4f59\u80fd\u91cf: " + HeiseiswordEnergyManager.getCurrentEnergy(player))), true);
            }
        }
    }

    private void executeScrambleRangedAttack(class_1657 player, class_1799 stack, float chargeTime) {
        if (chargeTime < 0.1f) {
            return;
        }
        if (!HeiseiswordEnergyManager.canUseEnergy(player, 25.0)) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u80fd\u91cf\u4e0d\u8db3! \u5f53\u524d\u80fd\u91cf: " + HeiseiswordEnergyManager.getCurrentEnergy(player))), true);
            }
            return;
        }
        List<String> scrambleRiders = this.getScrambleRiders(stack);
        if (scrambleRiders.isEmpty()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"\u9700\u8981\u5148\u9009\u62e9\u9a91\u58eb!"), true);
            }
            return;
        }
        class_243 lookAngle = player.method_5720().method_1021((double)chargeTime * 1.5);
        for (String rider : scrambleRiders) {
            HeiseiRiderEffect effect = HeiseiRiderEffectManager.getRiderEffect(rider);
            if (effect == null) continue;
            float damageMultiplier = 1.0f + chargeTime * 0.5f;
            effect.executeSpecialAttack(player.method_37908(), player, lookAngle);
        }
        HeiseiswordEnergyManager.consumeEnergy(player, 25.0);
        this.setLastAttackTime(stack, player.method_37908().method_8510());
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("Scramble Time Break! \u5269\u4f59\u80fd\u91cf: " + HeiseiswordEnergyManager.getCurrentEnergy(player))), true);
        }
    }

    private void executeUltimateRangedAttack(class_1657 player, class_1799 stack, float chargeTime) {
        if (chargeTime < 0.1f) {
            return;
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (!HeiseiswordEnergyManager.canUseEnergy(player, 50.0)) {
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u80fd\u91cf\u4e0d\u8db3! \u5f53\u524d\u80fd\u91cf: " + HeiseiswordEnergyManager.getCurrentEnergy(player))), true);
                return;
            }
            List<String> riders = this.getScrambleRiders(stack);
            if (riders.isEmpty()) {
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"\u672a\u9009\u62e9\u9a91\u58eb!"), true);
                return;
            }
            class_243 lookAngle = player.method_5720().method_1021((double)chargeTime * 3.0);
            for (String rider : riders) {
                HeiseiRiderEffect effect = HeiseiRiderEffectManager.getRiderEffect(rider);
                if (effect == null) continue;
                float damageMultiplier = 2.0f + chargeTime * 1.0f;
                effect.executeSpecialAttack(player.method_37908(), player, lookAngle);
            }
            this.executeUltimateSpecialEffects(player.method_37908(), player);
            HeiseiswordEnergyManager.consumeEnergy(player, 50.0);
            this.setLastAttackTime(stack, player.method_37908().method_8510());
            this.setFinishTimeMode(stack, false);
            this.setUltimateMode(stack, false);
            serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("ULTIMATE TIME BREAK! \u5269\u4f59\u80fd\u91cf: " + HeiseiswordEnergyManager.getCurrentEnergy(player))), true);
            this.triggerUltimateAnimation(player.method_37908(), player, stack);
        }
    }

    private void executeUltimateSpecialEffects(class_1937 world, class_1657 player) {
        class_3218 serverWorld;
        block3: {
            block2: {
                if (world.method_8608() || !(world instanceof class_3218)) break block2;
                serverWorld = (class_3218)world;
                if (player instanceof class_3222) break block3;
            }
            return;
        }
        double radius = 20.0;
        float baseDamage = 150.0f;
        world.method_8333((class_1297)player, player.method_5829().method_1014(radius), entity -> entity instanceof class_1309 && entity != player).forEach(entity -> {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                double distance = entity.method_5858((class_1297)player);
                double damageMultiplier = Math.max(0.5, 1.0 - distance / (radius * radius));
                float finalDamage = (float)((double)baseDamage * damageMultiplier);
                class_1282 damageSource = player.method_48923().method_48802(player);
                livingEntity.method_64397(serverWorld, damageSource, finalDamage);
                class_243 direction = entity.method_19538().method_1020(player.method_19538()).method_1029();
                livingEntity.method_5762(direction.field_1352 * 1.5, 0.5, direction.field_1350 * 1.5);
            }
        });
    }

    private boolean isAttackOnCooldown(class_1799 stack, class_1937 world) {
        long lastAttackTime = this.getLastAttackTime(stack);
        long currentTime = world.method_8510();
        boolean isUltimate = this.isUltimateMode(stack);
        int cooldownTicks = isUltimate ? 40 : 10;
        return currentTime - lastAttackTime < (long)cooldownTicks;
    }
}

