/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.network;

import com.xiaoshi2022.kamen_rider_weapon_craft.Kamen_Rider_Weapon_Craft;
import com.xiaoshi2022.kamen_rider_weapon_craft.items.custom.Heiseisword;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class NetworkHandler {
    public static final String RIDER_SELECTION = "rider_selection";
    public static final String ULTIMATE_MODE = "ultimate_mode";
    public static final String COMBINATION_XY = "combination_xy";

    public static void register() {
        PayloadTypeRegistry.playC2S().register(KeyPressPayload.ID, KeyPressPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(KeyPressPayload.ID, (payload, context) -> context.server().execute(() -> NetworkHandler.handleKeyPressOnServer(context.player(), payload.keyType(), payload.isPressed())));
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendKeyPressPacket(String keyType, boolean isPressed) {
        KeyPressPayload payload = new KeyPressPayload(keyType, isPressed);
        ClientPlayNetworking.send((class_8710)payload);
    }

    private static void handleKeyPressOnServer(class_3222 player, String keyType, boolean isPressed) {
        if (player == null || keyType == null) {
            Kamen_Rider_Weapon_Craft.LOGGER.warn("Received invalid key press packet");
            return;
        }
        if (isPressed) {
            switch (keyType) {
                case "rider_selection": {
                    Heiseisword.handleRiderSelectionKeyPress(player);
                    break;
                }
                case "ultimate_mode": 
                case "combination_xy": {
                    Heiseisword.handleUltimateKeyPress(player);
                    break;
                }
                default: {
                    Kamen_Rider_Weapon_Craft.LOGGER.warn("Unknown key type: {}", (Object)keyType);
                }
            }
        }
        Kamen_Rider_Weapon_Craft.LOGGER.info("Player {} pressed key: {}, state: {}", new Object[]{player.method_5477().getString(), keyType, isPressed});
    }

    public record KeyPressPayload(String keyType, boolean isPressed) implements class_8710
    {
        public static final class_8710.class_9154<KeyPressPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"kamen_rider_weapon_craft", (String)"key_press"));
        public static final class_9139<class_2540, KeyPressPayload> CODEC = class_9139.method_56438(KeyPressPayload::write, KeyPressPayload::read);

        public void write(class_2540 buf) {
            buf.method_10814(this.keyType);
            buf.method_52964(this.isPressed);
        }

        public static KeyPressPayload read(class_2540 buf) {
            return new KeyPressPayload(buf.method_19772(), buf.readBoolean());
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

