/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.BuildEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.ExAidEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.sound.RiderSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3966;

public class HeiseiRiderEffectManager {
    private static final Map<String, HeiseiRiderEffect> RIDER_EFFECTS = new HashMap<String, HeiseiRiderEffect>();
    private static final Map<String, class_3414> RIDER_NAME_SOUNDS = new HashMap<String, class_3414>();
    private static final List<String> RIDER_ORDER = new ArrayList<String>();

    private static void registerRider(String name, HeiseiRiderEffect effect, class_3414 nameSound) {
        RIDER_EFFECTS.put(name, effect);
        RIDER_NAME_SOUNDS.put(name, nameSound);
        RIDER_ORDER.add(name);
    }

    public static HeiseiRiderEffect getRiderEffect(String name) {
        return RIDER_EFFECTS.get(name);
    }

    public static double getRiderEnergyCost(String name) {
        HeiseiRiderEffect effect = HeiseiRiderEffectManager.getRiderEffect(name);
        if (effect != null) {
            try {
                return effect.getEnergyCost();
            }
            catch (AbstractMethodError e) {
                return 20.0;
            }
        }
        return 20.0;
    }

    public static class_3414 getRiderNameSound(String name) {
        return RIDER_NAME_SOUNDS.get(name);
    }

    public static List<String> getRiderOrder() {
        return Collections.unmodifiableList(RIDER_ORDER);
    }

    public static void playSelectionSound(class_1937 world, class_1657 player, String riderName) {
        class_3414 nameSound = HeiseiRiderEffectManager.getRiderNameSound(riderName);
        if (nameSound != null) {
            RiderSounds.playSelectionSound(world, player, nameSound);
        }
    }

    public static void playAttackSound(class_1937 world, class_1657 player, String riderName) {
        class_3414 nameSound = HeiseiRiderEffectManager.getRiderNameSound(riderName);
        if (nameSound != null) {
            RiderSounds.playSound(world, player, nameSound);
        }
    }

    public static void playScrambleTimeBreakSound(class_1937 world, class_1657 player, List<String> selectedRiders) {
        if (selectedRiders.isEmpty()) {
            return;
        }
    }

    public static void playUltimateTimeBreakSound(class_1937 world, class_1657 player) {
    }

    public static void playUltimateTimeBreakSound(class_1937 world, class_1657 player, List<String> selectedRiders) {
        HeiseiRiderEffectManager.playUltimateTimeBreakSound(world, player);
    }

    public static int getRiderCount() {
        return RIDER_ORDER.size();
    }

    public static String getRiderAtIndex(int index) {
        if (index >= 0 && index < RIDER_ORDER.size()) {
            return RIDER_ORDER.get(index);
        }
        return null;
    }

    public static boolean isValidRider(String riderName) {
        return RIDER_EFFECTS.containsKey(riderName);
    }

    public static void playUltimateFinishSoundSequence(class_1937 world, class_1657 player, List<String> selectedRiders) {
        if (selectedRiders.isEmpty()) {
            return;
        }
        for (int i = 0; i < selectedRiders.size(); ++i) {
            int delay = i * 8;
            String riderName = selectedRiders.get(i);
            if (!(world instanceof class_3218)) continue;
            world.method_8503().execute(() -> {
                class_3414 nameSound = HeiseiRiderEffectManager.getRiderNameSound(riderName);
                if (nameSound != null) {
                    RiderSounds.playSound(world, player, nameSound);
                }
            });
        }
        if (!selectedRiders.isEmpty() && world instanceof class_3218) {
            world.method_8503().execute(() -> RiderSounds.playSound(world, player, RiderSounds.ULTIMATE_TIME_BREAK));
        }
    }

    public static void playRiderTimeSound(class_1937 world, class_1657 player) {
        RiderSounds.playRiderTimeSound(world, player);
    }

    public static void playFinishTimeSound(class_1937 world, class_1657 player) {
        RiderSounds.playFinishTimeSound(world, player);
    }

    public static void playUltimateActivationSound(class_1937 world, class_1657 player) {
        RiderSounds.playUltimateActivationSound(world, player);
    }

    public static void playKillSound(class_1937 world, class_1657 player, class_3414 specialSound) {
        if (specialSound != null) {
            RiderSounds.playSound(world, player, specialSound);
        }
    }

    public static void playScrambleFinishSoundSequence(class_1937 world, class_1657 player, List<String> selectedRiders) {
        if (selectedRiders.isEmpty()) {
            return;
        }
        RiderSounds.playSound(world, player, RiderSounds.SCRAMBLE_TIME_BREAK);
        for (int i = 0; i < selectedRiders.size(); ++i) {
            int delay = i * 10;
            String riderName = selectedRiders.get(i);
            if (!(world instanceof class_3218)) continue;
            world.method_8503().execute(() -> {
                class_3414 nameSound = HeiseiRiderEffectManager.getRiderNameSound(riderName);
                if (nameSound != null) {
                    RiderSounds.playSound(world, player, nameSound);
                }
            });
        }
    }

    static {
        HeiseiRiderEffectManager.registerRider("Build", new BuildEffect(), RiderSounds.NAME_BUILD);
        HeiseiRiderEffectManager.registerRider("Ex-Aid", new ExAidEffect(), RiderSounds.NAME_EXAID);
        HeiseiRiderEffectManager.registerRider("Ghost", new BaseRiderEffect("Ghost", 16.0f, 4.0f, 20.0), RiderSounds.NAME_GHOST);
        HeiseiRiderEffectManager.registerRider("Drive", new BaseRiderEffect("Drive", 15.0f, 5.0f, 20.0), RiderSounds.NAME_DRIVE);
        HeiseiRiderEffectManager.registerRider("Gaim", new BaseRiderEffect("Gaim", 16.0f, 4.0f, 20.0), RiderSounds.NAME_GAIM);
        HeiseiRiderEffectManager.registerRider("Wizard", new BaseRiderEffect("Wizard", 14.0f, 6.0f, 20.0), RiderSounds.NAME_WIZARD);
        HeiseiRiderEffectManager.registerRider("Fourze", new BaseRiderEffect("Fourze", 17.0f, 3.0f, 20.0), RiderSounds.NAME_FOURZE);
        HeiseiRiderEffectManager.registerRider("OOO", new BaseRiderEffect("OOO", 16.0f, 5.0f, 20.0), RiderSounds.NAME_OOO);
        HeiseiRiderEffectManager.registerRider("W", new BaseRiderEffect("W", 15.0f, 5.0f, 20.0), RiderSounds.NAME_W);
        HeiseiRiderEffectManager.registerRider("Decade", new BaseRiderEffect("Decade", 18.0f, 4.0f, 20.0), RiderSounds.NAME_DECADE);
        HeiseiRiderEffectManager.registerRider("Kiva", new BaseRiderEffect("Kiva", 15.0f, 6.0f, 20.0), RiderSounds.NAME_KIVA);
        HeiseiRiderEffectManager.registerRider("Den-O", new BaseRiderEffect("Den-O", 16.0f, 4.0f, 20.0), RiderSounds.NAME_DEN_O);
        HeiseiRiderEffectManager.registerRider("Kabuto", new BaseRiderEffect("Kabuto", 17.0f, 3.0f, 20.0), RiderSounds.NAME_KABUTO);
        HeiseiRiderEffectManager.registerRider("Hibiki", new BaseRiderEffect("Hibiki", 14.0f, 7.0f, 20.0), RiderSounds.NAME_HIBIKI);
        HeiseiRiderEffectManager.registerRider("Blade", new BaseRiderEffect("Blade", 15.0f, 5.0f, 20.0), RiderSounds.NAME_BLADE);
        HeiseiRiderEffectManager.registerRider("Faiz", new BaseRiderEffect("Faiz", 16.0f, 4.0f, 20.0), RiderSounds.NAME_FAIZ);
        HeiseiRiderEffectManager.registerRider("Ryuki", new BaseRiderEffect("Ryuki", 15.0f, 6.0f, 20.0), RiderSounds.NAME_RYUKI);
        HeiseiRiderEffectManager.registerRider("Agito", new BaseRiderEffect("Agito", 17.0f, 4.0f, 20.0), RiderSounds.NAME_AGITO);
        HeiseiRiderEffectManager.registerRider("Kuuga", new BaseRiderEffect("Kuuga", 16.0f, 5.0f, 20.0), RiderSounds.NAME_KUUGA);
    }

    private static class BaseRiderEffect
    extends AbstractHeiseiRiderEffect {
        private final String name;
        private final float damage;
        private final float range;
        private final double energyCost;

        public BaseRiderEffect(String name, float damage, float range, double energyCost) {
            this.name = name;
            this.damage = damage;
            this.range = range;
            this.energyCost = energyCost;
        }

        @Override
        public void executeSpecialAttack(class_1937 world, class_1657 player, class_243 direction) {
            class_3966 entityHitResult;
            class_1297 entity;
            double reach = 10.0;
            class_243 start = player.method_33571();
            class_243 end = start.method_1019(direction.method_1021(reach));
            class_239 hitResult = player.method_5745(reach, 0.0f, false);
            if (hitResult instanceof class_3966 && (entity = (entityHitResult = (class_3966)hitResult).method_17782()) != player) {
                player.method_7324(entity);
            }
        }

        @Override
        public String getRiderName() {
            return this.name;
        }

        @Override
        public String getActivationSoundName() {
            return "activation_" + this.name.toLowerCase().replace("-", "_");
        }

        @Override
        public float getAttackDamage() {
            return this.damage;
        }

        @Override
        public float getEffectRange() {
            return this.range;
        }

        @Override
        public double getEnergyCost() {
            return this.energyCost;
        }
    }
}

