/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.exaid.ExAidSlashEffectEntity;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import net.minecraft.class_6880;

public class ExAidEffect
extends AbstractHeiseiRiderEffect {
    private static final Map<class_1309, Integer> DAMAGE_TARGETS = new HashMap<class_1309, Integer>();
    private static final int DURATION = 60;
    private static final int DAMAGE_INTERVAL = 10;
    private static final Map<Integer, DelayedEffectInfo> DELAYED_EFFECTS = new HashMap<Integer, DelayedEffectInfo>();
    private static int nextEffectId = 0;

    public ExAidEffect() {
        ServerTickEvents.END_SERVER_TICK.register(server -> ExAidEffect.onServerTick());
    }

    @Override
    public void executeSpecialAttack(class_1937 world, class_1657 player, class_243 direction) {
        if (!world.method_8608()) {
            player.method_6092(new class_1293(class_1294.field_5904, 400, 1));
            player.method_6092(new class_1293(class_1294.field_5910, 400, 1));
            player.method_6092(new class_1293(class_1294.field_5924, 200, 2));
            double reach = 8.0;
            class_243 start = player.method_33571();
            class_243 end = start.method_1019(direction.method_1021(reach));
            class_1297 hitEntity = this.getTargetEntity(world, player, start, end, reach);
            if (hitEntity instanceof class_1309 && hitEntity != player) {
                class_1309 livingEntity = (class_1309)hitEntity;
                float initialDamage = this.getAttackDamage() * 0.5f;
                if (livingEntity != player) {
                    boolean bl = livingEntity.method_64397((class_3218)world, world.method_48963().method_48802(player), initialDamage);
                }
                this.addToDamageTargets(livingEntity, player);
                this.spawnSlashEffectOnEntity(hitEntity, world, player, direction);
                ExAidSlashEffectEntity.spawnEffectOnTarget(world, (class_1297)player, hitEntity);
            } else {
                ExAidSlashEffectEntity.spawnEffect(world, (class_1297)player, direction);
            }
        } else {
            ExAidSlashEffectEntity.spawnEffect(world, (class_1297)player, direction);
        }
    }

    private void addToDamageTargets(class_1309 target, class_1657 player) {
        if (target != player) {
            DAMAGE_TARGETS.put(target, 60);
        }
    }

    private static void onServerTick() {
        ExAidEffect.handleDamageTargets();
        ExAidEffect.handleDelayedEffects();
    }

    private static void handleDamageTargets() {
        Iterator<Map.Entry<class_1309, Integer>> damageIterator = DAMAGE_TARGETS.entrySet().iterator();
        while (damageIterator.hasNext()) {
            Map.Entry<class_1309, Integer> entry = damageIterator.next();
            class_1309 target = entry.getKey();
            int remainingTicks = entry.getValue() - 1;
            if (target == null || !target.method_5805() || target.method_31481()) {
                damageIterator.remove();
                continue;
            }
            if (remainingTicks % 10 == 0) {
                float dotDamage = 5.0f;
                target.method_64397((class_3218)target.method_37908(), target.method_37908().method_48963().method_48831(), dotDamage);
                ExAidEffect.spawnDotEffect(target);
            }
            if (remainingTicks <= 0) {
                damageIterator.remove();
                continue;
            }
            DAMAGE_TARGETS.put(target, remainingTicks);
        }
    }

    private static void handleDelayedEffects() {
        Iterator<Map.Entry<Integer, DelayedEffectInfo>> effectIterator = DELAYED_EFFECTS.entrySet().iterator();
        while (effectIterator.hasNext()) {
            Map.Entry<Integer, DelayedEffectInfo> entry = effectIterator.next();
            DelayedEffectInfo info = entry.getValue();
            if (info.targetEntity == null || !info.targetEntity.method_5805() || info.targetEntity.method_31481()) {
                effectIterator.remove();
                continue;
            }
            --info.remainingTicks;
            if (info.remainingTicks <= 0 && info.spawnedEffects < info.totalEffects) {
                ExAidEffect.spawnSingleDelayedEffect(info);
                info.remainingTicks = 3;
            }
            if (info.spawnedEffects < info.totalEffects) continue;
            effectIterator.remove();
        }
    }

    private static void spawnDotEffect(class_1309 target) {
        class_1937 world = target.method_37908();
        if (!world.method_8608() && target != null) {
            double x = target.method_23317() + (world.field_9229.method_43058() - 0.5) * 0.8;
            double y = target.method_23318() + (double)target.method_17682() * 0.5 + (world.field_9229.method_43058() - 0.5) * 0.5;
            double z = target.method_23321() + (world.field_9229.method_43058() - 0.5) * 0.8;
            ExAidSlashEffectEntity effect = new ExAidSlashEffectEntity(ModEntityTypes.EXAID_SLASH_EFFECT, world);
            effect.method_5814(x, y, z);
            effect.method_36456(world.field_9229.method_43057() * 360.0f);
            effect.method_36457(world.field_9229.method_43057() * 360.0f);
            effect.method_5875(true);
            effect.method_5684(true);
            world.method_8649((class_1297)effect);
        }
    }

    private class_1297 getTargetEntity(class_1937 world, class_1657 player, class_243 start, class_243 end, double reach) {
        class_239 result;
        class_238 box = new class_238(Math.min(start.field_1352, end.field_1352) - 1.0, Math.min(start.field_1351, end.field_1351) - 1.0, Math.min(start.field_1350, end.field_1350) - 1.0, Math.max(start.field_1352, end.field_1352) + 1.0, Math.max(start.field_1351, end.field_1351) + 1.0, Math.max(start.field_1350, end.field_1350) + 1.0);
        List entities = world.method_8390(class_1297.class, box, entity -> entity instanceof class_1309 && !entity.method_7325() && entity.method_5805() && entity != player);
        double closestDistance = Double.MAX_VALUE;
        class_1297 closestEntity = null;
        for (class_1297 entity2 : entities) {
            double distance;
            class_243 closestPoint = entity2.method_5829().method_992(start, end).orElse(null);
            if (closestPoint == null || !((distance = start.method_1022(closestPoint)) <= reach) || !(distance < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity2;
        }
        if (closestEntity == null && (result = player.method_5745(reach, 0.0f, false)) instanceof class_3966) {
            class_3966 entityHitResult = (class_3966)result;
            return entityHitResult.method_17782();
        }
        return closestEntity;
    }

    private static void spawnSingleDelayedEffect(DelayedEffectInfo info) {
        if (!info.world.method_8608() && info.targetEntity != null && info.targetEntity.method_5805()) {
            double x = info.targetEntity.method_23317();
            double y = info.targetEntity.method_23318() + (double)info.targetEntity.method_17682() * 0.5;
            double z = info.targetEntity.method_23321();
            class_243 lookVector = info.direction.method_1029();
            double radius = (double)Math.max(info.targetEntity.method_17681(), info.targetEntity.method_17682()) * 0.6;
            double angle = info.world.field_9229.method_43058() * Math.PI * 2.0;
            double heightVariation = info.world.field_9229.method_43058() * 0.8 - 0.4;
            double offsetX = Math.cos(angle) * radius * (info.world.field_9229.method_43058() * 0.7 + 0.3);
            double offsetY = heightVariation * (double)info.targetEntity.method_17682() * 0.5 + 0.2;
            double offsetZ = Math.sin(angle) * radius * (info.world.field_9229.method_43058() * 0.7 + 0.3);
            ExAidSlashEffectEntity effect = new ExAidSlashEffectEntity(ModEntityTypes.EXAID_SLASH_EFFECT, info.world);
            effect.method_5814(x + offsetX, y + offsetY, z + offsetZ);
            float yRot = (float)Math.toDegrees(Math.atan2(-lookVector.field_1352, lookVector.field_1350)) + (info.world.field_9229.method_43057() - 0.5f) * 180.0f;
            float xRot = (float)Math.toDegrees(Math.atan2(lookVector.field_1351, Math.sqrt(lookVector.field_1352 * lookVector.field_1352 + lookVector.field_1350 * lookVector.field_1350))) + (info.world.field_9229.method_43057() - 0.5f) * 90.0f;
            effect.method_36456(yRot);
            effect.method_36457(xRot);
            effect.method_5875(true);
            effect.method_5684(true);
            effect.setOwner((class_1297)info.owner);
            effect.setTargetEntity(info.targetEntity);
            info.world.method_8649((class_1297)effect);
            ++info.spawnedEffects;
            if (info.targetEntity instanceof class_1309 && info.targetEntity != info.owner) {
                class_1309 targetLiving = (class_1309)info.targetEntity;
                if (!info.world.method_8608()) {
                    float damage = 8.0f;
                    targetLiving.method_64397((class_3218)info.world, info.world.method_48963().method_48802(info.owner), damage);
                }
            }
        }
    }

    private void spawnSlashEffectOnEntity(class_1297 entity, class_1937 world, class_1657 player, class_243 direction) {
        if (!world.method_8608() && entity != null) {
            DELAYED_EFFECTS.put(nextEffectId++, new DelayedEffectInfo(entity, world, player, direction, 0, 7));
            this.playHitSound(world, entity.method_23317(), entity.method_23318() + (double)entity.method_17682() * 0.5, entity.method_23321());
        }
    }

    private void playHitSound(class_1937 world, double x, double y, double z) {
        float volume = 0.8f + world.field_9229.method_43057() * 0.2f;
        float pitch = 0.9f + world.field_9229.method_43057() * 0.2f;
        world.method_60511(null, x, y, z, (class_6880)class_3417.field_15152, class_3419.field_15248, volume, pitch);
        world.method_43128(null, x, y, z, class_3417.field_14970, class_3419.field_15248, volume * 0.7f, pitch * 1.2f);
    }

    @Override
    public String getRiderName() {
        return "Ex-Aid";
    }

    @Override
    public String getActivationSoundName() {
        return "Critical Strike!";
    }

    @Override
    public float getAttackDamage() {
        return 52.0f;
    }

    @Override
    public float getEffectRange() {
        return 8.0f;
    }

    private static class DelayedEffectInfo {
        class_1297 targetEntity;
        class_1937 world;
        class_1657 owner;
        class_243 direction;
        int remainingTicks;
        int totalEffects;
        int spawnedEffects;

        DelayedEffectInfo(class_1297 targetEntity, class_1937 world, class_1657 owner, class_243 direction, int delayTicks, int totalEffects) {
            this.targetEntity = targetEntity;
            this.world = world;
            this.owner = owner;
            this.direction = direction;
            this.remainingTicks = delayTicks;
            this.totalEffects = totalEffects;
            this.spawnedEffects = 0;
        }
    }
}

