/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.energy;

import com.xiaoshi2022.kamen_rider_weapon_craft.items.custom.Heiseisword;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeiseiswordEnergyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeiseiswordEnergyManager.class);
    private static final double DEFAULT_MAX_ENERGY = 100.0;
    private static final double ENERGY_REGEN_RATE = 2.0;
    private static final Map<UUID, class_2487> playerEnergyCache = new HashMap<UUID, class_2487>();

    private static class_2487 getOrCreateEnergyData(class_1657 player) {
        if (player == null) {
            return new class_2487();
        }
        UUID playerId = player.method_5667();
        return playerEnergyCache.computeIfAbsent(playerId, id -> {
            class_2487 energyData = new class_2487();
            energyData.method_10549("current_energy", 100.0);
            energyData.method_10549("max_energy", 100.0);
            return energyData;
        });
    }

    public static double getCurrentEnergy(class_1657 player) {
        if (player == null) {
            return 0.0;
        }
        class_2487 energyData = HeiseiswordEnergyManager.getOrCreateEnergyData(player);
        return energyData.method_10545("current_energy") ? energyData.method_10574("current_energy").orElse(0.0) : 0.0;
    }

    public static double getMaxEnergy(class_1657 player) {
        if (player == null) {
            return 100.0;
        }
        class_2487 energyData = HeiseiswordEnergyManager.getOrCreateEnergyData(player);
        return energyData.method_10545("max_energy") ? energyData.method_10574("max_energy").orElse(100.0) : 100.0;
    }

    public static void setCurrentEnergy(class_1657 player, double energy) {
        if (player == null) {
            return;
        }
        double maxEnergy = HeiseiswordEnergyManager.getMaxEnergy(player);
        energy = Math.max(0.0, Math.min(energy, maxEnergy));
        UUID playerId = player.method_5667();
        class_2487 energyData = HeiseiswordEnergyManager.getOrCreateEnergyData(player);
        energyData.method_10549("current_energy", energy);
        energyData.method_10549("max_energy", maxEnergy);
        playerEnergyCache.put(playerId, energyData);
        HeiseiswordEnergyManager.syncEnergyToClient(player);
    }

    public static void setMaxEnergy(class_1657 player, double maxEnergy) {
        if (player == null) {
            return;
        }
        maxEnergy = Math.max(1.0, maxEnergy);
        UUID playerId = player.method_5667();
        class_2487 energyData = HeiseiswordEnergyManager.getOrCreateEnergyData(player);
        double currentEnergy = Math.min(HeiseiswordEnergyManager.getCurrentEnergy(player), maxEnergy);
        energyData.method_10549("current_energy", currentEnergy);
        energyData.method_10549("max_energy", maxEnergy);
        playerEnergyCache.put(playerId, energyData);
        HeiseiswordEnergyManager.syncEnergyToClient(player);
    }

    public static boolean canUseEnergy(class_1657 player, double cost) {
        return HeiseiswordEnergyManager.getCurrentEnergy(player) >= cost;
    }

    public static boolean consumeEnergy(class_1657 player, double cost) {
        if (player == null) {
            return false;
        }
        if (HeiseiswordEnergyManager.getCurrentEnergy(player) >= cost) {
            if (!player.method_37908().field_9236 && player instanceof class_3222) {
                HeiseiswordEnergyManager.setCurrentEnergy(player, HeiseiswordEnergyManager.getCurrentEnergy(player) - cost);
            }
            return true;
        }
        return false;
    }

    public static void recoverEnergy(class_1657 player, double amount) {
        if (player == null) {
            return;
        }
        if (!player.method_37908().field_9236 && player instanceof class_3222) {
            HeiseiswordEnergyManager.setCurrentEnergy(player, HeiseiswordEnergyManager.getCurrentEnergy(player) + amount);
        }
    }

    private static void syncEnergyToClient(class_1657 player) {
        if (player == null || player.method_37908().field_9236 || player instanceof class_3222) {
            // empty if block
        }
    }

    public static void recoverEnergyByDamage(class_1657 player, float damage) {
        if (player == null) {
            return;
        }
        double recoveryAmount = (double)damage * 0.25;
        HeiseiswordEnergyManager.recoverEnergy(player, recoveryAmount);
    }

    public static void updateEnergyRegen(class_1657 player) {
        if (player == null || player.method_68878()) {
            return;
        }
        if (player.method_6047().method_7909() instanceof Heiseisword) {
            HeiseiswordEnergyManager.recoverEnergy(player, 2.0);
        }
    }

    public static void resetEnergy(class_1657 player) {
        HeiseiswordEnergyManager.setCurrentEnergy(player, HeiseiswordEnergyManager.getMaxEnergy(player));
    }

    public static void initializePlayerEnergy(class_1657 player) {
        if (player == null) {
            return;
        }
        try {
            UUID playerId = player.method_5667();
            if (!playerEnergyCache.containsKey(playerId)) {
                class_2487 energyData = new class_2487();
                energyData.method_10549("current_energy", 100.0);
                energyData.method_10549("max_energy", 100.0);
                playerEnergyCache.put(playerId, energyData);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize player energy data: {}", (Object)e.getMessage());
        }
    }

    public static void clearPlayerData(class_1657 player) {
        if (player != null) {
            playerEnergyCache.remove(player.method_5667());
        }
    }
}

