/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.builds;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BuildRiderEntity
extends class_1297
implements GeoEntity {
    private static final RawAnimation MOVE_ANIMATION = RawAnimation.begin().thenPlay("move");
    private static final RawAnimation HIT_ANIMATION = RawAnimation.begin().thenPlay("attack.hit");
    private static final class_2940<Float> DAMAGE = class_2945.method_12791(BuildRiderEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> LIFETIME = class_2945.method_12791(BuildRiderEntity.class, (class_2941)class_2943.field_13327);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int MAX_LIFETIME = 100;
    private class_1309 owner;

    public BuildRiderEntity(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
        this.field_5960 = true;
    }

    public BuildRiderEntity(class_1937 world, class_1309 owner, class_243 direction, float damage) {
        this(ModEntityTypes.BUILD_RIDER_EFFECT, world);
        this.owner = owner;
        this.method_33574(owner.method_33571().method_1019(direction.method_1021(1.0)));
        this.method_18799(direction);
        this.method_5841().method_12778(DAMAGE, (Object)Float.valueOf(damage));
        this.method_5841().method_12778(LIFETIME, (Object)0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DAMAGE, (Object)Float.valueOf(10.0f));
        builder.method_56912(LIFETIME, (Object)0);
    }

    public float getDamage() {
        return ((Float)this.method_5841().method_12789(DAMAGE)).floatValue();
    }

    public int getLifetime() {
        return (Integer)this.method_5841().method_12789(LIFETIME);
    }

    public void method_5773() {
        class_239 hitResult;
        super.method_5773();
        int currentLifetime = this.getLifetime() + 1;
        this.method_5841().method_12778(LIFETIME, (Object)currentLifetime);
        if (currentLifetime > 100) {
            this.method_31472();
            return;
        }
        class_243 velocity = this.method_18798();
        class_243 pos = this.method_19538();
        this.method_33574(pos.method_1019(velocity));
        if (!this.method_37908().method_8608() && (hitResult = class_1675.method_49997((class_1297)this, entity -> !entity.method_7325() && entity.method_5805() && entity != this.owner)).method_17783() != class_239.class_240.field_1333) {
            this.onCollision(hitResult);
        }
        this.method_18799(velocity.method_1021(0.98));
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return false;
    }

    protected void method_5749(class_11368 view) {
    }

    protected void method_5652(class_11372 view) {
    }

    protected void onCollision(class_239 hitResult) {
        if (!this.method_37908().method_8608()) {
            class_1309 living;
            class_3966 entityHit;
            class_1297 class_12972;
            if (hitResult instanceof class_3966 && (class_12972 = (entityHit = (class_3966)hitResult).method_17782()) instanceof class_1309 && (living = (class_1309)class_12972) != this.owner) {
                try {
                    class_1282 damageSource = this.owner != null ? this.method_48923().method_48800((class_1297)this, this.owner) : this.method_48923().method_48831();
                    if (this.method_37908() instanceof class_3218) {
                        living.method_64397((class_3218)this.method_37908(), damageSource, this.getDamage());
                    }
                }
                catch (Exception e) {
                    System.err.println("Build\u5b9e\u4f53\u4f24\u5bb3\u5904\u7406\u5931\u8d25: " + e.getMessage());
                }
            }
            this.explode();
        }
    }

    private void explode() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3222 player;
            double distanceToPlayer;
            class_3218 serverWorld = (class_3218)class_19372;
            for (int i = 0; i < 20; ++i) {
                double offsetX = (this.field_5974.method_43058() - 0.5) * 2.0;
                double offsetY = (this.field_5974.method_43058() - 0.5) * 2.0;
                double offsetZ = (this.field_5974.method_43058() - 0.5) * 2.0;
                serverWorld.method_65096((class_2394)class_2398.field_11236, this.method_23317(), this.method_23318(), this.method_23321(), 1, offsetX * 0.1, offsetY * 0.1, offsetZ * 0.1, 0.0);
            }
            class_1309 offsetX = this.owner;
            if (offsetX instanceof class_3222 && (distanceToPlayer = this.method_5858((class_1297)(player = (class_3222)offsetX))) < 4.0) {
                class_243 playerPos = player.method_19538();
                class_243 explosionPos = this.method_19538();
                class_243 direction = playerPos.method_1020(explosionPos).method_1029().method_1021(1.5);
                direction = new class_243(direction.field_1352, 2.5, direction.field_1350);
                player.method_18799(direction);
                player.field_6037 = true;
                player.method_6092(new class_1293(class_1294.field_5906, 100, 0, false, false));
            }
            List nearbyEntities = serverWorld.method_18467(class_1309.class, this.method_5829().method_1014(5.0));
            class_243 explosionCenter = this.method_19538();
            for (class_1309 entity : nearbyEntities) {
                class_243 entityPos;
                class_243 toCenter;
                double distance;
                if (entity == this.owner || !((distance = (toCenter = explosionCenter.method_1020(entityPos = entity.method_19538())).method_1033()) > 0.0)) continue;
                double force = Math.max(0.1, (5.0 - distance) * 0.3);
                if (entity instanceof class_3222) {
                    force *= 1.2;
                }
                class_243 pullDirection = toCenter.method_1029().method_1021(force);
                entity.method_5762(pullDirection.field_1352, pullDirection.field_1351 * 0.5, pullDirection.field_1350);
                entity.field_6037 = true;
                try {
                    class_1282 damageSource = this.owner != null ? this.method_48923().method_48800((class_1297)this, this.owner) : this.method_48923().method_48831();
                    float adjustedDamage = this.getDamage() * (1.0f - (float)(distance / 10.0));
                    entity.method_64397(serverWorld, damageSource, adjustedDamage);
                }
                catch (Exception e) {
                    System.err.println("Build\u5b9e\u4f53\u7206\u70b8\u4f24\u5bb3\u5904\u7406\u5931\u8d25: " + e.getMessage());
                }
            }
        }
        this.method_31472();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("main", 5, state -> {
            if (this.getLifetime() > 80) {
                state.setAnimation(HIT_ANIMATION);
            } else {
                state.setAnimation(MOVE_ANIMATION);
            }
            return PlayState.CONTINUE;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

