/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.sound;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class RiderSounds {
    private static final Map<String, class_3414> SOUND_REGISTRY = new HashMap<String, class_3414>();
    public static final class_3414 RIDE_HEI_SABER = RiderSounds.register("ride_hei_saber");
    public static final class_3414 FINISH_TIME = RiderSounds.register("finish_time");
    public static final class_3414 ULTIMATE_TIME_BREAK = RiderSounds.register("ultimate_time_break");
    public static final class_3414 SCRAMBLE_TIME_BREAK = RiderSounds.register("scramble_time_break");
    public static final class_3414 DUAL_TIME_BREAK = RiderSounds.register("dual_time_break");
    public static final class_3414 HEY = RiderSounds.register("hey");
    public static final class_3414 HEY_SAY_RAPID = RiderSounds.register("hey_say_rapid");
    public static final class_3414 NAME_BUILD = RiderSounds.register("name_build");
    public static final class_3414 NAME_EXAID = RiderSounds.register("name_exaid");
    public static final class_3414 NAME_GHOST = RiderSounds.register("name_ghost");
    public static final class_3414 NAME_DRIVE = RiderSounds.register("name_drive");
    public static final class_3414 NAME_GAIM = RiderSounds.register("name_gaim");
    public static final class_3414 NAME_WIZARD = RiderSounds.register("name_wizard");
    public static final class_3414 NAME_FOURZE = RiderSounds.register("name_fourze");
    public static final class_3414 NAME_OOO = RiderSounds.register("name_ooo");
    public static final class_3414 NAME_W = RiderSounds.register("name_w");
    public static final class_3414 NAME_DECADE = RiderSounds.register("name_decade");
    public static final class_3414 NAME_KIVA = RiderSounds.register("name_kiva");
    public static final class_3414 NAME_DEN_O = RiderSounds.register("name_den_o");
    public static final class_3414 NAME_KABUTO = RiderSounds.register("name_kabuto");
    public static final class_3414 NAME_HIBIKI = RiderSounds.register("name_hibiki");
    public static final class_3414 NAME_BLADE = RiderSounds.register("name_blade");
    public static final class_3414 NAME_FAIZ = RiderSounds.register("name_faiz");
    public static final class_3414 NAME_RYUKI = RiderSounds.register("name_ryuki");
    public static final class_3414 NAME_AGITO = RiderSounds.register("name_agito");
    public static final class_3414 NAME_KUUGA = RiderSounds.register("name_kuuga");

    private static class_3414 register(String name) {
        class_2960 id = class_2960.method_60655((String)"kamen_rider_weapon_craft", (String)name);
        class_3414 soundEvent = class_3414.method_47908((class_2960)id);
        SOUND_REGISTRY.put(name, soundEvent);
        return soundEvent;
    }

    public static void registerSounds() {
        for (Map.Entry<String, class_3414> entry : SOUND_REGISTRY.entrySet()) {
            class_2960 id = class_2960.method_60655((String)"kamen_rider_weapon_craft", (String)entry.getKey());
            if (class_7923.field_41172.method_10250(id)) continue;
            class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)id, (Object)entry.getValue());
        }
    }

    public static void playSound(class_1937 world, class_1657 player, class_3414 sound) {
        if (world.method_8608()) {
            world.method_60511((class_1297)player, player.method_23317(), player.method_23318(), player.method_23321(), class_6880.method_40223((Object)sound), class_3419.field_15248, 1.0f, 1.0f);
        } else {
            ((class_3218)world).method_60511(null, player.method_23317(), player.method_23318(), player.method_23321(), class_6880.method_40223((Object)sound), class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public static void playSelectionSound(class_1937 world, class_1657 player, class_3414 nameSound) {
        RiderSounds.playSound(world, player, HEY);
        if (nameSound != null) {
            RiderSounds.playDelayedSound(world, player, nameSound, 10);
        }
    }

    public static void playAttackSound(class_1937 world, class_1657 player, class_3414 nameSound) {
        if (nameSound != null) {
            RiderSounds.playSound(world, player, nameSound);
        }
    }

    public static void playFinishTimeSound(class_1937 world, class_1657 player) {
        RiderSounds.playSound(world, player, FINISH_TIME);
    }

    public static void playRiderTimeSound(class_1937 world, class_1657 player) {
        RiderSounds.playSound(world, player, RIDE_HEI_SABER);
    }

    public static void playUltimateActivationSound(class_1937 world, class_1657 player) {
        RiderSounds.playSound(world, player, ULTIMATE_TIME_BREAK);
    }

    public static void playRapidSelectionSound(class_1937 world, class_1657 player) {
        RiderSounds.playSound(world, player, HEY_SAY_RAPID);
    }

    public static void playDelayedSound(class_1937 world, class_1657 player, class_3414 sound, int delayTicks) {
        if (world.method_8608()) {
            new Thread(() -> {
                try {
                    Thread.sleep((long)delayTicks * 50L);
                    RiderSounds.playSound(world, player, sound);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
        } else {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_8503().execute(() -> RiderSounds.playSound(world, player, sound));
        }
    }

    public static void playDelayedSoundSequence(final class_1937 world, final class_1657 player, List<DelayedSound> sounds) {
        if (world.method_8608()) {
            new Thread(() -> {
                for (DelayedSound delayedSound : sounds) {
                    try {
                        Thread.sleep((long)delayedSound.delayTicks * 50L);
                        RiderSounds.playSound(world, player, delayedSound.sound);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }).start();
        } else {
            final class_3218 serverWorld = (class_3218)world;
            Timer timer = new Timer(true);
            Iterator<DelayedSound> iterator = sounds.iterator();
            while (iterator.hasNext()) {
                DelayedSound delayedSound;
                final DelayedSound finalSound = delayedSound = iterator.next();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        serverWorld.method_8503().execute(() -> RiderSounds.playSound(world, player, finalSound2.sound));
                    }
                }, (long)delayedSound.delayTicks * 50L);
            }
        }
    }

    public static void playRiderNameSound(class_1937 world, class_1657 player, String riderName) {
        class_3414 soundEvent = RiderSounds.getRiderNameSound(riderName);
        if (soundEvent != null) {
            RiderSounds.playSound(world, player, soundEvent);
        }
    }

    public static class_3414 getRiderNameSound(String riderName) {
        return switch (riderName) {
            case "Build" -> NAME_BUILD;
            case "Ex-Aid" -> NAME_EXAID;
            case "Ghost" -> NAME_GHOST;
            case "Drive" -> NAME_DRIVE;
            case "Gaim" -> NAME_GAIM;
            case "Wizard" -> NAME_WIZARD;
            case "Fourze" -> NAME_FOURZE;
            case "OOO" -> NAME_OOO;
            case "W" -> NAME_W;
            case "Decade" -> NAME_DECADE;
            case "Kiva" -> NAME_KIVA;
            case "Den-O" -> NAME_DEN_O;
            case "Kabuto" -> NAME_KABUTO;
            case "Hibiki" -> NAME_HIBIKI;
            case "Blade" -> NAME_BLADE;
            case "Faiz" -> NAME_FAIZ;
            case "Ryuki" -> NAME_RYUKI;
            case "Agito" -> NAME_AGITO;
            case "Kuuga" -> NAME_KUUGA;
            default -> null;
        };
    }

    public static void playUltimateFinishSoundSequence(class_1937 world, class_1657 player, List<String> riders) {
        ArrayList<DelayedSound> sounds = new ArrayList<DelayedSound>();
        sounds.add(new DelayedSound(HEY, 0));
        int delay = 20;
        for (String riderName : riders) {
            class_3414 nameSound = RiderSounds.getRiderNameSound(riderName);
            if (nameSound == null) continue;
            sounds.add(new DelayedSound(nameSound, delay));
            delay += 10;
        }
        sounds.add(new DelayedSound(ULTIMATE_TIME_BREAK, delay + 20));
        RiderSounds.playDelayedSoundSequence(world, player, sounds);
    }

    public static void playScrambleFinishSoundSequence(class_1937 world, class_1657 player, List<String> riders) {
        ArrayList<DelayedSound> sounds = new ArrayList<DelayedSound>();
        sounds.add(new DelayedSound(HEY, 0));
        int delay = 20;
        for (String riderName : riders) {
            class_3414 nameSound = RiderSounds.getRiderNameSound(riderName);
            if (nameSound == null) continue;
            sounds.add(new DelayedSound(nameSound, delay));
            delay += 10;
        }
        sounds.add(new DelayedSound(SCRAMBLE_TIME_BREAK, delay + 20));
        RiderSounds.playDelayedSoundSequence(world, player, sounds);
    }

    public static class DelayedSound {
        public final class_3414 sound;
        public final int delayTicks;

        public DelayedSound(class_3414 sound, int delayTicks) {
            this.sound = sound;
            this.delayTicks = delayTicks;
        }
    }
}

