/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom;

import com.xiaoshi2022.kamen_rider_weapon_craft.Item.client.Heiseisword.HeiseiswordRenderer;
import com.xiaoshi2022.kamen_rider_weapon_craft.network.HeiseiswordRiderSelectionPacket;
import com.xiaoshi2022.kamen_rider_weapon_craft.network.NetworkHandler;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffectManager;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.energy.HeiseiswordEnergyManager;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.den_o.DenOTrainEntity;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.sound.RiderSounds;
import com.xiaoshi2022.kamen_rider_weapon_craft.util.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Heiseisword
extends SwordItem
implements GeoItem {
    private static final RawAnimation ROTATE_POSITION_1 = RawAnimation.begin().thenPlay("rotate_pos1");
    private static final RawAnimation ROTATE_POSITION_2 = RawAnimation.begin().thenPlay("rotate_pos2");
    private static final RawAnimation ROTATE_POSITION_3 = RawAnimation.begin().thenPlay("rotate_pos3");
    private static final RawAnimation ROTATE_POSITION_4 = RawAnimation.begin().thenPlay("rotate_pos4");
    private static final RawAnimation ULTIMATE_TIME_BREAK_ANIM = RawAnimation.begin().thenPlay("ridertime");
    private static final RawAnimation SWORD_FORM_ANIM = RawAnimation.begin().thenLoop("animation.den_o.sword.idle");
    private static final RawAnimation FISHING_ROD_FORM_ANIM = RawAnimation.begin().thenLoop("animation.den_o.fishing_rod.idle");
    private static final RawAnimation AX_FORM_ANIM = RawAnimation.begin().thenLoop("animation.den_o.ax.idle");
    private static final RawAnimation GUN_FORM_ANIM = RawAnimation.begin().thenLoop("animation.den_o.gun.idle");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final String TAG_DEN_O_WEAPON_TYPE = "den_o_weapon_type";
    private static final String TAG_HAS_ATTACHED_ENTITY = "has_attached_entity";
    private static final String TAG_SWORD_PROJECTILE_READY = "sword_projectile_ready";
    private static final String TAG_SELECTED_RIDER = "selectedRider";
    private static final String TAG_SCRAMBLE_RIDERS = "scrambleRiders";
    private static final String TAG_IS_FINISH_TIME_MODE = "isFinishTimeMode";
    private static final String TAG_IS_ULTIMATE_MODE = "isUltimateMode";
    private static final String TAG_ROTATION_COUNT = "rotationCount";
    private static final String TAG_LAST_ROTATION_TIME = "lastRotationTime";
    private static final String TAG_CURRENT_ROTATION_POSITION = "currentRotationPosition";
    private static final String TAG_LAST_ATTACK_TIME = "lastAttackTime";
    private static final String TAG_LAST_RIDER_SELECTION_TIME = "lastRiderSelectionTime";
    private static final String TAG_LAST_FINISH_TIME_ENTER = "lastFinishTimeEnter";
    private static final int ATTACK_COOLDOWN_TICKS = 10;
    private static final int ULTIMATE_ATTACK_COOLDOWN_TICKS = 40;
    private static final int RIDER_SELECTION_COOLDOWN_TICKS = 15;
    private static final int FINISH_TIME_COOLDOWN_TICKS = 300;

    private long getLastAttackTime(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0L;
        }
        return stack.m_41783_().m_128454_(TAG_LAST_ATTACK_TIME);
    }

    private void setLastAttackTime(ItemStack stack, long time) {
        stack.m_41784_().m_128356_(TAG_LAST_ATTACK_TIME, time);
    }

    private boolean isAttackOnCooldown(ItemStack stack, Level level) {
        long lastAttackTime = this.getLastAttackTime(stack);
        long currentTime = level.m_46467_();
        boolean isUltimate = this.isUltimateMode(stack);
        int cooldownTicks = isUltimate ? 40 : 10;
        return currentTime - lastAttackTime < (long)cooldownTicks;
    }

    private String getSelectedRider(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        return stack.m_41783_().m_128461_(TAG_SELECTED_RIDER);
    }

    private void setSelectedRider(ItemStack stack, String riderName) {
        stack.m_41784_().m_128359_(TAG_SELECTED_RIDER, riderName != null ? riderName : "");
    }

    private List<String> getScrambleRiders(ItemStack stack) {
        ArrayList<String> riders = new ArrayList<String>();
        if (!stack.m_41782_()) {
            return riders;
        }
        CompoundTag tag = stack.m_41783_();
        if (!tag.m_128441_("scrambleRiders_size")) {
            return riders;
        }
        int size = tag.m_128451_("scrambleRiders_size");
        for (int i = 0; i < size; ++i) {
            if (!tag.m_128441_("scrambleRiders_" + i)) continue;
            riders.add(tag.m_128461_("scrambleRiders_" + i));
        }
        return riders;
    }

    public static void setScrambleRiders(ItemStack stack, List<String> riders) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("scrambleRiders_size")) {
            int oldSize = tag.m_128451_("scrambleRiders_size");
            for (int i = 0; i < oldSize; ++i) {
                tag.m_128473_("scrambleRiders_" + i);
            }
        }
        tag.m_128405_("scrambleRiders_size", riders.size());
        for (int i = 0; i < riders.size(); ++i) {
            tag.m_128359_("scrambleRiders_" + i, riders.get(i));
        }
    }

    private boolean isFinishTimeMode(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        return stack.m_41783_().m_128471_(TAG_IS_FINISH_TIME_MODE);
    }

    private void setFinishTimeMode(ItemStack stack, boolean mode) {
        stack.m_41784_().m_128379_(TAG_IS_FINISH_TIME_MODE, mode);
    }

    private boolean isUltimateMode(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        return stack.m_41783_().m_128471_(TAG_IS_ULTIMATE_MODE);
    }

    private void setUltimateMode(ItemStack stack, boolean mode) {
        stack.m_41784_().m_128379_(TAG_IS_ULTIMATE_MODE, mode);
    }

    private int getRotationCount(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0;
        }
        return stack.m_41783_().m_128451_(TAG_ROTATION_COUNT);
    }

    private void setRotationCount(ItemStack stack, int count) {
        stack.m_41784_().m_128405_(TAG_ROTATION_COUNT, count);
    }

    private long getLastRotationTime(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0L;
        }
        return stack.m_41783_().m_128454_(TAG_LAST_ROTATION_TIME);
    }

    private void setLastRotationTime(ItemStack stack, long time) {
        stack.m_41784_().m_128356_(TAG_LAST_ROTATION_TIME, time);
    }

    private long getLastFinishTimeEnter(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0L;
        }
        return stack.m_41783_().m_128454_(TAG_LAST_FINISH_TIME_ENTER);
    }

    private void setLastFinishTimeEnter(ItemStack stack, long time) {
        stack.m_41784_().m_128356_(TAG_LAST_FINISH_TIME_ENTER, time);
    }

    private boolean isFinishTimeOnCooldown(ItemStack stack, Level level) {
        long lastEnterTime = this.getLastFinishTimeEnter(stack);
        long currentTime = level.m_46467_();
        return currentTime - lastEnterTime < 300L;
    }

    private int getCurrentRotationPosition(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0;
        }
        return stack.m_41783_().m_128451_(TAG_CURRENT_ROTATION_POSITION);
    }

    private void setCurrentRotationPosition(ItemStack stack, int position) {
        stack.m_41784_().m_128405_(TAG_CURRENT_ROTATION_POSITION, position);
    }

    public Heiseisword() {
        super(new Tier(){

            public int m_6609_() {
                return 1000;
            }

            public float m_6624_() {
                return 3.0f;
            }

            public float m_6631_() {
                return 33.0f;
            }

            public int m_6604_() {
                return 5;
            }

            public int m_6601_() {
                return 3;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_151265_();
            }
        }, 3, 2.4f, new Item.Properties());
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BlockEntityWithoutLevelRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new HeiseiswordRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "rotation", 20, state -> PlayState.STOP).triggerableAnim("pos1", ROTATE_POSITION_1).triggerableAnim("pos2", ROTATE_POSITION_2).triggerableAnim("pos3", ROTATE_POSITION_3).triggerableAnim("pos4", ROTATE_POSITION_4)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "ultimate", 20, state -> PlayState.STOP).triggerableAnim("ultimate_time_break", ULTIMATE_TIME_BREAK_ANIM)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "den_o_sword", 20, state -> PlayState.STOP).triggerableAnim("sword_idle", SWORD_FORM_ANIM)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "den_o_fishing_rod", 20, state -> PlayState.STOP).triggerableAnim("fishing_rod_idle", FISHING_ROD_FORM_ANIM)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "den_o_ax", 20, state -> PlayState.STOP).triggerableAnim("ax_idle", AX_FORM_ANIM)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "den_o_gun", 20, state -> PlayState.STOP).triggerableAnim("gun_idle", GUN_FORM_ANIM)});
    }

    public String getDenOWeaponType(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        return stack.m_41783_().m_128461_(TAG_DEN_O_WEAPON_TYPE);
    }

    public void setDenOWeaponType(ItemStack stack, String weaponType) {
        stack.m_41784_().m_128359_(TAG_DEN_O_WEAPON_TYPE, weaponType);
    }

    public boolean hasAttachedEntity(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        return stack.m_41783_().m_128471_(TAG_HAS_ATTACHED_ENTITY);
    }

    public void setHasAttachedEntity(ItemStack stack, boolean hasEntity) {
        stack.m_41784_().m_128379_(TAG_HAS_ATTACHED_ENTITY, hasEntity);
    }

    public void cycleDenOWeaponForm(ItemStack stack) {
        String currentType = this.getDenOWeaponType(stack);
        String[] forms = new String[]{"Sword", "FishingRod", "Ax", "Gun"};
        int currentIndex = 0;
        for (int i = 0; i < forms.length; ++i) {
            if (!forms[i].equals(currentType)) continue;
            currentIndex = i;
            break;
        }
        String nextType = forms[(currentIndex + 1) % forms.length];
        this.setDenOWeaponType(stack, nextType);
        this.setHasAttachedEntity(stack, true);
    }

    public void resetDenOMode(ItemStack stack) {
        this.setDenOWeaponType(stack, "");
        this.setHasAttachedEntity(stack, false);
    }

    public boolean isInDenOMode(ItemStack stack) {
        String type = this.getDenOWeaponType(stack);
        return type != null && !type.isEmpty();
    }

    private boolean isSwordProjectileReady(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        return stack.m_41783_().m_128471_(TAG_SWORD_PROJECTILE_READY);
    }

    private void setSwordProjectileReady(ItemStack stack, boolean ready) {
        stack.m_41784_().m_128379_(TAG_SWORD_PROJECTILE_READY, ready);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            return this.toggleFinishTimeMode(level, player, stack);
        }
        String selectedRider = this.getSelectedRider(stack);
        if (selectedRider != null && selectedRider.equals("DenO")) {
            String weaponType = this.getDenOWeaponType(stack);
            if ("Sword".equals(weaponType)) {
                if (this.isSwordProjectileReady(stack)) {
                    if (!level.f_46443_) {
                        this.spawnDenOTrainEntity(level, player, stack);
                        this.setSwordProjectileReady(stack, false);
                    }
                    player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.2f);
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                this.setSwordProjectileReady(stack, true);
                player.m_5661_((Component)Component.m_237113_((String)"\u5251\u5df2\u51c6\u5907\u5c31\u7eea\uff0c\u518d\u6b21\u53f3\u952e\u53d1\u5c04"), true);
                if (level.f_46443_) {
                    for (int i = 0; i < 8; ++i) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, player.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * 0.8, player.m_20186_() + 1.2 + (level.f_46441_.m_188500_() - 0.5) * 0.5, player.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * 0.8, 0.0, 0.02, 0.0);
                    }
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            this.cycleDenOWeaponForm(stack);
            player.m_5661_((Component)Component.m_237113_((String)("\u5207\u6362\u5230\u7535\u738b\u6b66\u5668\u5f62\u6001: " + this.getDenOWeaponType(stack))), true);
            if (level.f_46443_) {
                for (int i = 0; i < 5; ++i) {
                    double offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.5;
                    double offsetY = (level.f_46441_.m_188500_() - 0.5) * 0.5;
                    double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.5;
                    SimpleParticleType type = switch (this.getDenOWeaponType(stack)) {
                        case "Sword" -> ParticleTypes.f_123744_;
                        case "FishingRod" -> ParticleTypes.f_123803_;
                        case "Ax" -> ParticleTypes.f_123756_;
                        case "Gun" -> ParticleTypes.f_123796_;
                        default -> ParticleTypes.f_175831_;
                    };
                    level.m_7106_((ParticleOptions)type, player.m_20185_() + offsetX, player.m_20186_() + 1.0 + offsetY, player.m_20189_() + offsetZ, 0.0, 0.05, 0.0);
                }
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    private long getLastRiderSelectionTime(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0L;
        }
        return stack.m_41783_().m_128454_(TAG_LAST_RIDER_SELECTION_TIME);
    }

    private void setLastRiderSelectionTime(ItemStack stack, long time) {
        stack.m_41784_().m_128356_(TAG_LAST_RIDER_SELECTION_TIME, time);
    }

    private boolean isRiderSelectionOnCooldown(ItemStack stack, Level level) {
        long lastSelectionTime = this.getLastRiderSelectionTime(stack);
        long currentTime = level.m_46467_();
        return currentTime - lastSelectionTime < 15L;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (isSelected && entity instanceof Player) {
            Player player = (Player)entity;
            if (KeyBinding.OPEN_LOCKSEED.m_90857_() && !this.isRiderSelectionOnCooldown(stack, level) && level.f_46443_) {
                NetworkHandler.INSTANCE.sendToServer((Object)new HeiseiswordRiderSelectionPacket());
                this.setLastRiderSelectionTime(stack, level.m_46467_());
            }
        }
        super.m_6883_(stack, level, entity, slotId, isSelected);
    }

    public static void handleRiderSelectionOnServer(ServerPlayer player, ItemStack stack) {
        Heiseisword heiseisword;
        Item item = stack.m_41720_();
        if (item instanceof Heiseisword && !(heiseisword = (Heiseisword)item).isRiderSelectionOnCooldown(stack, player.m_9236_())) {
            heiseisword.handleRiderSelectionInternal((Player)player, stack);
            heiseisword.setLastRiderSelectionTime(stack, player.m_9236_().m_46467_());
        }
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return super.canContinueUsing(oldStack, newStack);
    }

    private void handleRiderSelectionInternal(Player player, ItemStack stack) {
        if (this.isFinishTimeMode(stack)) {
            this.handleFinishTimeModeSelection(player, stack);
        } else {
            this.handleNormalModeSelection(player, stack);
        }
    }

    private void handleNormalModeSelection(Player player, ItemStack stack) {
        List<String> riderOrder = HeiseiRiderEffectManager.getRiderOrder();
        String currentSelectedRider = this.getSelectedRider(stack);
        if (currentSelectedRider == null || currentSelectedRider.isEmpty()) {
            HeiseiRiderEffectManager.playRiderTimeSound(player.m_9236_(), (LivingEntity)player);
            this.setSelectedRider(stack, riderOrder.get(0));
            this.setCurrentRotationPosition(stack, 0);
        } else {
            int currentIndex = riderOrder.indexOf(currentSelectedRider);
            int nextIndex = (currentIndex + 1) % riderOrder.size();
            this.setSelectedRider(stack, riderOrder.get(nextIndex));
            int currentPosition = this.getCurrentRotationPosition(stack);
            this.setCurrentRotationPosition(stack, (currentPosition + 1) % 4);
        }
        HeiseiRiderEffectManager.playSelectionSound(player.m_9236_(), (LivingEntity)player, this.getSelectedRider(stack));
        this.triggerRotationAnimation(player.m_9236_(), player, stack);
    }

    private void handleFinishTimeModeSelection(Player player, ItemStack stack) {
        List<String> riderOrder = HeiseiRiderEffectManager.getRiderOrder();
        if (KeyBinding.CHANGE_KEY.m_90857_() && !this.isUltimateMode(stack)) {
            this.setUltimateMode(stack, true);
            HeiseiRiderEffectManager.playUltimateActivationSound(player.m_9236_(), (LivingEntity)player);
            this.triggerUltimateAnimation(player.m_9236_(), player, stack);
            Heiseisword.setScrambleRiders(stack, new ArrayList<String>(riderOrder));
            stack.m_41784_().m_128379_("isXKeyUltimateReady", true);
            return;
        }
        List<String> currentScrambleRiders = this.getScrambleRiders(stack);
        if (currentScrambleRiders.isEmpty()) {
            String newRider = riderOrder.get(0);
            ArrayList<String> updatedRiders = new ArrayList<String>();
            updatedRiders.add(newRider);
            Heiseisword.setScrambleRiders(stack, updatedRiders);
            HeiseiRiderEffectManager.playSelectionSound(player.m_9236_(), (LivingEntity)player, newRider);
            this.setCurrentRotationPosition(stack, 0);
            if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_5661_((Component)Component.m_237113_((String)("\u9009\u62e9\u4e86\u7b2c\u4e00\u4e2a\u9a91\u58eb: " + newRider)), true);
            }
        } else {
            String lastRider = currentScrambleRiders.get(currentScrambleRiders.size() - 1);
            int currentIndex = riderOrder.indexOf(lastRider);
            if (currentIndex == -1) {
                currentIndex = 0;
            }
            int nextIndex = (currentIndex + 1) % riderOrder.size();
            while (nextIndex != currentIndex) {
                String candidate = riderOrder.get(nextIndex);
                if (!currentScrambleRiders.contains(candidate)) {
                    ArrayList<String> updatedRiders = new ArrayList<String>(currentScrambleRiders);
                    updatedRiders.add(candidate);
                    Heiseisword.setScrambleRiders(stack, updatedRiders);
                    HeiseiRiderEffectManager.playSelectionSound(player.m_9236_(), (LivingEntity)player, candidate);
                    this.setCurrentRotationPosition(stack, (this.getCurrentRotationPosition(stack) + 1) % 4);
                    if (player.m_9236_().f_46443_ || !(player instanceof ServerPlayer)) break;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_5661_((Component)Component.m_237113_((String)("\u9009\u62e9\u4e86\u9a91\u58eb: " + candidate)), true);
                    break;
                }
                nextIndex = (nextIndex + 1) % riderOrder.size();
            }
        }
        if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_5661_((Component)Component.m_237113_((String)("\u5f53\u524d\u5df2\u9009\u9a91\u58eb: " + String.valueOf(this.getScrambleRiders(stack)))), true);
        }
        this.triggerRotationAnimation(player.m_9236_(), player, stack);
    }

    private InteractionResultHolder<ItemStack> toggleFinishTimeMode(Level level, Player player, ItemStack stack) {
        boolean newMode;
        boolean currentMode = this.isFinishTimeMode(stack);
        boolean bl = newMode = !currentMode;
        if (newMode && this.isFinishTimeOnCooldown(stack, level)) {
            long remainingTicks = 300L - (level.m_46467_() - this.getLastFinishTimeEnter(stack));
            int remainingSeconds = (int)remainingTicks / 20;
            if (!level.f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_5661_((Component)Component.m_237113_((String)("\u5fc5\u6740\u6a21\u5f0f\u51b7\u5374\u4e2d\uff0c\u5269\u4f59 " + remainingSeconds + " \u79d2")), true);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        this.setFinishTimeMode(stack, newMode);
        if (newMode) {
            this.setLastFinishTimeEnter(stack, level.m_46467_());
            HeiseiRiderEffectManager.playFinishTimeSound(level, (LivingEntity)player);
            Heiseisword.setScrambleRiders(stack, new ArrayList<String>());
            this.setRotationCount(stack, 0);
            String savedRider = this.getSelectedRider(stack);
            this.setSelectedRider(stack, null);
            this.setUltimateMode(stack, false);
            this.setCurrentRotationPosition(stack, 0);
            this.setSelectedRider(stack, savedRider);
        } else {
            Heiseisword.setScrambleRiders(stack, new ArrayList<String>());
            this.setSelectedRider(stack, null);
            this.setCurrentRotationPosition(stack, 0);
            this.setUltimateMode(stack, false);
            this.setRotationCount(stack, 0);
            stack.m_41784_().m_128473_("isXKeyUltimateReady");
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private InteractionResultHolder<ItemStack> handleNormalMode(Level level, Player player, InteractionHand hand, ItemStack stack) {
        List<String> riderOrder = HeiseiRiderEffectManager.getRiderOrder();
        String currentSelectedRider = this.getSelectedRider(stack);
        if (currentSelectedRider == null || currentSelectedRider.isEmpty()) {
            HeiseiRiderEffectManager.playRiderTimeSound(level, (LivingEntity)player);
            this.setSelectedRider(stack, riderOrder.get(0));
            this.setCurrentRotationPosition(stack, 0);
        } else {
            int currentIndex = riderOrder.indexOf(currentSelectedRider);
            int nextIndex = (currentIndex + 1) % riderOrder.size();
            this.setSelectedRider(stack, riderOrder.get(nextIndex));
            int currentPosition = this.getCurrentRotationPosition(stack);
            this.setCurrentRotationPosition(stack, (currentPosition + 1) % 4);
        }
        HeiseiRiderEffectManager.playSelectionSound(level, (LivingEntity)player, this.getSelectedRider(stack));
        this.triggerRotationAnimation(level, player, stack);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private InteractionResultHolder<ItemStack> handleFinishTimeMode(Level level, Player player, InteractionHand hand, ItemStack stack) {
        List<String> riderOrder = HeiseiRiderEffectManager.getRiderOrder();
        if (KeyBinding.CHANGE_KEY.m_90857_() && !this.isUltimateMode(stack)) {
            this.setUltimateMode(stack, true);
            HeiseiRiderEffectManager.playUltimateActivationSound(level, (LivingEntity)player);
            this.triggerUltimateAnimation(level, player, stack);
            Heiseisword.setScrambleRiders(stack, new ArrayList<String>(riderOrder));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        List<String> currentScrambleRiders = this.getScrambleRiders(stack);
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_5661_((Component)Component.m_237113_((String)("\u5f53\u524d\u5df2\u9009\u9a91\u58eb: " + String.valueOf(currentScrambleRiders))), true);
        }
        if (currentScrambleRiders.isEmpty()) {
            String newRider = riderOrder.get(0);
            ArrayList<String> updatedRiders = new ArrayList<String>();
            updatedRiders.add(newRider);
            Heiseisword.setScrambleRiders(stack, updatedRiders);
            HeiseiRiderEffectManager.playSelectionSound(level, (LivingEntity)player, newRider);
            this.setCurrentRotationPosition(stack, 0);
            if (!level.f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_5661_((Component)Component.m_237113_((String)("\u9009\u62e9\u4e86\u7b2c\u4e00\u4e2a\u9a91\u58eb: " + newRider)), true);
            }
        } else {
            String lastRider = currentScrambleRiders.get(currentScrambleRiders.size() - 1);
            int currentIndex = riderOrder.indexOf(lastRider);
            if (currentIndex == -1) {
                currentIndex = 0;
                if (!level.f_46443_ && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_5661_((Component)Component.m_237113_((String)("\u8b66\u544a: \u5f53\u524d\u9a91\u58eb" + lastRider + "\u4e0d\u5728\u987a\u5e8f\u5217\u8868\u4e2d\uff0c\u4ece0\u5f00\u59cb\u67e5\u627e")), true);
                }
            }
            int nextIndex = (currentIndex + 1) % riderOrder.size();
            while (nextIndex != currentIndex) {
                String candidate = riderOrder.get(nextIndex);
                if (!currentScrambleRiders.contains(candidate)) {
                    ArrayList<String> updatedRiders = new ArrayList<String>(currentScrambleRiders);
                    updatedRiders.add(candidate);
                    Heiseisword.setScrambleRiders(stack, updatedRiders);
                    HeiseiRiderEffectManager.playSelectionSound(level, (LivingEntity)player, candidate);
                    this.setCurrentRotationPosition(stack, (this.getCurrentRotationPosition(stack) + 1) % 4);
                    if (level.f_46443_ || !(player instanceof ServerPlayer)) break;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_5661_((Component)Component.m_237113_((String)("\u9009\u62e9\u4e86\u9a91\u58eb: " + candidate)), true);
                    break;
                }
                nextIndex = (nextIndex + 1) % riderOrder.size();
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private void triggerRotationAnimation(Level level, Player player, ItemStack stack) {
        int position = this.getCurrentRotationPosition(stack);
        String animationName = "pos" + (position + 1);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "rotation", animationName);
        }
    }

    private void triggerUltimateAnimation(Level level, Player player, ItemStack stack) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "ultimate", "ultimate_time_break");
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        LivingEntity livingEntity;
        float actualDamage;
        boolean result;
        String selectedRider;
        float damageDealt = 0.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity2 = (LivingEntity)entity;
            if (!player.m_9236_().f_46443_) {
                damageDealt = livingEntity2.m_21223_();
            }
        }
        if ((selectedRider = this.getSelectedRider(stack)) != null && selectedRider.equals("DenO") && this.isInDenOMode(stack) && entity instanceof LivingEntity) {
            LivingEntity livingEntity3 = (LivingEntity)entity;
            if (player.m_9236_().f_46441_.m_188501_() <= 0.25f) {
                String weaponType;
                switch (weaponType = this.getDenOWeaponType(stack)) {
                    case "Sword": {
                        float baseDamage = 8.0f;
                        livingEntity3.m_6469_(player.m_9236_().m_269111_().m_269075_(player), baseDamage * 2.0f);
                        if (!player.m_9236_().f_46443_ && livingEntity3.m_6084_()) {
                            livingEntity3.m_6469_(player.m_9236_().m_269111_().m_269075_(player), baseDamage * 2.0f);
                        }
                        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.2f);
                        break;
                    }
                    case "FishingRod": {
                        livingEntity3.m_6469_(player.m_9236_().m_269111_().m_269075_(player), 6.0f);
                        if (!player.m_9236_().f_46443_) {
                            Vec3 pullDir = player.m_20182_().m_82546_(livingEntity3.m_20182_()).m_82541_();
                            livingEntity3.m_20256_(livingEntity3.m_20184_().m_82549_(pullDir.m_82490_(0.8)));
                            BlockPos targetPos = livingEntity3.m_20183_();
                            block24: for (int x = -2; x <= 2; ++x) {
                                for (int z = -2; z <= 2; ++z) {
                                    BlockPos checkPos = targetPos.m_7918_(x, 0, z);
                                    Block block = player.m_9236_().m_8055_(checkPos).m_60734_();
                                    if (!(block instanceof LiquidBlock)) continue;
                                    if (!(player.m_9236_().f_46441_.m_188501_() <= 0.3f)) continue block24;
                                    ItemStack fishItem = new ItemStack((ItemLike)Items.f_42526_);
                                    player.m_5552_(fishItem, 0.5f);
                                    continue block24;
                                }
                            }
                        }
                        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11939_, SoundSource.PLAYERS, 1.0f, 0.9f);
                        break;
                    }
                    case "Ax": {
                        float axeDamage = 18.0f;
                        livingEntity3.m_6469_(player.m_9236_().m_269111_().m_269075_(player), axeDamage);
                        livingEntity3.m_20254_(2);
                        if (!player.m_9236_().f_46443_) {
                            player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 100, 2, false, true));
                        }
                        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11688_, SoundSource.PLAYERS, 1.0f, 1.1f);
                        break;
                    }
                    case "Gun": {
                        if (!player.m_9236_().f_46443_) {
                            float gunDamage = 10.0f;
                            livingEntity3.m_6469_(player.m_9236_().m_269111_().m_269075_(player), gunDamage);
                            Vec3 lookDir = player.m_20154_().m_82541_();
                            livingEntity3.m_20256_(livingEntity3.m_20184_().m_82549_(lookDir.m_82490_(1.0)));
                        }
                        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, 0.8f);
                    }
                }
                if (player.m_9236_().f_46443_) {
                    for (int i = 0; i < 5; ++i) {
                        SimpleParticleType particleType = switch (this.getDenOWeaponType(stack)) {
                            case "Sword" -> ParticleTypes.f_123744_;
                            case "FishingRod" -> ParticleTypes.f_123803_;
                            case "Ax" -> ParticleTypes.f_123756_;
                            case "Gun" -> ParticleTypes.f_123796_;
                            default -> ParticleTypes.f_123766_;
                        };
                        player.m_9236_().m_7106_((ParticleOptions)particleType, livingEntity3.m_20185_() + (player.m_9236_().f_46441_.m_188500_() - 0.5) * 2.0, livingEntity3.m_20186_() + player.m_9236_().f_46441_.m_188500_() * (double)livingEntity3.m_20206_(), livingEntity3.m_20189_() + (player.m_9236_().f_46441_.m_188500_() - 0.5) * 2.0, player.m_9236_().f_46441_.m_188500_() - 0.5, player.m_9236_().f_46441_.m_188500_() * 0.5, player.m_9236_().f_46441_.m_188500_() - 0.5);
                    }
                }
                return true;
            }
        }
        if (!player.m_9236_().f_46443_) {
            boolean isXKeyUltimateReady = stack.m_41784_().m_128471_("isXKeyUltimateReady");
            if (isXKeyUltimateReady) {
                this.executeXKeyUltimateAttack(player.m_9236_(), player, stack);
                stack.m_41784_().m_128473_("isXKeyUltimateReady");
                if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_6084_()) {
                    List<String> riders = this.getScrambleRiders(stack);
                    HeiseiRiderEffectManager.playUltimateFinishSoundSequence(player.m_9236_(), (LivingEntity)player, riders);
                }
                result = true;
            } else if (this.isFinishTimeMode(stack)) {
                result = this.handleFinishTimeAttack(player, stack);
                if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_6084_()) {
                    if (this.isUltimateMode(stack)) {
                        List<String> riders = this.getScrambleRiders(stack);
                        HeiseiRiderEffectManager.playUltimateFinishSoundSequence(player.m_9236_(), (LivingEntity)player, riders);
                    } else {
                        List<String> riders = this.getScrambleRiders(stack);
                        ArrayList<RiderSounds.DelayedSound> sounds = new ArrayList<RiderSounds.DelayedSound>();
                        sounds.add(new RiderSounds.DelayedSound(RiderSounds.HEY, 0));
                        int delay = 20;
                        for (String riderName : riders) {
                            SoundEvent nameSound = HeiseiRiderEffectManager.getRiderNameSound(riderName);
                            if (nameSound == null) continue;
                            sounds.add(new RiderSounds.DelayedSound(nameSound, delay));
                            delay += 10;
                        }
                        sounds.add(new RiderSounds.DelayedSound(RiderSounds.SCRAMBLE_TIME_BREAK, delay + 20));
                        RiderSounds.playDelayedSoundSequence(player.m_9236_(), player, sounds);
                    }
                }
            } else {
                String rider = this.getSelectedRider(stack);
                if (rider != null && !rider.isEmpty()) {
                    LivingEntity livingEntity4;
                    result = this.handleNormalAttack(player, stack);
                    if (entity instanceof LivingEntity && !(livingEntity4 = (LivingEntity)entity).m_6084_()) {
                        if ("Drive".equals(rider)) {
                            RiderSounds.playSound(player.m_9236_(), player, RiderSounds.NAME_DRIVE);
                            RiderSounds.playDelayedSound(player.m_9236_(), player, RiderSounds.DUAL_TIME_BREAK, 40);
                        } else {
                            SoundEvent nameSound = HeiseiRiderEffectManager.getRiderNameSound(rider);
                            if (nameSound != null) {
                                RiderSounds.playSound(player.m_9236_(), player, nameSound);
                                RiderSounds.playDelayedSound(player.m_9236_(), player, RiderSounds.DUAL_TIME_BREAK, 40);
                            }
                        }
                    }
                } else {
                    result = super.onLeftClickEntity(stack, player, entity);
                }
            }
        } else {
            result = super.onLeftClickEntity(stack, player, entity);
        }
        if (!player.m_9236_().f_46443_ && entity instanceof LivingEntity && (actualDamage = damageDealt - (livingEntity = (LivingEntity)entity).m_21223_()) > 0.0f) {
            HeiseiswordEnergyManager.recoverEnergyByDamage(player, actualDamage);
        }
        return result;
    }

    private boolean handleNormalAttack(Player player, ItemStack stack) {
        if (this.isAttackOnCooldown(stack, player.m_9236_())) {
            return false;
        }
        String rider = this.getSelectedRider(stack);
        HeiseiRiderEffect effect = HeiseiRiderEffectManager.getRiderEffect(rider);
        if (effect != null) {
            double energyCost = HeiseiRiderEffectManager.getRiderEnergyCost(rider) * 2.0;
            if (!HeiseiswordEnergyManager.canUseEnergy(player, energyCost) || !HeiseiswordEnergyManager.consumeEnergy(player, energyCost)) {
                return false;
            }
            effect.executeSpecialAttack(player.m_9236_(), (LivingEntity)player, player.m_20154_());
            this.setLastAttackTime(stack, player.m_9236_().m_46467_());
            return true;
        }
        return false;
    }

    private boolean handleFinishTimeAttack(Player player, ItemStack stack) {
        if (this.isAttackOnCooldown(stack, player.m_9236_())) {
            return false;
        }
        List<String> riders = this.getScrambleRiders(stack);
        if (riders.isEmpty()) {
            if (!player.m_9236_().f_46443_) {
                player.m_213846_((Component)Component.m_237115_((String)"message.kamen_rider_weapon_craft.no_riders_selected"));
            }
            return false;
        }
        if (this.isUltimateMode(stack)) {
            this.executeUltimateTimeBreak(player.m_9236_(), player, stack);
        } else {
            this.executeScrambleTimeBreak(player.m_9236_(), player, stack);
        }
        this.setUltimateMode(stack, false);
        this.setRotationCount(stack, 0);
        this.setLastAttackTime(stack, player.m_9236_().m_46467_());
        return true;
    }

    private void executeScrambleTimeBreak(Level level, Player player, ItemStack stack) {
        List<String> riders = this.getScrambleRiders(stack);
        int riderCount = riders.size();
        double avgEnergyCost = 20.0;
        if (!riders.isEmpty()) {
            double sumCost = 0.0;
            for (String rider : riders) {
                sumCost += HeiseiRiderEffectManager.getRiderEnergyCost(rider);
            }
            avgEnergyCost = sumCost / (double)riders.size();
        }
        double totalEnergyCost = avgEnergyCost * (double)riders.size() * 1.5;
        if (!HeiseiswordEnergyManager.canUseEnergy(player, totalEnergyCost = Math.min(totalEnergyCost, 100.0)) || !HeiseiswordEnergyManager.consumeEnergy(player, totalEnergyCost)) {
            return;
        }
        for (int i = 0; i < riderCount; ++i) {
            String rider;
            rider = riders.get(i);
            HeiseiRiderEffect effect = HeiseiRiderEffectManager.getRiderEffect(rider);
            if (effect == null) continue;
            effect.executeSpecialAttack(level, (LivingEntity)player, player.m_20154_());
        }
    }

    private void executeXKeyUltimateAttack(Level level, Player player, ItemStack stack) {
        HeiseiRiderEffect effect;
        List<String> riders = this.getScrambleRiders(stack);
        double avgEnergyCost = 20.0;
        if (!riders.isEmpty()) {
            double sumCost = 0.0;
            for (String rider : riders) {
                effect = HeiseiRiderEffectManager.getRiderEffect(rider);
                if (effect == null) continue;
                sumCost += effect.getEnergyCost();
            }
            avgEnergyCost = sumCost / (double)riders.size();
        }
        double totalEnergyCost = avgEnergyCost * (double)riders.size() * 1.8;
        if (!HeiseiswordEnergyManager.canUseEnergy(player, totalEnergyCost = Math.min(totalEnergyCost, 100.0)) || !HeiseiswordEnergyManager.consumeEnergy(player, totalEnergyCost)) {
            return;
        }
        for (int i = 0; i < riders.size(); ++i) {
            String rider;
            rider = riders.get(i);
            effect = HeiseiRiderEffectManager.getRiderEffect(rider);
            if (effect == null) continue;
            effect.executeSpecialAttack(level, (LivingEntity)player, player.m_20154_());
        }
        this.executeUltimateSpecialEffects(level, player);
    }

    private void executeUltimateTimeBreak(Level level, Player player, ItemStack stack) {
        HeiseiRiderEffect effect;
        List<String> riders = this.getScrambleRiders(stack);
        double avgEnergyCost = 20.0;
        if (!riders.isEmpty()) {
            double sumCost = 0.0;
            for (String rider : riders) {
                effect = HeiseiRiderEffectManager.getRiderEffect(rider);
                if (effect == null) continue;
                sumCost += effect.getEnergyCost();
            }
            avgEnergyCost = sumCost / (double)riders.size();
        }
        double totalEnergyCost = avgEnergyCost * (double)riders.size() * 0.9;
        if (!HeiseiswordEnergyManager.canUseEnergy(player, totalEnergyCost = Math.min(totalEnergyCost, 90.0)) || !HeiseiswordEnergyManager.consumeEnergy(player, totalEnergyCost)) {
            return;
        }
        for (int i = 0; i < riders.size(); ++i) {
            String rider;
            rider = riders.get(i);
            effect = HeiseiRiderEffectManager.getRiderEffect(rider);
            if (effect == null) continue;
            effect.executeSpecialAttack(level, (LivingEntity)player, player.m_20154_());
        }
        this.executeUltimateSpecialEffects(level, player);
        this.triggerUltimateAnimation(level, player, stack);
    }

    private void executeUltimateSpecialEffects(Level level, Player player) {
        if (!level.f_46443_) {
            level.m_254849_((Entity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), 8.0f, Level.ExplosionInteraction.MOB);
            Vec3 playerPos = player.m_20182_();
            double range = 15.0;
            level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(range), entity -> entity != player).forEach(entity -> {
                entity.m_6469_(level.m_269111_().m_269075_(player), 200.0f);
                entity.m_20256_(entity.m_20184_().m_82549_(entity.m_20182_().m_82546_(playerPos).m_82541_().m_82490_(2.0)));
            });
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity shooter, int ticksRemaining) {
        Player player;
        block10: {
            block9: {
                if (!(shooter instanceof Player)) break block9;
                player = (Player)shooter;
                if (!level.f_46443_) break block10;
            }
            return;
        }
        String selectedRider = this.getSelectedRider(stack);
        String weaponType = this.getDenOWeaponType(stack);
        if (selectedRider != null && selectedRider.equals("DenO") && "Sword".equals(weaponType) && this.isSwordProjectileReady(stack)) {
            this.spawnDenOTrainEntity(level, player, stack);
            this.setSwordProjectileReady(stack, false);
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.2f);
            stack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(InteractionHand.MAIN_HAND));
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        float chargeTime = (float)(this.m_8105_(stack) - ticksRemaining) / 20.0f;
        if ((chargeTime = (chargeTime * chargeTime + chargeTime * 2.0f) / 3.0f) > 1.0f) {
            chargeTime = 1.0f;
        }
        if (this.isFinishTimeMode(stack)) {
            if (this.isUltimateMode(stack)) {
                this.executeUltimateRangedAttack(player, stack, chargeTime);
            } else {
                this.executeScrambleRangedAttack(player, stack, chargeTime);
            }
        } else {
            this.executeNormalRangedAttack(player, stack, chargeTime);
        }
        this.triggerRangedAttackAnimation(level, player, stack);
        stack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(InteractionHand.MAIN_HAND));
    }

    private void spawnDenOTrainEntity(Level level, Player player, ItemStack stack) {
        if (level.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (DenOTrainEntity existingEntity : serverLevel.m_6443_(DenOTrainEntity.class, player.m_20191_().m_82400_(50.0), e -> e.getOwner() == player && "Sword".equals(e.getWeaponType()))) {
            existingEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        Vec3 lookVec = player.m_20154_().m_82541_().m_82490_(1.5);
        DenOTrainEntity.spawn(serverLevel, (LivingEntity)player, lookVec, 16.0f, this.getDenOWeaponType(stack));
        this.triggerAnimationForPlayer(player, stack);
    }

    private void triggerRangedAttackAnimation(Level level, Player player, ItemStack stack) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "rotation", "pos1");
        }
    }

    public void triggerAnimationForPlayer(Player player, ItemStack stack) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "rotation", "sword_attack");
        }
    }

    private void executeNormalRangedAttack(Player player, ItemStack stack, float chargeTime) {
        HeiseiRiderEffect effect;
        String rider = this.getSelectedRider(stack);
        if (rider != null && !rider.isEmpty() && (effect = HeiseiRiderEffectManager.getRiderEffect(rider)) != null) {
            double energyCost = HeiseiRiderEffectManager.getRiderEnergyCost(rider) * (0.8 + (double)chargeTime * 0.7);
            if (!HeiseiswordEnergyManager.canUseEnergy(player, energyCost = Math.min(energyCost, 40.0)) || !HeiseiswordEnergyManager.consumeEnergy(player, energyCost)) {
                return;
            }
            SoundEvent nameSound = HeiseiRiderEffectManager.getRiderNameSound(rider);
            if (nameSound != null) {
                RiderSounds.playAttackSound(player.m_9236_(), player, nameSound);
            }
            Vec3 lookAngle = player.m_20154_().m_82490_((double)chargeTime * 2.0);
            effect.executeSpecialAttack(player.m_9236_(), (LivingEntity)player, lookAngle);
            this.setLastAttackTime(stack, player.m_9236_().m_46467_());
        }
    }

    private void executeScrambleRangedAttack(Player player, ItemStack stack, float chargeTime) {
        List<String> riders = this.getScrambleRiders(stack);
        if (!riders.isEmpty()) {
            double totalEnergyCost = 0.0;
            for (String rider : riders) {
                HeiseiRiderEffect effect = HeiseiRiderEffectManager.getRiderEffect(rider);
                if (effect == null) continue;
                totalEnergyCost += effect.getEnergyCost();
            }
            totalEnergyCost *= 0.8 + (double)chargeTime * 0.7;
            if (!HeiseiswordEnergyManager.canUseEnergy(player, totalEnergyCost = Math.min(totalEnergyCost, 100.0)) || !HeiseiswordEnergyManager.consumeEnergy(player, totalEnergyCost)) {
                return;
            }
            RiderSounds.playSound(player.m_9236_(), player, RiderSounds.SCRAMBLE_TIME_BREAK);
            Vec3 lookAngle = player.m_20154_().m_82490_((double)chargeTime * 1.5);
            for (String rider : riders) {
                HeiseiRiderEffect effect = HeiseiRiderEffectManager.getRiderEffect(rider);
                if (effect == null) continue;
                effect.executeSpecialAttack(player.m_9236_(), (LivingEntity)player, lookAngle);
            }
            this.setLastAttackTime(stack, player.m_9236_().m_46467_());
        }
    }

    private void executeUltimateRangedAttack(Player player, ItemStack stack, float chargeTime) {
        List<String> riders = this.getScrambleRiders(stack);
        if (!riders.isEmpty()) {
            double totalEnergyCost = 0.0;
            for (String rider : riders) {
                HeiseiRiderEffect effect = HeiseiRiderEffectManager.getRiderEffect(rider);
                if (effect == null) continue;
                totalEnergyCost += effect.getEnergyCost();
            }
            totalEnergyCost *= 0.9 + (double)chargeTime * 0.8;
            if (!HeiseiswordEnergyManager.canUseEnergy(player, totalEnergyCost = Math.min(totalEnergyCost, 100.0)) || !HeiseiswordEnergyManager.consumeEnergy(player, totalEnergyCost)) {
                return;
            }
            RiderSounds.playSound(player.m_9236_(), player, RiderSounds.ULTIMATE_TIME_BREAK);
            Vec3 lookAngle = player.m_20154_().m_82490_((double)chargeTime * 3.0);
            for (String rider : riders) {
                HeiseiRiderEffect effect = HeiseiRiderEffectManager.getRiderEffect(rider);
                if (effect == null) continue;
                effect.executeSpecialAttack(player.m_9236_(), (LivingEntity)player, lookAngle);
            }
            this.executeUltimateSpecialEffects(player.m_9236_(), player);
            this.setLastAttackTime(stack, player.m_9236_().m_46467_());
        }
    }

    private boolean hasRiderWatchInOffhand(Player player) {
        ItemStack offhandItem = player.m_21206_();
        return true;
    }

    public void installRiderWatch(ItemStack watchStack) {
    }

    public void uninstallRiderWatch() {
    }

    public boolean hasRiderWatchInstalled() {
        return false;
    }

    public String getSelectedRider() {
        return null;
    }

    public List<String> getScrambleRiders() {
        return new ArrayList<String>();
    }

    public int getCurrentRotationPosition() {
        return 0;
    }

    public boolean isInFinishTimeMode() {
        return false;
    }

    public boolean isInUltimateMode() {
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static String getSelectedRiderStatic(ItemStack stack) {
        if (!stack.m_41782_()) {
            return "";
        }
        return stack.m_41783_().m_128461_(TAG_SELECTED_RIDER);
    }

    public static void setSelectedRiderStatic(ItemStack stack, String riderName) {
        stack.m_41784_().m_128359_(TAG_SELECTED_RIDER, riderName != null ? riderName : "");
    }

    public static List<String> getScrambleRidersStatic(ItemStack stack) {
        ArrayList<String> riders = new ArrayList<String>();
        if (!stack.m_41782_()) {
            return riders;
        }
        CompoundTag tag = stack.m_41783_();
        if (!tag.m_128441_("scrambleRiders_size")) {
            return riders;
        }
        int size = tag.m_128451_("scrambleRiders_size");
        for (int i = 0; i < size; ++i) {
            if (!tag.m_128441_("scrambleRiders_" + i)) continue;
            riders.add(tag.m_128461_("scrambleRiders_" + i));
        }
        return riders;
    }

    public static void setScrambleRidersStatic(ItemStack stack, List<String> riders) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("scrambleRiders_size")) {
            int oldSize = tag.m_128451_("scrambleRiders_size");
            for (int i = 0; i < oldSize; ++i) {
                tag.m_128473_("scrambleRiders_" + i);
            }
        }
        tag.m_128405_("scrambleRiders_size", riders.size());
        for (int i = 0; i < riders.size(); ++i) {
            tag.m_128359_("scrambleRiders_" + i, riders.get(i));
        }
    }

    public static boolean isFinishTimeModeStatic(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        return stack.m_41783_().m_128471_(TAG_IS_FINISH_TIME_MODE);
    }

    public static void setFinishTimeModeStatic(ItemStack stack, boolean mode) {
        stack.m_41784_().m_128379_(TAG_IS_FINISH_TIME_MODE, mode);
    }

    public static boolean isUltimateModeStatic(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        return stack.m_41783_().m_128471_(TAG_IS_ULTIMATE_MODE);
    }

    public static void setUltimateModeStatic(ItemStack stack, boolean mode) {
        stack.m_41784_().m_128379_(TAG_IS_ULTIMATE_MODE, mode);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        String selectedRider = Heiseisword.getSelectedRiderStatic(stack);
        if (selectedRider != null && !selectedRider.isEmpty()) {
            String displayName = switch (selectedRider) {
                case "Decade" -> "DCD";
                case "W" -> "Double";
                case "Fourze" -> "Fourze";
                case "Faiz" -> "Faiz";
                case "Kabuto" -> "Kabuto";
                case "Hibiki" -> "Hibiki";
                case "DenO" -> "\u7535\u738b";
                case "Agito" -> "Agito";
                case "Kuuga" -> "Kuuga";
                case "Blade" -> "Blade";
                case "Kiva" -> "Kiva";
                case "Ryuki" -> "Ryuki";
                case "Wizard" -> "Wizard";
                case "Ghost" -> "Ghost";
                case "Ex-Aid" -> "Ex-Aid";
                case "Build" -> "Build";
                case "Zi-O" -> "\u65f6\u738b";
                default -> selectedRider;
            };
            tooltip.add((Component)Component.m_237113_((String)("\u5df2\u9009\u62e9: " + displayName)).m_130940_(ChatFormatting.GOLD));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"\u672a\u9009\u62e9\u9a91\u58eb").m_130940_(ChatFormatting.GRAY));
        }
        if (this.isInDenOMode(stack)) {
            String weaponType;
            String displayWeaponType = switch (weaponType = this.getDenOWeaponType(stack)) {
                case "Sword" -> "\u5251\u5f62\u6001";
                case "FishingRod" -> "\u7aff\u5f62\u6001";
                case "Ax" -> "\u65a7\u5f62\u6001";
                case "Gun" -> "\u67aa\u5f62\u6001";
                default -> weaponType;
            };
            tooltip.add((Component)Component.m_237113_((String)("\u7535\u738b\u6a21\u5f0f: " + displayWeaponType)).m_130940_(ChatFormatting.BLUE));
        }
        if (Heiseisword.isFinishTimeModeStatic(stack)) {
            tooltip.add((Component)Component.m_237113_((String)"\u5fc5\u6740\u65f6\u523b\u6a21\u5f0f").m_130940_(ChatFormatting.RED));
            List<String> scrambleRiders = Heiseisword.getScrambleRidersStatic(stack);
            if (!scrambleRiders.isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)("\u5df2\u9009\u62e9 " + scrambleRiders.size() + " \u4f4d\u9a91\u58eb")).m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
            if (Heiseisword.isUltimateModeStatic(stack)) {
                tooltip.add((Component)Component.m_237113_((String)"\u8d85\u5fc5\u6740\u51c6\u5907\u5c31\u7eea\uff01").m_130940_(ChatFormatting.DARK_RED).m_130940_(ChatFormatting.BOLD));
            }
        }
    }
}

