/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom;

import com.xiaoshi2022.kamen_rider_weapon_craft.Item.client.denkamen_sword.denkamen_swordRenderer;
import com.xiaoshi2022.kamen_rider_weapon_craft.entity.line.denliner;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModSounds;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@Mod.EventBusSubscriber(modid="kamen_rider_weapon_craft")
public class denkamen_sword
extends SwordItem
implements GeoItem {
    private static final RawAnimation FROTATION = RawAnimation.begin().thenPlay("frotation");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final String RIDING_DENLINER_TAG = "riding_denliner";
    private static final String FINISHER_COOLDOWN_TAG = "finisher_cooldown";
    private static final int FINISHER_COOLDOWN_TICKS = 600;
    private static final String STANDBY_START_TIME_TAG = "standby_start_time";
    private static final String STANDBY_END_TIME_TAG = "standby_end_time";
    private static final int STANDBY_DURATION_TICKS = 100;

    public denkamen_sword() {
        super(new Tier(){

            public int m_6609_() {
                return 1500;
            }

            public float m_6624_() {
                return -1.0f;
            }

            public float m_6631_() {
                return 30.0f;
            }

            public int m_6604_() {
                return 4;
            }

            public int m_6601_() {
                return 8;
            }

            public Ingredient m_6282_() {
                return Ingredient.m_151265_();
            }
        }, 3, -2.4f, new Item.Properties());
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BlockEntityWithoutLevelRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new denkamen_swordRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 20, state -> {
            if (this.isBlocking(((denkamen_sword)state.getAnimatable()).m_7968_())) {
                return state.setAndContinue(FROTATION);
            }
            return PlayState.STOP;
        }).triggerableAnim("frotation", FROTATION).setSoundKeyframeHandler(state -> {})});
    }

    private boolean isBlocking(ItemStack itemStack) {
        return itemStack != null && itemStack.m_41779_() > 0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isPlayerRidingDenliner(player)) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (this.isFinisherOnCooldown(player)) {
            if (!level.f_46443_) {
                long cooldownStartTime = player.getPersistentData().m_128454_(FINISHER_COOLDOWN_TAG);
                long remainingTicks = 600L - (player.m_9236_().m_46467_() - cooldownStartTime);
                int remainingSeconds = (int)(remainingTicks / 20L);
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u5fc5\u6740\u6280\u51b7\u5374\u4e2d\uff01\u5269\u4f59 " + remainingSeconds + " \u79d2")));
            }
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            denliner train = denliner.create(serverLevel, player);
            this.markPlayerAsRidingDenliner(player);
            serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.DEN_O_LINES.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            long currentTime = serverLevel.m_46467_();
            this.setStandbyStartTime(player, currentTime);
            this.setStandbyEndTime(player, currentTime + 100L);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19090_((Object)itemstack);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return super.onEntitySwing(stack, entity);
        }
        Player player = (Player)entity;
        Level level = player.m_9236_();
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)level)), "controller", "frotation");
        }
        return super.onEntitySwing(stack, entity);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static boolean isDenkamenSword(ItemStack stack) {
        return stack.m_41720_() instanceof denkamen_sword;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            this.clearPlayerStandby(player);
            if (this.isPlayerRidingDenliner(player)) {
                Level level;
                Entity entity2;
                this.clearPlayerRidingDenliner(player);
                for (Entity passenger : player.m_20197_()) {
                    if (!(passenger instanceof denliner)) continue;
                    denliner train = (denliner)passenger;
                    train.onEnemyAttacked();
                    break;
                }
                if ((entity2 = player.m_20202_()) instanceof denliner) {
                    denliner train = (denliner)entity2;
                    train.onEnemyAttacked();
                }
                this.setFinisherCooldown(player);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 3));
                double lookAngle = Math.toRadians(player.m_146908_());
                double forwardMotion = 1.5;
                player.m_5997_(-Math.sin(lookAngle) * forwardMotion, 0.2, Math.cos(lookAngle) * forwardMotion);
                stack.m_41622_(2, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                if (!target.m_9236_().f_46443_ && (level = target.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_255391_((Entity)player, target.m_20185_(), target.m_20186_(), target.m_20189_(), 3.0f, false, Level.ExplosionInteraction.NONE);
                    target.m_6469_(serverLevel.m_269111_().m_269093_(null), 100.0f);
                    double playerLookAngle = Math.toRadians(player.m_146908_());
                    double xDir = -Math.sin(playerLookAngle);
                    double zDir = Math.cos(playerLookAngle);
                    for (LivingEntity entity3 : player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82363_(xDir * 9.0, 2.0, zDir * 9.0))) {
                        double dz;
                        double dx;
                        double distance;
                        if (entity3 == player || entity3 == target || !((distance = Math.sqrt((dx = entity3.m_20185_() - player.m_20185_()) * dx + (dz = entity3.m_20189_() - player.m_20189_()) * dz)) <= 9.0) || !((dx * xDir + dz * zDir) / distance > 0.5)) continue;
                        entity3.m_6469_(serverLevel.m_269111_().m_269093_(null), 75.0f);
                        entity3.m_5997_(xDir * 1.0, 0.3, zDir * 1.0);
                    }
                }
            } else {
                stack.m_41622_(1, attacker, entity -> entity.m_21190_(attacker.m_7655_()));
            }
        }
        return true;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        ItemStack stack;
        Player player;
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = source.m_7640_();
        if (target instanceof Player && (player = (Player)target).m_6117_() && denkamen_sword.isDenkamenSword(stack = player.m_21120_(player.m_7655_())) && player.m_21212_() > 0 && attacker instanceof LivingEntity && (source.m_19385_().equals("player") || source.m_19385_().equals("mob"))) {
            event.setAmount(0.0f);
            target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 0.8f, 0.8f + target.m_9236_().f_46441_.m_188501_() * 0.4f);
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
        }
    }

    private void markPlayerAsRidingDenliner(Player player) {
        player.getPersistentData().m_128379_(RIDING_DENLINER_TAG, true);
    }

    private void clearPlayerRidingDenliner(Player player) {
        player.getPersistentData().m_128473_(RIDING_DENLINER_TAG);
    }

    private boolean isPlayerRidingDenliner(Player player) {
        return player.getPersistentData().m_128471_(RIDING_DENLINER_TAG);
    }

    private void setFinisherCooldown(Player player) {
        player.getPersistentData().m_128356_(FINISHER_COOLDOWN_TAG, player.m_9236_().m_46467_());
    }

    private boolean isFinisherOnCooldown(Player player) {
        if (!player.getPersistentData().m_128441_(FINISHER_COOLDOWN_TAG)) {
            return false;
        }
        long cooldownStartTime = player.getPersistentData().m_128454_(FINISHER_COOLDOWN_TAG);
        return player.m_9236_().m_46467_() - cooldownStartTime < 600L;
    }

    private long getStandbyStartTime(Player player) {
        return player.getPersistentData().m_128454_(STANDBY_START_TIME_TAG);
    }

    private void setStandbyStartTime(Player player, long time) {
        player.getPersistentData().m_128356_(STANDBY_START_TIME_TAG, time);
    }

    private long getStandbyEndTime(Player player) {
        return player.getPersistentData().m_128454_(STANDBY_END_TIME_TAG);
    }

    private void setStandbyEndTime(Player player, long time) {
        player.getPersistentData().m_128356_(STANDBY_END_TIME_TAG, time);
    }

    private boolean isPlayerInStandby(Player player) {
        long endTime;
        if (!player.getPersistentData().m_128441_(STANDBY_START_TIME_TAG) || !player.getPersistentData().m_128441_(STANDBY_END_TIME_TAG)) {
            return false;
        }
        long currentTime = player.m_9236_().m_46467_();
        return currentTime < (endTime = this.getStandbyEndTime(player));
    }

    private void clearPlayerStandby(Player player) {
        player.getPersistentData().m_128473_(STANDBY_START_TIME_TAG);
        player.getPersistentData().m_128473_(STANDBY_END_TIME_TAG);
    }
}

