/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom.food;

import com.xiaoshi2022.kamen_rider_weapon_craft.Item.food.HelheimFruit.HelheimFruitRenderer;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.EffectInit;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HelheimFruit
extends Item
implements GeoItem {
    public static final TagKey<Item> HELHEIM_FOOD_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("kamen_rider_weapon_craft", "kamen_rider_helheim_food"));
    private static final RawAnimation OPEN = RawAnimation.begin().thenPlay("open");
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HelheimFruit(Item.Properties properties) {
        super(properties.m_41489_(new FoodProperties.Builder().m_38760_(3).m_38758_(0.3f).m_38765_().m_38767_()));
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BlockEntityWithoutLevelRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new HelheimFruitRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "open", 2, state -> PlayState.STOP).triggerableAnim("open", OPEN).setSoundKeyframeHandler(state -> {})});
    }

    private PlayState predicate(AnimationState<HelheimFruit> event) {
        event.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)player.m_21120_(hand), (ServerLevel)serverLevel), "open", "open");
        }
        return super.m_7203_(level, player, hand);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.f_46443_ && entity instanceof Player) {
            Player player;
            block19: {
                player = (Player)entity;
                try {
                    Class<?> playerShapeClass = Class.forName("tocraft.walkers.api.PlayerShape");
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Method getCurrentShapeMethod = playerShapeClass.getMethod("getCurrentShape", Player.class);
                    LivingEntity currentShape = (LivingEntity)getCurrentShapeMethod.invoke(null, player);
                    if (currentShape != null) {
                        System.out.println("[HelheimFruit] Player is transformed, checking Helmheim Power level");
                        int helmheimPowerLevel = -1;
                        for (MobEffectInstance effect : player.m_21220_()) {
                            if (effect.m_19544_() != EffectInit.HELMHEIM_POWER.get()) continue;
                            helmheimPowerLevel = effect.m_19564_();
                            System.out.println("[HelheimFruit] Detected Helmheim Power level: " + (helmheimPowerLevel + 1));
                            break;
                        }
                        if (helmheimPowerLevel >= 1) {
                            System.out.println("[HelheimFruit] High enough power level, evolving to human");
                            Method updateShapesMethod = playerShapeClass.getMethod("updateShapes", ServerPlayer.class, LivingEntity.class);
                            boolean result = (Boolean)updateShapesMethod.invoke(null, serverPlayer, null);
                            if (result) {
                                System.out.println("[HelheimFruit] Successfully evolved to human form");
                                player.m_213846_((Component)Component.m_237115_((String)"message.kamen_rider_weapon_craft.helmheim_power.evolved_to_human"));
                                player.m_7292_(new MobEffectInstance((MobEffect)EffectInit.HELMHEIM_POWER.get(), 2400, helmheimPowerLevel, false, false));
                            } else {
                                System.out.println("[HelheimFruit] Failed to evolve to human form");
                            }
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    System.out.println("[HelheimFruit] Walkers mod not available, skipping human evolution check");
                }
                catch (Exception e) {
                    System.out.println("[HelheimFruit] Error during human evolution check: " + e.getMessage());
                    e.printStackTrace();
                }
                if (player.m_217043_().m_188503_(100) < 40) {
                    player.m_8127_();
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    try {
                        LivingEntity invesHeilehimEntity;
                        Class<?> modEntityTypesClass = Class.forName("com.xiaoshi2022.kamen_rider_boss_you_and_me.entity.ModEntityTypes");
                        Field invesHeilehimField = modEntityTypesClass.getDeclaredField("INVES_HEILEHIM");
                        invesHeilehimField.setAccessible(true);
                        Object registryObject = invesHeilehimField.get(null);
                        Method getMethod = registryObject.getClass().getMethod("get", new Class[0]);
                        EntityType invesHeilehimType = (EntityType)getMethod.invoke(registryObject, new Object[0]);
                        if (invesHeilehimType == null || (invesHeilehimEntity = (LivingEntity)invesHeilehimType.m_20615_(level)) == null) break block19;
                        invesHeilehimEntity.m_6027_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                        if (!invesHeilehimEntity.m_6084_()) {
                            System.err.println("INVES_HEILEHIM initialization failed");
                            return stack;
                        }
                        try {
                            Class<?> playerShapeClass = Class.forName("tocraft.walkers.api.PlayerShape");
                            Method updateShapesMethod = playerShapeClass.getMethod("updateShapes", ServerPlayer.class, LivingEntity.class);
                            boolean result = (Boolean)updateShapesMethod.invoke(null, serverPlayer, invesHeilehimEntity);
                            if (result) {
                                System.out.println("Player transformed to INVES_HEILEHIM successfully");
                                break block19;
                            }
                            System.err.println("Player transformation failed");
                        }
                        catch (Exception e) {
                            System.out.println("Walkers mod not available, skipping transformation: " + e.getMessage());
                        }
                    }
                    catch (ClassNotFoundException e) {
                        System.out.println("Boss mod not available, skipping INVES_HEILEHIM transformation");
                    }
                    catch (Exception e) {
                        System.out.println("Error during INVES_HEILEHIM transformation: " + e.getMessage());
                    }
                }
            }
            if (player.m_217043_().m_188503_(100) < 60) {
                int powerLevel = player.m_217043_().m_188503_(3);
                player.m_7292_(new MobEffectInstance((MobEffect)EffectInit.HELMHEIM_POWER.get(), 600, powerLevel, false, false));
                if (powerLevel >= 1) {
                    player.m_213846_((Component)Component.m_237110_((String)"message.kamen_rider_weapon_craft.helmheim_power.level_up", (Object[])new Object[]{powerLevel + 1}));
                }
            }
        }
        return super.m_5922_(stack, level, entity);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

