/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.Item.prop.client.entity;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModSounds;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class LaserBeamEntity
extends Projectile {
    private static final EntityDataAccessor<ParticleOptions> DATA_PARTICLE_TYPE = SynchedEntityData.m_135353_(LaserBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);
    private static final int MAX_LIFETIME = 400;
    private int lifetime = 0;
    public double damage;
    private boolean isCritical = false;
    private float chargeTime;
    private final ItemStack weaponStack;
    private final SoundEvent shootSound;
    ParticleOptions particleType = (ParticleOptions)this.f_19804_.m_135370_(DATA_PARTICLE_TYPE);

    public LaserBeamEntity(EntityType<? extends LaserBeamEntity> type, Level level) {
        super(type, level);
        this.f_19804_.m_135381_(DATA_PARTICLE_TYPE, (Object)ParticleTypes.f_123744_);
        this.weaponStack = ItemStack.f_41583_;
        this.damage = 9.0;
        this.shootSound = (SoundEvent)ModSounds.SONICARROW_SHOOT.get();
    }

    public LaserBeamEntity(Level level, LivingEntity shooter, SimpleParticleType particleType, float chargeTime, ItemStack weaponStack) {
        this(level, shooter, (ParticleOptions)particleType, 9.0, (SoundEvent)ModSounds.SONICARROW_SHOOT.get(), chargeTime, weaponStack);
    }

    public LaserBeamEntity(Level level, LivingEntity shooter, ParticleOptions particleType, double damage, SoundEvent shootSound, float chargeTime, ItemStack weaponStack) {
        super((EntityType)ModEntityTypes.LASER_BEAM.get(), level);
        this.f_19804_.m_135381_(DATA_PARTICLE_TYPE, (Object)particleType);
        this.weaponStack = weaponStack;
        this.damage = damage;
        this.shootSound = shootSound;
        this.chargeTime = chargeTime;
        this.m_6034_(shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_(), shooter.m_20189_());
        this.m_5602_((Entity)shooter);
        this.adjustDamageBasedOnCharge();
        this.setCriticalChance(chargeTime);
        this.m_20011_(new AABB(this.m_20185_() - 1.0, this.m_20186_() - 1.0, this.m_20189_() - 1.0, this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0));
    }

    private void adjustDamageBasedOnCharge() {
        this.damage += (double)this.chargeTime * 0.6;
    }

    private void setCriticalChance(float chargeTime) {
        Random random = new Random();
        float criticalChance = chargeTime * 0.1f;
        if (random.nextFloat() < criticalChance) {
            this.isCritical = true;
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity target = result.m_82443_();
        if (target instanceof LivingEntity) {
            DamageSource damageSource;
            Entity entity;
            Map enchantments;
            LivingEntity livingEntity = (LivingEntity)target;
            if (this.m_6060_()) {
                livingEntity.m_20254_(5);
            }
            if (this.weaponStack != null && this.weaponStack.m_41793_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)this.weaponStack) > 0) {
                int punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)this.weaponStack);
                float knockbackStrength = 0.5f * (float)punchLevel;
                if (this.m_19749_() != null) {
                    double dz;
                    double dx = this.m_19749_().m_20185_() - livingEntity.m_20185_();
                    double length = Math.sqrt(dx * dx + (dz = this.m_19749_().m_20189_() - livingEntity.m_20189_()) * dz);
                    if (length > 0.0) {
                        dx /= length;
                        dz /= length;
                    }
                    livingEntity.m_147240_((double)knockbackStrength, dx, dz);
                }
            }
            if (this.weaponStack != null && this.weaponStack.m_41793_() && (enchantments = EnchantmentHelper.m_44831_((ItemStack)this.weaponStack)).containsKey(Enchantments.f_44958_) && (Integer)enchantments.get(Enchantments.f_44958_) > 0 && this.m_9236_().m_46470_() && this.m_9236_().m_45527_(new BlockPos((Vec3i)livingEntity.m_20183_()))) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), 0.0, 0.0, 0.0);
                LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, this.m_9236_());
                lightningBolt.m_6034_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
                this.m_9236_().m_7967_((Entity)lightningBolt);
            }
            if ((entity = this.m_19749_()) instanceof Player) {
                Player player = (Player)entity;
                damageSource = player.m_269291_().m_269075_(player);
            } else {
                damageSource = this.m_269291_().m_269264_();
            }
            float damageAmount = (float)this.damage;
            if (this.isCritical) {
                damageAmount *= 1.5f;
            }
            livingEntity.m_6469_(damageSource, damageAmount);
        }
        this.m_146870_();
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.m_146870_();
        if (this.m_9236_().f_46443_) {
            ParticleOptions particleType = (ParticleOptions)this.f_19804_.m_135370_(DATA_PARTICLE_TYPE);
            Vec3 hitPos = result.m_82450_();
            this.m_9236_().m_7106_(particleType, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_PARTICLE_TYPE, (Object)ParticleTypes.f_123744_);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifetime;
        if (this.lifetime >= 400) {
            this.m_146870_();
            return;
        }
        Vec3 motion = this.m_20184_();
        Vec3 nextPos = this.m_20182_().m_82549_(motion);
        BlockHitResult blockHitResult = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
            this.m_8060_(blockHitResult);
            return;
        }
        AABB aabb = this.m_20191_().m_82383_(motion).m_82377_(1.0, 1.0, 1.0);
        EntityHitResult entityHitResult = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)this.m_20182_(), (Vec3)nextPos, (AABB)aabb, entity -> !entity.m_5833_() && entity.m_6087_());
        if (entityHitResult != null) {
            this.m_5790_(entityHitResult);
            return;
        }
        this.m_6034_(nextPos.f_82479_, nextPos.f_82480_, nextPos.f_82481_);
        if (this.m_9236_().f_46443_) {
            ParticleOptions particleType = (ParticleOptions)this.f_19804_.m_135370_(DATA_PARTICLE_TYPE);
            for (int i = 0; i < 15; ++i) {
                double offsetX = motion.f_82479_ * (double)i * 0.1;
                double offsetY = motion.f_82480_ * (double)i * 0.1;
                double offsetZ = motion.f_82481_ * (double)i * 0.1;
                this.m_9236_().m_7106_(particleType, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128347_("baseDamage", this.damage);
        tag.m_128379_("isCritical", this.isCritical);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.damage = tag.m_128459_("baseDamage");
        this.isCritical = tag.m_128471_("isCritical");
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) && entity != this.m_19749_();
    }

    public void shoot(double xSpeed, double ySpeed, double zSpeed) {
        this.m_20334_(xSpeed, ySpeed, zSpeed);
        double xz = Math.sqrt(xSpeed * xSpeed + zSpeed * zSpeed);
        this.m_146922_((float)(Mth.m_14136_((double)xSpeed, (double)zSpeed) * 180.0 / Math.PI));
        this.m_146926_((float)(Mth.m_14136_((double)ySpeed, (double)xz) * 180.0 / Math.PI));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }
}

