/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.entity.ai.goal;

import com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom.Heiseisword;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffectManager;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HeiseiswordGoal
extends Goal {
    protected final LivingEntity entity;
    protected final Level level;
    protected final Random random;
    protected LivingEntity target;
    protected int attackCooldown = 0;
    protected int maxAttackCooldown = 20;

    public HeiseiswordGoal(LivingEntity entity) {
        this.entity = entity;
        this.level = entity.m_9236_();
        this.random = new Random();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        ItemStack mainHand = this.entity.m_21205_();
        if (!(mainHand.m_41720_() instanceof Heiseisword)) {
            return false;
        }
        this.target = this.getAttackTarget(this.entity);
        return this.target != null && this.isWithinAttackRange(this.target);
    }

    public boolean m_8045_() {
        ItemStack mainHand = this.entity.m_21205_();
        if (!(mainHand.m_41720_() instanceof Heiseisword) || this.target == null || !this.target.m_6084_()) {
            return false;
        }
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Monster) {
            Monster monster = (Monster)livingEntity;
            return monster.m_5448_() == this.target && this.isWithinAttackRange(this.target);
        }
        return this.isWithinAttackRange(this.target);
    }

    public void m_8056_() {
        this.attackCooldown = 0;
    }

    public void m_8037_() {
        LivingEntity livingEntity;
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.target != null && (livingEntity = this.entity) instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        }
        if (this.canAttack() && this.attackCooldown <= 0) {
            this.performAttack();
            this.attackCooldown = this.maxAttackCooldown;
        }
    }

    protected boolean canAttack() {
        return this.target != null && this.target.m_6084_() && this.isWithinAttackRange(this.target);
    }

    protected void performAttack() {
        ItemStack mainHand = this.entity.m_21205_();
        Item item = mainHand.m_41720_();
        if (!(item instanceof Heiseisword)) {
            return;
        }
        Heiseisword heiseisword = (Heiseisword)item;
        Vec3 direction = this.target.m_20182_().m_82546_(this.entity.m_20182_()).m_82541_();
        String selectedRider = Heiseisword.getSelectedRiderStatic(mainHand);
        if (selectedRider != null && !selectedRider.isEmpty()) {
            HeiseiRiderEffect riderEffect = HeiseiRiderEffectManager.getRiderEffect(selectedRider);
            if (this.random.nextDouble() < 0.7) {
                if ((double)this.entity.m_20270_((Entity)this.target) < 2.5) {
                    riderEffect.executeSpecialAttack(this.level, this.entity, direction);
                    HeiseiRiderEffectManager.playAttackSound(this.level, this.entity, selectedRider);
                    mainHand.m_41784_().m_128356_("lastAttackTime", this.level.m_46467_());
                }
            } else {
                float chargeTime = 0.5f + this.random.nextFloat() * 0.5f;
                riderEffect.executeSpecialAttack(this.level, this.entity, direction.m_82490_((double)chargeTime * 2.0));
                HeiseiRiderEffectManager.playAttackSound(this.level, this.entity, selectedRider);
                mainHand.m_41784_().m_128356_("lastAttackTime", this.level.m_46467_());
            }
        }
    }

    protected LivingEntity getAttackTarget(LivingEntity entity) {
        if (entity instanceof Monster) {
            Monster monster = (Monster)entity;
            return monster.m_5448_();
        }
        return this.level.m_45930_((Entity)entity, 16.0);
    }

    protected boolean isWithinAttackRange(LivingEntity target) {
        double distance = this.entity.m_20270_((Entity)target);
        return distance <= 8.0;
    }

    protected boolean isHoldingHeiseisword() {
        ItemStack mainHand = this.entity.m_21205_();
        return mainHand.m_41720_() instanceof Heiseisword;
    }
}

