/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.entity.line;

import com.xiaoshi2022.kamen_rider_weapon_craft.network.NetworkHandler;
import com.xiaoshi2022.kamen_rider_weapon_craft.network.SoundStopPacket;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModSounds;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class denliner
extends LivingEntity
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> IS_PLAYING_SOUND = SynchedEntityData.m_135353_(denliner.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Long> SOUND_START_TIME = SynchedEntityData.m_135353_(denliner.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final int STANDBY_DURATION = 100;
    private Player rider;
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenPlay("idle");
    private static final RawAnimation RUN_ANIMATION = RawAnimation.begin().thenPlay("idle");

    public static AttributeSupplier createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 0.0).m_22265_();
    }

    public denliner(@NotNull EntityType<denliner> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = false;
        this.m_20242_(true);
        this.m_21153_(this.m_21233_());
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6090_() {
        return false;
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_(x, y, z);
        this.m_20101_();
    }

    public static denliner create(Level level, double x, double y, double z, Player player) {
        denliner denliner2 = new denliner((EntityType<denliner>)((EntityType)ModEntityTypes.DENLINER.get()), level);
        denliner2.m_6034_(x, y, z);
        denliner2.setRider(player);
        denliner2.startStandbySound();
        return denliner2;
    }

    public static denliner create(ServerLevel level, Player player) {
        denliner train = new denliner((EntityType<denliner>)((EntityType)ModEntityTypes.DENLINER.get()), (Level)level);
        train.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        train.setRider(player);
        train.startStandbySound();
        level.m_7967_((Entity)train);
        return train;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_PLAYING_SOUND, (Object)false);
        this.f_19804_.m_135372_(SOUND_START_TIME, (Object)0L);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 20, this::predicate)});
    }

    private <E extends Entity> PlayState predicate(AnimationState<E> event) {
        if (this.isMoving()) {
            event.getController().setAnimation(RUN_ANIMATION);
            event.getController().setAnimationSpeed(1.0);
        } else {
            event.getController().setAnimation(IDLE_ANIMATION);
            event.getController().setAnimationSpeed(0.5);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private boolean isMoving() {
        return this.m_20184_().m_82556_() > 0.001;
    }

    public void setRider(Player player) {
        if (player != null) {
            this.rider = player;
            if (!player.m_20365_((Entity)this)) {
                player.m_7998_((Entity)this, true);
            }
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean m_6673_(DamageSource source) {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.cleanupBeforeRemoval();
        return super.m_6469_(source, amount);
    }

    public void m_6074_() {
        this.cleanupBeforeRemoval();
        super.m_6074_();
    }

    public void m_6667_(DamageSource damageSource) {
        this.cleanupBeforeRemoval();
        super.m_6667_(damageSource);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.KILLED || reason == Entity.RemovalReason.DISCARDED) {
            this.cleanupBeforeRemoval();
        }
        super.m_142687_(reason);
    }

    private void cleanupBeforeRemoval() {
        this.stopStandbySound();
        if (!this.m_9236_().f_46443_ && this.rider != null) {
            ResourceLocation soundLoc = new ResourceLocation("kamen_rider_weapon_craft", "den_o_lines");
            NetworkHandler.sendToAllTracking(new SoundStopPacket(this.rider.m_19879_(), soundLoc), (Entity)this.rider);
            CommandSourceStack source = ((ServerLevel)this.m_9236_()).m_7654_().m_129893_().m_81329_((Entity)this.rider).m_81324_().m_81325_(2);
            try {
                String command = String.format("/stopsound @a[distance=..64] player %s", soundLoc.toString());
                ((ServerLevel)this.m_9236_()).m_7654_().m_129892_().m_230957_(source, command);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.rider != null) {
            this.rider.m_8127_();
            this.rider = null;
        }
    }

    public void startStandbySound() {
        Level level;
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.f_19804_.m_135381_(IS_PLAYING_SOUND, (Object)true);
            this.f_19804_.m_135381_(SOUND_START_TIME, (Object)this.m_9236_().m_46467_());
            serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.DEN_O_LINES.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void stopStandbySound() {
        if (((Boolean)this.f_19804_.m_135370_(IS_PLAYING_SOUND)).booleanValue()) {
            this.f_19804_.m_135381_(IS_PLAYING_SOUND, (Object)false);
        }
    }

    public void onEnemyAttacked() {
        this.cleanupBeforeRemoval();
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(IS_PLAYING_SOUND, (Object)tag.m_128471_("isPlayingSound"));
        this.f_19804_.m_135381_(SOUND_START_TIME, (Object)tag.m_128454_("soundStartTime"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("isPlayingSound", ((Boolean)this.f_19804_.m_135370_(IS_PLAYING_SOUND)).booleanValue());
        tag.m_128356_("soundStartTime", ((Long)this.f_19804_.m_135370_(SOUND_START_TIME)).longValue());
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)2.0f, (float)1.0f);
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82377_(1.0, 0.5, 1.0);
    }

    public Iterable<ItemStack> m_6168_() {
        return List.of();
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public double m_6048_() {
        return 1.2;
    }

    public void m_8119_() {
        super.m_8119_();
        if (((Boolean)this.f_19804_.m_135370_(IS_PLAYING_SOUND)).booleanValue()) {
            long startTime = (Long)this.f_19804_.m_135370_(SOUND_START_TIME);
            long currentTime = this.m_9236_().m_46467_();
            if (currentTime - startTime > 100L || this.rider != null && !this.rider.m_20365_((Entity)this)) {
                this.cleanupBeforeRemoval();
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
        }
        this.damageEntitiesInFront();
        if (this.rider != null && this.rider.m_20365_((Entity)this) && !this.m_9236_().f_46443_) {
            this.updatePositionAndRotation();
        }
    }

    private void damageEntitiesInFront() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        float rotationYaw = this.m_146908_() * ((float)Math.PI / 180);
        double frontX = Math.sin(-rotationYaw);
        double frontZ = Math.cos(-rotationYaw);
        double range = 9.0;
        double radius = 2.0;
        double centerX = this.m_20185_() + frontX * range;
        double centerY = this.m_20186_();
        double centerZ = this.m_20189_() + frontZ * range;
        AABB area = new AABB(centerX - radius, centerY - 1.0, centerZ - radius, centerX + radius, centerY + 2.0, centerZ + radius);
        List entities = this.m_9236_().m_6443_(LivingEntity.class, area, entity -> entity != this && entity != this.rider && (!(entity instanceof Player) || this.rider == null || !((Player)entity).m_7307_((Entity)this.rider)));
        for (LivingEntity entity2 : entities) {
            Vec3 entityPos = entity2.m_20182_();
            Vec3 directionToEntity = entityPos.m_82546_(this.m_20182_());
            double dotProduct = frontX * directionToEntity.f_82479_ + frontZ * directionToEntity.f_82481_;
            if (!(dotProduct > 0.0)) continue;
            DamageSource damageSource = this.rider != null ? this.rider.m_269291_().m_269075_(this.rider) : this.m_269291_().m_269333_((LivingEntity)this);
            entity2.m_6469_(damageSource, 10.0f);
            double knockbackX = frontX * 2.0;
            double knockbackZ = frontZ * 2.0;
            entity2.m_5997_(knockbackX, 0.5, knockbackZ);
        }
    }

    private void updatePositionAndRotation() {
        if (this.rider == null) {
            return;
        }
        double targetX = this.rider.m_20185_();
        double targetY = this.rider.m_20186_() - 1.0;
        double targetZ = this.rider.m_20189_();
        if (!this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60795_()) {
            targetY = Math.max(targetY, (double)this.m_20183_().m_123342_() + 0.1);
        }
        double currentX = this.m_20185_();
        double currentY = this.m_20186_();
        double currentZ = this.m_20189_();
        double smoothX = currentX + (targetX - currentX) * 0.3;
        double smoothY = currentY + (targetY - currentY) * 0.3;
        double smoothZ = currentZ + (targetZ - currentZ) * 0.3;
        this.m_6034_(smoothX, smoothY, smoothZ);
        this.updateRotationSmoothly();
    }

    private void updateRotationSmoothly() {
        float yRotDiff;
        if (this.rider == null) {
            return;
        }
        float targetYRot = this.rider.m_146908_();
        float targetXRot = this.rider.m_146909_() * 0.5f;
        float currentYRot = this.m_146908_();
        float currentXRot = this.m_146909_();
        float xRotDiff = targetXRot - currentXRot;
        for (yRotDiff = targetYRot - currentYRot; yRotDiff < -180.0f; yRotDiff += 360.0f) {
        }
        while (yRotDiff >= 180.0f) {
            yRotDiff -= 360.0f;
        }
        while (xRotDiff < -180.0f) {
            xRotDiff += 360.0f;
        }
        while (xRotDiff >= 180.0f) {
            xRotDiff -= 360.0f;
        }
        float smoothYRot = currentYRot + yRotDiff * 0.3f;
        float smoothXRot = currentXRot + xRotDiff * 0.3f;
        this.m_146922_(smoothYRot);
        this.m_146926_(smoothXRot);
        this.m_5618_(smoothYRot);
        this.m_5616_(smoothYRot);
        this.f_19859_ = smoothYRot;
        this.f_19860_ = smoothXRot;
        this.f_20884_ = smoothYRot;
        this.f_20886_ = smoothYRot;
    }

    public boolean m_6109_() {
        return true;
    }

    public void m_7340_(Entity passenger) {
        if (passenger == this.rider) {
            this.updateRotationSmoothly();
        }
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(passenger)) {
            double yOffset = this.m_6048_() + passenger.m_6049_();
            Vec3 riderPos = new Vec3(0.0, yOffset, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            moveFunction.m_20372_(passenger, this.m_20185_() + riderPos.f_82479_, this.m_20186_() + riderPos.f_82480_, this.m_20189_() + riderPos.f_82481_);
            if (passenger instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)passenger;
                living.m_5618_(this.m_146908_());
                living.m_5616_(this.m_146908_());
            }
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_8107_() {
        if (!this.m_9236_().f_46443_) {
            super.m_8107_();
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.m_9236_().f_46443_ && this.rider != null) {
            this.updateRotationSmoothly();
        }
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean isPersistent() {
        return true;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20160_() && this.m_6688_() != null) {
            LivingEntity controller = this.m_6688_();
            this.m_146922_(controller.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(controller.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        super.m_7023_(Vec3.f_82478_);
    }

    public void m_20256_(Vec3 deltaMovement) {
        super.m_20256_(deltaMovement.m_82490_(0.1));
    }

    public void m_5997_(double x, double y, double z) {
    }

    public LivingEntity m_6688_() {
        return this.rider;
    }

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().isEmpty();
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (passenger instanceof Player) {
            this.rider = (Player)passenger;
            this.updateRotationSmoothly();
        }
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (passenger == this.rider) {
            this.rider = null;
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_5803_() {
        return false;
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_142265_(Level level, BlockPos pos) {
        return false;
    }
}

