/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.network;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.network.NetworkEvent;

public class SoundStopPacket {
    private final int playerId;
    private final ResourceLocation soundName;

    public SoundStopPacket(int playerId, ResourceLocation soundName) {
        this.playerId = playerId;
        this.soundName = soundName;
    }

    public static void encode(SoundStopPacket msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.playerId);
        buffer.m_130085_(msg.soundName);
    }

    public static SoundStopPacket decode(FriendlyByteBuf buffer) {
        int playerId = buffer.readInt();
        ResourceLocation soundName = buffer.m_130281_();
        return new SoundStopPacket(playerId, soundName);
    }

    public static class ClientHandler {
        public static void handle(SoundStopPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ == null || mc.f_91074_ == null) {
                    return;
                }
                SoundManager soundManager = mc.m_91106_();
                for (SoundInstance sound : ClientHandler.getPlayingSounds(soundManager)) {
                    if (sound.m_8070_() != SoundSource.PLAYERS || !sound.m_7904_().equals((Object)msg.soundName)) continue;
                    soundManager.m_120399_(sound);
                }
            });
            ctx.get().setPacketHandled(true);
        }

        private static Collection<SoundInstance> getPlayingSounds(SoundManager manager) {
            try {
                Field field = SoundManager.class.getDeclaredField("instanceToChannel");
                field.setAccessible(true);
                return ((Map)field.get(manager)).keySet();
            }
            catch (Exception e) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)("\u97f3\u6548\u505c\u6b62\u9519\u8bef: " + e.getMessage())), false);
                return Collections.emptyList();
            }
        }
    }

    public static class Handler {
        public static void handle(SoundStopPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender;
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer() && (sender = ((NetworkEvent.Context)ctx.get()).getSender()) != null) {
                    CommandSourceStack source = sender.m_20203_().m_81325_(2).m_81324_();
                    String command = String.format("/stopsound @a[distance=..64] player %s", msg.soundName.toString());
                    sender.f_8924_.m_129892_().m_230957_(source, command);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

