/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.network;

import com.xiaoshi2022.kamen_rider_weapon_craft.blocks.client.RiderFusionMachineBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncAnimationStatePacket {
    private static final Logger LOGGER = LogManager.getLogger();
    private final boolean shouldPlayEndAnimation;
    private final BlockPos pos;

    public SyncAnimationStatePacket(boolean shouldPlayEndAnimation, BlockPos pos) {
        this.shouldPlayEndAnimation = shouldPlayEndAnimation;
        this.pos = pos;
    }

    public static void encode(SyncAnimationStatePacket packet, FriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.shouldPlayEndAnimation);
        buffer.m_130064_(packet.pos);
    }

    public static SyncAnimationStatePacket decode(FriendlyByteBuf buffer) {
        return new SyncAnimationStatePacket(buffer.readBoolean(), buffer.m_130135_());
    }

    public static void handle(SyncAnimationStatePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                SyncAnimationStatePacket.handleClient(packet);
            } else {
                LOGGER.warn("Received animation packet in wrong direction: {}", (Object)context.getDirection());
            }
        });
        context.setPacketHandled(true);
    }

    private static void handleClient(SyncAnimationStatePacket packet) {
        Minecraft client = Minecraft.m_91087_();
        if (client == null) {
            return;
        }
        ClientLevel level = client.f_91073_;
        if (level == null || !level.m_46749_(packet.pos)) {
            LOGGER.debug("Received animation packet for unloaded position: {}", (Object)packet.pos);
            return;
        }
        client.execute(() -> SyncAnimationStatePacket.lambda$handleClient$1((Level)level, packet));
    }

    private static /* synthetic */ void lambda$handleClient$1(Level level, SyncAnimationStatePacket packet) {
        try {
            BlockEntity be = level.m_7702_(packet.pos);
            if (be instanceof RiderFusionMachineBlockEntity) {
                RiderFusionMachineBlockEntity fusionMachine = (RiderFusionMachineBlockEntity)be;
                fusionMachine.shouldPlayEndAnimation = packet.shouldPlayEndAnimation;
                fusionMachine.requestModelDataUpdate();
                level.m_7260_(packet.pos, be.m_58900_(), be.m_58900_(), 3);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error handling animation packet at {}: {}", (Object)packet.pos, (Object)e.toString());
        }
    }
}

