/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffectManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AgitoEffect
extends AbstractHeiseiRiderEffect {
    @Override
    public void executePlayerSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            Vec3 normalizedDirection = direction.m_82541_();
            double range = this.getEffectRange();
            Vec3 start = player.m_20299_(1.0f);
            Vec3 end = start.m_82549_(normalizedDirection.m_82490_(range));
            AABB attackBox = new AABB(start, end).m_82377_(range / 2.0, 2.0, range / 2.0);
            level.m_6443_(LivingEntity.class, attackBox, entity -> {
                if (entity == player) {
                    return false;
                }
                Vec3 toEntity = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_();
                double dotProduct = toEntity.m_82526_(normalizedDirection);
                return dotProduct > 0.7;
            }).forEach(livingEntity -> {
                if (livingEntity instanceof ZombieVillager) {
                    ZombieVillager zombieVillager = (ZombieVillager)livingEntity;
                    this.purifyZombieVillager(level, zombieVillager);
                } else {
                    livingEntity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage());
                }
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0));
            });
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0));
        }
    }

    private void purifyZombieVillager(Level level, ZombieVillager zombieVillager) {
        block12: {
            if (!level.f_46443_ && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                try {
                    double x = zombieVillager.m_20185_();
                    double y = zombieVillager.m_20186_();
                    double z = zombieVillager.m_20189_();
                    float yaw = zombieVillager.m_146908_();
                    float pitch = zombieVillager.m_146909_();
                    CompoundTag originalData = new CompoundTag();
                    zombieVillager.m_20240_(originalData);
                    VillagerData villagerData = zombieVillager.m_7141_();
                    Villager villager = (Villager)EntityType.f_20492_.m_20615_((Level)serverLevel);
                    if (villager == null) break block12;
                    villager.m_6034_(x, y, z);
                    villager.m_146922_(yaw);
                    villager.m_146926_(pitch);
                    villager.m_34375_(villagerData);
                    try {
                        if (originalData.m_128441_("MCA")) {
                            CompoundTag mcaData = originalData.m_128469_("MCA");
                            CompoundTag villagerDataTag = new CompoundTag();
                            villager.m_20240_(villagerDataTag);
                            villagerDataTag.m_128365_("MCA", (Tag)mcaData);
                            villager.m_20258_(villagerDataTag);
                        }
                    }
                    catch (Exception mcaData) {
                        // empty catch block
                    }
                    try {
                        if (originalData.m_128441_("Offers")) {
                            villager.m_20258_(originalData);
                        }
                        if (originalData.m_128441_("Age")) {
                            villager.m_146762_(originalData.m_128451_("Age"));
                        }
                        villager.m_21557_(zombieVillager.m_21525_());
                        if (zombieVillager.m_8077_()) {
                            villager.m_6593_(zombieVillager.m_7770_());
                            villager.m_20340_(zombieVillager.m_20151_());
                        }
                    }
                    catch (Exception mcaData) {
                        // empty catch block
                    }
                    zombieVillager.m_142687_(Entity.RemovalReason.DISCARDED);
                    serverLevel.m_7967_((Entity)villager);
                    level.m_6263_(null, x, y, z, SoundEvents.f_12644_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    for (int i = 0; i < 20; ++i) {
                        double dx = (level.f_46441_.m_188500_() - 0.5) * 2.0;
                        double dy = level.f_46441_.m_188500_() * 2.0;
                        double dz = (level.f_46441_.m_188500_() - 0.5) * 2.0;
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123750_, x, y + 0.5, z, dx * 0.2, dy * 0.2, dz * 0.2);
                    }
                }
                catch (Exception e) {
                    System.err.println("\u51c0\u5316\u50f5\u5c38\u6751\u6c11\u65f6\u51fa\u9519: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void executeNonPlayerSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            HeiseiRiderEffectManager.playSelectionSound(level, shooter, this.getRiderName());
            HeiseiRiderEffectManager.playAttackSound(level, shooter, this.getRiderName());
            Vec3 normalizedDirection = direction != null && direction.m_82556_() > 0.0 ? direction.m_82541_() : shooter.m_20154_().m_82541_();
            double range = this.getEffectRange();
            Vec3 start = shooter.m_20299_(1.0f);
            Vec3 end = start.m_82549_(normalizedDirection.m_82490_(range));
            AABB attackBox = new AABB(start, end).m_82377_(range / 2.0, 2.0, range / 2.0);
            level.m_6443_(LivingEntity.class, attackBox, entity -> {
                if (entity == shooter) {
                    return false;
                }
                Vec3 toEntity = entity.m_20182_().m_82546_(shooter.m_20182_()).m_82541_();
                double dotProduct = toEntity.m_82526_(normalizedDirection);
                return dotProduct > 0.7;
            }).forEach(livingEntity -> {
                if (livingEntity instanceof ZombieVillager) {
                    ZombieVillager zombieVillager = (ZombieVillager)livingEntity;
                    this.purifyZombieVillager(level, zombieVillager);
                } else {
                    livingEntity.m_6469_(level.m_269111_().m_269333_(shooter), this.getAttackDamage());
                }
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0));
            });
            shooter.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0));
        }
    }

    @Override
    public String getRiderName() {
        return "Agito";
    }

    @Override
    public String getActivationSoundName() {
        return "Ground Flame!";
    }

    @Override
    public float getAttackDamage() {
        return 46.0f;
    }

    @Override
    public float getEffectRange() {
        return 6.0f;
    }
}

