/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffectManager;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BladeEffect
extends AbstractHeiseiRiderEffect {
    @Override
    public void executePlayerSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            Vec3 normalizedDirection = direction.m_82541_();
            double reach = this.getEffectRange();
            Vec3 start = player.m_20299_(1.0f);
            Vec3 end = start.m_82549_(normalizedDirection.m_82490_(reach));
            AABB attackBox = new AABB(start, end).m_82400_(1.0);
            level.m_6443_(LivingEntity.class, attackBox, entity -> {
                if (entity == player) {
                    return false;
                }
                Vec3 toEntity = entity.m_20182_().m_82546_(start).m_82541_();
                return toEntity.m_82526_(normalizedDirection) > 0.5;
            }).forEach(entity -> {
                entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage());
                this.addElectricalShockEffect((LivingEntity)entity);
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12090_, SoundSource.PLAYERS, 0.5f, 1.0f);
            });
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300, 1));
        }
    }

    private void addElectricalShockEffect(LivingEntity entity) {
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100, 1));
        if (!(entity instanceof Player)) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0));
        }
    }

    @Override
    public String getRiderName() {
        return "Blade";
    }

    @Override
    public String getActivationSoundName() {
        return "Lightning Slash!";
    }

    @Override
    public float getAttackDamage() {
        return 49.0f;
    }

    @Override
    public float getEffectRange() {
        return 10.0f;
    }

    @Override
    public void executeNonPlayerSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            HeiseiRiderEffectManager.playSelectionSound(level, shooter, this.getRiderName());
            HeiseiRiderEffectManager.playAttackSound(level, shooter, this.getRiderName());
            Vec3 normalizedDirection = direction != null && direction.m_82556_() > 0.0 ? direction.m_82541_() : shooter.m_20154_().m_82541_();
            double reach = this.getEffectRange();
            Vec3 start = shooter.m_20299_(1.0f);
            Vec3 end = start.m_82549_(normalizedDirection.m_82490_(reach));
            AABB attackBox = new AABB(start, end).m_82400_(1.0);
            level.m_6443_(LivingEntity.class, attackBox, entity -> {
                if (entity == shooter) {
                    return false;
                }
                Vec3 toEntity = entity.m_20182_().m_82546_(start).m_82541_();
                return toEntity.m_82526_(normalizedDirection) > 0.5;
            }).forEach(entity -> {
                entity.m_6469_(level.m_269111_().m_269333_(shooter), this.getAttackDamage());
                this.addElectricalShockEffect((LivingEntity)entity);
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12090_, SoundSource.PLAYERS, 0.5f, 1.0f);
            });
            shooter.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300, 1));
        }
    }
}

