/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom.ridebooker;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.build.BuildRiderEntity;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.decade.DecadeRiderEntity;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.drive.DriveRiderEntity;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.kiva.KivaBatEntity;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.kuuga.KuugaRiderEntity;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.w.WTornadoEntity;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DecadeEffect
extends AbstractHeiseiRiderEffect {
    @Override
    public void executePlayerSpecialAttack(Level level, Player player, Vec3 direction) {
        super.executePlayerSpecialAttack(level, player, direction);
        if (!level.f_46443_) {
            DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, this.getAttackDamage());
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 120, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 120, 0));
            this.triggerNearbyRiderEffects(level, player, direction);
        }
    }

    private void triggerNearbyRiderEffects(Level level, Player player, Vec3 direction) {
        List nearbyEntities = level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(10.0), entity -> entity != player && entity.m_6084_());
        HashSet<String> triggeredRiders = new HashSet<String>();
        for (LivingEntity nearbyEntity : nearbyEntities) {
            String selectedRider;
            ItemStack mainHandItem = nearbyEntity.m_21205_();
            if (!(mainHandItem.m_41720_() instanceof ridebooker) || (selectedRider = this.getSelectedRiderFromRidebooker(mainHandItem)) == null || selectedRider.isEmpty() || triggeredRiders.contains(selectedRider)) continue;
            this.triggerRiderEffect(level, player, direction, selectedRider);
            triggeredRiders.add(selectedRider);
        }
    }

    private String getSelectedRiderFromRidebooker(ItemStack ridebookerStack) {
        CompoundTag tag = ridebookerStack.m_41783_();
        if (tag != null && tag.m_128441_("SelectedRider")) {
            return tag.m_128461_("SelectedRider");
        }
        return null;
    }

    private void triggerRiderEffect(Level level, Player player, Vec3 direction, String riderName) {
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 0.8f, 1.0f);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123797_, player.m_20185_() + direction.f_82479_ * 2.0, player.m_20186_() + 1.0, player.m_20189_() + direction.f_82481_ * 2.0, 0.5, 0.5, 0.5);
        for (int i = 0; i < 20; ++i) {
            double dx = (level.f_46441_.m_188500_() - 0.5) * 0.5;
            double dy = (level.f_46441_.m_188500_() - 0.5) * 0.5;
            double dz = (level.f_46441_.m_188500_() - 0.5) * 0.5;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123797_, player.m_20185_() + direction.f_82479_ * 2.0 + dx, player.m_20186_() + 1.0 + dy, player.m_20189_() + direction.f_82481_ * 2.0 + dz, 0.0, 0.0, 0.0);
        }
        Vec3 offsetDirection = new Vec3(direction.f_82479_ + (level.f_46441_.m_188500_() - 0.5) * 0.3, direction.f_82480_ + (level.f_46441_.m_188500_() - 0.5) * 0.3, direction.f_82481_ + (level.f_46441_.m_188500_() - 0.5) * 0.3).m_82541_();
        this.spawnSpecificRiderEffect(level, player, offsetDirection, riderName);
    }

    private void spawnSpecificRiderEffect(Level level, Player player, Vec3 direction, String riderName) {
        if (level.f_46443_) {
            return;
        }
        float damage = this.getAttackDamage() * 0.3f;
        switch (riderName.toLowerCase()) {
            case "kuuga": {
                try {
                    KuugaRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                }
                break;
            }
            case "agito": {
                try {
                    throw new Exception("Agito\u53ea\u6709\u6548\u679c\u7c7b\uff0c\u6ca1\u6709\u5b9e\u4f53\u7c7b");
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                    break;
                }
            }
            case "ryuki": {
                try {
                    throw new Exception("Ryuki\u53ea\u6709\u6548\u679c\u7c7b\uff0c\u6ca1\u6709\u5b9e\u4f53\u7c7b");
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                    break;
                }
            }
            case "faiz": {
                try {
                    throw new Exception("Faiz\u53ea\u6709\u6548\u679c\u7c7b\uff0c\u6ca1\u6709\u5b9e\u4f53\u7c7b");
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                    break;
                }
            }
            case "blade": {
                try {
                    throw new Exception("Blade\u53ea\u6709\u6548\u679c\u7c7b\uff0c\u6ca1\u6709\u5b9e\u4f53\u7c7b");
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                    break;
                }
            }
            case "hibiki": {
                try {
                    throw new Exception("Hibiki\u53ea\u6709\u6548\u679c\u7c7b\uff0c\u6ca1\u6709\u5b9e\u4f53\u7c7b");
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                    break;
                }
            }
            case "kabuto": {
                try {
                    throw new Exception("Kabuto\u53ea\u6709\u6548\u679c\u7c7b\uff0c\u6ca1\u6709\u5b9e\u4f53\u7c7b");
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                    break;
                }
            }
            case "den-o": {
                try {
                    throw new Exception("Den-O\u53ea\u6709\u6548\u679c\u7c7b\uff0c\u6ca1\u6709\u5b9e\u4f53\u7c7b");
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                    break;
                }
            }
            case "kiva": {
                try {
                    KivaBatEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                }
                break;
            }
            case "decade": {
                DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                break;
            }
            case "w": {
                try {
                    WTornadoEntity.trySpawnTornado(level, player, direction);
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                }
                break;
            }
            case "ooo": {
                try {
                    throw new Exception("OOOGeoEntity\u9700\u8981\u989d\u5916\u7684String\u53c2\u6570");
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                    break;
                }
            }
            case "fourze": {
                try {
                    throw new Exception("FourzeRocketEntity\u7684\u65b9\u6cd5\u7b7e\u540d\u4e0d\u5339\u914d");
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                    break;
                }
            }
            case "wizard": {
                try {
                    throw new Exception("Wizard\u9700\u8981\u989d\u5916\u7684DragonMagicType\u53c2\u6570");
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                    break;
                }
            }
            case "gaim": {
                try {
                    throw new Exception("GaimLockSeedEntity\u7684\u65b9\u6cd5\u7b7e\u540d\u4e0d\u5339\u914d");
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                    break;
                }
            }
            case "drive": {
                try {
                    DriveRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                }
                break;
            }
            case "ghost": {
                try {
                    Class<?> ghostClass = Class.forName("com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.ghost.GhostRiderEntity");
                    throw new Exception("Ghost\u5b9e\u4f53\u7c7b\u6682\u4e0d\u53ef\u7528");
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                    break;
                }
            }
            case "ex-aid": 
            case "exaid": {
                try {
                    Class<?> exaidClass = Class.forName("com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.exaid.ExAidRiderEntity");
                    throw new Exception("Ex-Aid\u5b9e\u4f53\u7c7b\u6682\u4e0d\u53ef\u7528");
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                    break;
                }
            }
            case "build": {
                try {
                    BuildRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                }
                catch (Exception e) {
                    DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
                }
                break;
            }
            default: {
                DecadeRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, damage);
            }
        }
    }

    @Override
    public void executeNonPlayerSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        super.executeNonPlayerSpecialAttack(level, shooter, direction);
        if (!level.f_46443_) {
            DecadeRiderEntity.trySpawnEffect(level, shooter, direction, this.getAttackDamage());
            level.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11705_, SoundSource.HOSTILE, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            shooter.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 120, 1));
            shooter.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 120, 0));
        }
    }

    @Override
    public String getRiderName() {
        return "Decade";
    }

    @Override
    public String getActivationSoundName() {
        return "Dimension Kick!";
    }

    @Override
    public float getAttackDamage() {
        return 52.0f;
    }

    @Override
    public float getEffectRange() {
        return 8.0f;
    }
}

