/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.Item.client.Heiseisword.HeiseiswordRenderer;
import com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom.Heiseisword;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffectManager;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.den_o.DenOTrainEntity;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DenOEffect
extends AbstractHeiseiRiderEffect {
    private final Random random = new Random();

    @Override
    public void executePlayerSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            DenOForm selectedForm = DenOForm.values()[this.random.nextInt(DenOForm.values().length)];
            switch (selectedForm) {
                case Sword: {
                    this.executeSwordFormAttack(level, player, direction);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 2));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 1));
                    break;
                }
                case FishingRod: {
                    this.executeFishingRodFormAttack(level, player, direction);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 300, 2));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 200, 3));
                    break;
                }
                case Ax: {
                    this.executeAxFormAttack(level, player, direction);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 2));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 3));
                    break;
                }
                case Gun: {
                    this.executeGunFormAttack(level, player, direction);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 2));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 0, 0));
                }
            }
        }
    }

    @Override
    public float getEffectRange() {
        return 12.0f;
    }

    private void executeSwordFormAttack(Level level, Player player, Vec3 direction) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DenOTrainEntity.spawn(serverLevel, (LivingEntity)player, direction, this.getAttackDamage(), "Sword");
        }
        if (player.m_21205_().m_41720_() instanceof Heiseisword) {
            HeiseiswordRenderer.attachDenOEntityToWeapon(player, player.m_21205_(), "Sword");
        }
    }

    private void executeFishingRodFormAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DenOTrainEntity fishline = DenOTrainEntity.spawn(serverLevel, (LivingEntity)player, direction, this.getAttackDamage(), "FishingRod");
            this.applyFishingRodEffect(level, player, direction);
        }
        if (player.m_21205_().m_41720_() instanceof Heiseisword) {
            HeiseiswordRenderer.attachDenOEntityToWeapon(player, player.m_21205_(), "FishingRod");
        }
    }

    private void applyFishingRodEffect(Level level, Player player, Vec3 direction) {
        double reach = 15.0;
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(direction.m_82490_(reach));
        LivingEntity target = null;
        double maxDistance = reach;
        for (LivingEntity entity : level.m_6443_(LivingEntity.class, new AABB(start, end).m_82400_(2.0), e -> e != player)) {
            double distance = player.m_20270_((Entity)entity);
            if (!(distance < maxDistance) || !player.m_142582_((Entity)entity)) continue;
            maxDistance = distance;
            target = entity;
        }
        if (target != null) {
            target.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.5f);
            Vec3 pullDir = player.m_20182_().m_82546_(target.m_20182_()).m_82541_();
            target.m_20256_(pullDir.m_82490_(1.5));
            for (int i = 0; i < 10; ++i) {
                double t = (double)i / 10.0;
                double x = start.f_82479_ + (target.m_20182_().f_82479_ - start.f_82479_) * t;
                double y = start.f_82480_ + (target.m_20182_().f_82480_ - start.f_82480_) * t;
                double z = start.f_82481_ + (target.m_20182_().f_82481_ - start.f_82481_) * t;
                level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void executeAxFormAttack(Level level, Player player, Vec3 direction) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DenOTrainEntity.spawn(serverLevel, (LivingEntity)player, direction, this.getAttackDamage(), "Ax");
        }
        if (player.m_21205_().m_41720_() instanceof Heiseisword) {
            HeiseiswordRenderer.attachDenOEntityToWeapon(player, player.m_21205_(), "Ax");
        }
    }

    private void executeGunFormAttack(Level level, Player player, Vec3 direction) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 3; ++i) {
                double spreadX = (level.f_46441_.m_188500_() - 0.5) * 0.2;
                double spreadY = (level.f_46441_.m_188500_() - 0.5) * 0.2;
                double spreadZ = (level.f_46441_.m_188500_() - 0.5) * 0.2;
                Vec3 bulletDir = new Vec3(direction.f_82479_ + spreadX, direction.f_82480_ + spreadY, direction.f_82481_ + spreadZ).m_82541_();
                DenOTrainEntity.spawn(serverLevel, (LivingEntity)player, bulletDir, this.getAttackDamage(), "Gun");
            }
        }
        if (player.m_21205_().m_41720_() instanceof Heiseisword) {
            HeiseiswordRenderer.attachDenOEntityToWeapon(player, player.m_21205_(), "Gun");
        }
    }

    @Override
    public String getRiderName() {
        return "Den-O";
    }

    @Override
    public String getActivationSoundName() {
        return "Full Charge!";
    }

    @Override
    public float getAttackDamage() {
        return 48.0f;
    }

    private void applyFishingRodEffectForNonPlayer(Level level, LivingEntity shooter, Vec3 direction) {
        double reach = 15.0;
        Vec3 start = shooter.m_20299_(1.0f);
        Vec3 end = start.m_82549_(direction.m_82490_(reach));
        LivingEntity target = null;
        double maxDistance = reach;
        for (LivingEntity entity : level.m_6443_(LivingEntity.class, new AABB(start, end).m_82400_(2.0), e -> e != shooter && shooter.m_6779_(e))) {
            double distance = shooter.m_20270_((Entity)entity);
            if (!(distance < maxDistance)) continue;
            maxDistance = distance;
            target = entity;
        }
        if (target != null) {
            if (shooter instanceof Mob) {
                Mob mob = (Mob)shooter;
                target.m_6469_(level.m_269111_().m_269333_((LivingEntity)mob), this.getAttackDamage() * 0.5f);
            } else {
                target.m_6469_(level.m_269111_().m_269264_(), this.getAttackDamage() * 0.5f);
            }
            Vec3 pullDir = shooter.m_20182_().m_82546_(target.m_20182_()).m_82541_();
            target.m_20256_(pullDir.m_82490_(1.5));
            for (int i = 0; i < 10; ++i) {
                double t = (double)i / 10.0;
                double x = start.f_82479_ + (target.m_20182_().f_82479_ - start.f_82479_) * t;
                double y = start.f_82480_ + (target.m_20182_().f_82480_ - start.f_82480_) * t;
                double z = start.f_82481_ + (target.m_20182_().f_82481_ - start.f_82481_) * t;
                level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void executeNonPlayerSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            HeiseiRiderEffectManager.playSelectionSound(level, shooter, this.getRiderName());
            HeiseiRiderEffectManager.playAttackSound(level, shooter, this.getRiderName());
            DenOForm selectedForm = DenOForm.values()[level.f_46441_.m_188503_(DenOForm.values().length)];
            switch (selectedForm) {
                case Sword: {
                    if (!(level instanceof ServerLevel)) break;
                    ServerLevel serverLevel = (ServerLevel)level;
                    DenOTrainEntity.spawn(serverLevel, shooter, direction, this.getAttackDamage(), "Sword");
                    break;
                }
                case FishingRod: {
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        DenOTrainEntity.spawn(serverLevel, shooter, direction, this.getAttackDamage(), "FishingRod");
                    }
                    if (!(shooter instanceof Mob)) break;
                    Mob mob = (Mob)shooter;
                    this.applyFishingRodEffectForNonPlayer(level, shooter, direction);
                    break;
                }
                case Ax: {
                    if (!(level instanceof ServerLevel)) break;
                    ServerLevel serverLevel = (ServerLevel)level;
                    DenOTrainEntity.spawn(serverLevel, shooter, direction, this.getAttackDamage(), "Ax");
                    break;
                }
                case Gun: {
                    if (!(level instanceof ServerLevel)) break;
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 3; ++i) {
                        double spreadX = (level.f_46441_.m_188500_() - 0.5) * 0.2;
                        double spreadY = (level.f_46441_.m_188500_() - 0.5) * 0.2;
                        double spreadZ = (level.f_46441_.m_188500_() - 0.5) * 0.2;
                        Vec3 bulletDir = new Vec3(direction.f_82479_ + spreadX, direction.f_82480_ + spreadY, direction.f_82481_ + spreadZ).m_82541_();
                        DenOTrainEntity.spawn(serverLevel, shooter, bulletDir, this.getAttackDamage(), "Gun");
                    }
                    break;
                }
            }
            this.applyVisualEffects(level, shooter, direction);
        }
    }

    private static enum DenOForm {
        Sword,
        FishingRod,
        Ax,
        Gun;

    }
}

