/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.exaid.ExAidSlashEffectEntity;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ExAidEffect
extends AbstractHeiseiRiderEffect {
    private static final Map<LivingEntity, Integer> DAMAGE_TARGETS = new HashMap<LivingEntity, Integer>();
    private static final int DURATION = 60;
    private static final int DAMAGE_INTERVAL = 10;
    private static final Map<Integer, DelayedEffectInfo> DELAYED_EFFECTS = new HashMap<Integer, DelayedEffectInfo>();
    private static int nextEffectId = 0;

    @Override
    public void executePlayerSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 400, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 400, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 2));
            double reach = 8.0;
            Vec3 start = player.m_20299_(1.0f);
            Vec3 end = start.m_82549_(direction.m_82490_(reach));
            Entity hitEntity = this.getTargetEntity(level, player, start, end, reach);
            if (hitEntity instanceof LivingEntity && hitEntity != player) {
                LivingEntity livingEntity = (LivingEntity)hitEntity;
                float initialDamage = this.getAttackDamage() * 0.5f;
                if (livingEntity != player) {
                    boolean bl = livingEntity.m_6469_(level.m_269111_().m_269075_(player), initialDamage);
                }
                this.addToDamageTargets(livingEntity, player);
                this.spawnSlashEffectOnEntity(hitEntity, level, player, direction);
                ExAidSlashEffectEntity.spawnEffectOnTarget(level, (Entity)player, hitEntity);
            } else {
                ExAidSlashEffectEntity.spawnEffect(level, (Entity)player, direction);
            }
        } else {
            try {
                Class<?> effectClass = Class.forName("com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.exaid.ExAidRiderEffect");
                Method method = effectClass.getMethod("spawnSlashEffectByOwnerDirection", Level.class, Player.class);
                method.invoke(null, level, player);
            }
            catch (Exception e) {
                ExAidSlashEffectEntity.spawnEffect(level, (Entity)player, direction);
            }
        }
    }

    @Override
    public void executeNonPlayerSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            Vec3 end;
            double reach = 8.0;
            Vec3 start = shooter.m_20299_(1.0f);
            Entity hitEntity = this.getTargetEntityForMob(level, shooter, start, end = start.m_82549_(direction.m_82490_(reach)), reach);
            if (hitEntity instanceof LivingEntity && hitEntity != shooter) {
                LivingEntity livingEntity = (LivingEntity)hitEntity;
                float initialDamage = this.getAttackDamage() * 0.5f;
                if (livingEntity != shooter) {
                    livingEntity.m_6469_(level.m_269111_().m_269333_(shooter), initialDamage);
                }
                ExAidSlashEffectEntity.spawnEffectOnTarget(level, (Entity)shooter, hitEntity);
            } else {
                ExAidSlashEffectEntity.spawnEffect(level, (Entity)shooter, direction);
            }
        } else {
            ExAidSlashEffectEntity.spawnEffect(level, (Entity)shooter, direction);
        }
    }

    private Entity getTargetEntityForMob(Level level, LivingEntity shooter, Vec3 start, Vec3 end, double reach) {
        AABB searchBox = new AABB(start, end).m_82400_(1.0);
        return level.m_6443_(LivingEntity.class, searchBox, entity -> entity != shooter && entity.m_6084_()).stream().findFirst().orElse(null);
    }

    private Entity getTargetEntity(Level level, Player player, Vec3 start, Vec3 end, double reach) {
        AABB searchBox = new AABB(start, end).m_82400_(1.0);
        return level.m_6443_(LivingEntity.class, searchBox, entity -> entity != player && entity.m_6084_()).stream().findFirst().orElse(null);
    }

    private void spawnSlashEffectOnEntity(Entity target, Level level, Player player, Vec3 direction) {
        ExAidSlashEffectEntity.spawnEffectOnTarget(level, (Entity)player, target);
    }

    private void addToDamageTargets(LivingEntity target, Player source) {
        DAMAGE_TARGETS.put(target, 60);
    }

    @Override
    public String getRiderName() {
        return "Ex-Aid";
    }

    @Override
    public String getActivationSoundName() {
        return "Hyper Critical Sparking!";
    }

    @Override
    public float getAttackDamage() {
        return 55.0f;
    }

    @Override
    public float getEffectRange() {
        return 10.0f;
    }

    private static class DelayedEffectInfo {
        final Level level;
        final LivingEntity shooter;
        final Vec3 direction;
        final int delay;

        DelayedEffectInfo(Level level, LivingEntity shooter, Vec3 direction, int delay) {
            this.level = level;
            this.shooter = shooter;
            this.direction = direction;
            this.delay = delay;
        }
    }
}

