/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.gaim.GaimLockSeedEntity;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GaimEffect
extends AbstractHeiseiRiderEffect {
    @Override
    public void executePlayerSpecialAttack(Level level, Player player, Vec3 direction) {
        LockSeed selectedSeed = this.getWeightedRandomLockSeed(level);
        this.spawnLockSeedEntity(level, player, direction, selectedSeed);
        if (!level.f_46443_) {
            switch (selectedSeed) {
                case Orange: {
                    this.executeOrangeLockSeed(level, player, direction);
                    break;
                }
                case Pineapple: {
                    this.executePineappleLockSeed(level, player, direction);
                    break;
                }
                case Banana: {
                    this.executeBananaLockSeed(level, player, direction);
                    break;
                }
                case Melon: {
                    this.executeMelonLockSeed(level, player, direction);
                }
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300, 1));
        }
    }

    private void spawnLockSeedEntity(Level level, Player player, Vec3 direction, LockSeed lockSeed) {
        Vec3 spawnPos = player.m_146892_().m_82549_(direction.m_82541_().m_82490_(1.0));
        if (lockSeed != LockSeed.Pineapple) {
            GaimLockSeedEntity lockSeedEntity = new GaimLockSeedEntity(level, (LivingEntity)player, spawnPos, direction, lockSeed.name().toUpperCase(), this.getAttackDamage());
            level.m_7967_((Entity)lockSeedEntity);
        }
    }

    private void executeOrangeLockSeed(Level level, Player player, Vec3 direction) {
        for (int i = 0; i < 5; ++i) {
            double distance = 2.0 + (double)i * 0.5;
            Vec3 targetPos = player.m_20299_(1.0f).m_82549_(direction.m_82490_(distance));
            level.m_45933_((Entity)player, new AABB(targetPos, targetPos).m_82400_(1.0)).forEach(entity -> {
                if (entity instanceof LivingEntity && entity != player) {
                    ((LivingEntity)entity).m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.4f);
                }
            });
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300, 1));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300, 1));
    }

    private void executePineappleLockSeed(Level level, Player player, Vec3 direction) {
        for (int i = 0; i < 5; ++i) {
            float spreadAngle = (level.f_46441_.m_188501_() - 0.5f) * 0.4f;
            Vec3 spreadDirection = new Vec3(direction.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.3f), direction.f_82480_ + (double)spreadAngle, direction.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.3f)).m_82541_();
            Vec3 spawnPos = player.m_146892_().m_82549_(spreadDirection.m_82490_(1.0));
            GaimLockSeedEntity lockSeedEntity = new GaimLockSeedEntity(level, (LivingEntity)player, spawnPos, spreadDirection, LockSeed.Pineapple.name().toUpperCase(), this.getAttackDamage() * 0.6f);
            level.m_7967_((Entity)lockSeedEntity);
        }
    }

    private void executeBananaLockSeed(Level level, Player player, Vec3 direction) {
        Vec3 slideVelocity = direction.m_82490_(3.0);
        player.m_20256_(slideVelocity);
        for (int i = 0; i < 5; ++i) {
            double distance = 1.0 + (double)i * 0.75;
            Vec3 pathPos = player.m_20299_(1.0f).m_82549_(direction.m_82490_(distance));
            level.m_6443_(LivingEntity.class, new AABB(pathPos, pathPos).m_82400_(1.5), entity -> entity != player).forEach(entity -> entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.8f));
        }
    }

    private void executeMelonLockSeed(Level level, Player player, Vec3 direction) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 60, 255));
    }

    private LockSeed getWeightedRandomLockSeed(Level level) {
        int rand = level.f_46441_.m_188503_(100);
        if (rand < 40) {
            return LockSeed.Orange;
        }
        if (rand < 65) {
            return LockSeed.Banana;
        }
        if (rand < 85) {
            return LockSeed.Melon;
        }
        return LockSeed.Pineapple;
    }

    @Override
    public String getRiderName() {
        return "Gaim";
    }

    @Override
    public String getActivationSoundName() {
        return "Kachidoki Arms!";
    }

    @Override
    public float getAttackDamage() {
        return 52.0f;
    }

    @Override
    public float getEffectRange() {
        return 12.0f;
    }

    @Override
    public void executeNonPlayerSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            LockSeed selectedSeed = this.getWeightedRandomLockSeed(level);
            this.spawnLockSeedEntityForMob(level, shooter, direction, selectedSeed);
            shooter.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300, 1));
        }
    }

    private void spawnLockSeedEntityForMob(Level level, LivingEntity shooter, Vec3 direction, LockSeed lockSeed) {
        Vec3 spawnPos = shooter.m_146892_().m_82549_(direction.m_82541_().m_82490_(1.0));
        if (lockSeed != LockSeed.Pineapple) {
            GaimLockSeedEntity lockSeedEntity = new GaimLockSeedEntity(level, shooter, spawnPos, direction, lockSeed.name().toUpperCase(), this.getAttackDamage());
            level.m_7967_((Entity)lockSeedEntity);
        }
    }

    private static enum LockSeed {
        Orange,
        Pineapple,
        Banana,
        Melon;

    }
}

