/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class KabutoEffect
extends AbstractHeiseiRiderEffect {
    private static final Map<UUID, Integer> slowedTntEntities = new HashMap<UUID, Integer>();
    private static final float PROJECTILE_STOP_FACTOR = 0.0f;
    private static final float TIME_SLOW_FACTOR = 0.3f;
    public static final int TIME_SLOW_DURATION = 200;

    @Override
    public void executePlayerSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 5));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 2));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 200, 2));
            this.activateFullClockDown(level, player);
            Vec3 velocity = direction.m_82490_(4.0);
            player.m_20256_(velocity);
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12312_, SoundSource.PLAYERS, 1.0f, 0.5f);
        }
    }

    private void activateFullClockDown(Level level, Player player) {
        double effectRange = 10.0;
        this.slowLivingEntities(level, player, effectRange);
        this.slowProjectiles(level, player, effectRange);
        this.delayTntExplosions(level, player, effectRange);
        this.stopRainParticles(level, (LivingEntity)player, effectRange);
        this.scheduleEffectReset(level);
    }

    private void slowLivingEntities(Level level, Player player, double range) {
        level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(range), entity -> {
            if (entity != player && entity.m_6084_()) {
                if (entity instanceof Player) {
                    Player targetPlayer = (Player)entity;
                    return !this.isPlayerInKabutoMode(targetPlayer);
                }
                return true;
            }
            return false;
        }).forEach(entity -> {
            boolean isArcher;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 4));
            boolean bl = isArcher = entity instanceof AbstractSkeleton || entity instanceof Skeleton || entity instanceof Stray || entity instanceof WitherSkeleton || entity instanceof Player && ((Player)entity).m_21205_().m_41720_() instanceof BowItem;
            if (isArcher) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 300, 4));
            } else {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 200, 4));
            }
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 1));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 150, 0));
        });
    }

    private boolean isPlayerInKabutoMode(Player player) {
        return player.m_21023_(MobEffects.f_19596_) && player.m_21124_(MobEffects.f_19596_).m_19564_() >= 4 && player.m_21023_(MobEffects.f_19606_);
    }

    private void slowProjectiles(Level level, Player player, double range) {
        level.m_45976_(Projectile.class, player.m_20191_().m_82400_(range)).forEach(projectile -> {
            if (!slowedTntEntities.containsKey(projectile.m_20148_())) {
                slowedTntEntities.put(projectile.m_20148_(), -1);
            }
            projectile.m_20256_(Vec3.f_82478_);
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                arrow.m_36781_(0.0);
                arrow.m_20256_(Vec3.f_82478_);
                arrow.m_20242_(true);
                if (arrow instanceof Arrow) {
                    Arrow minecraftArrow = (Arrow)arrow;
                    minecraftArrow.m_36790_(true);
                }
            }
        });
    }

    private void delayTntExplosions(Level level, Player player, double range) {
        level.m_45976_(PrimedTnt.class, player.m_20191_().m_82400_(range)).forEach(tnt -> {
            int currentFuse;
            if (!slowedTntEntities.containsKey(tnt.m_20148_())) {
                slowedTntEntities.put(tnt.m_20148_(), tnt.m_32100_());
            }
            if ((currentFuse = tnt.m_32100_()) > 0) {
                tnt.m_32085_(currentFuse + 10);
            }
        });
    }

    private void executeClockUpAttack(Level level, Player player, Vec3 direction) {
        level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(10.0), entity -> entity != player).forEach(entity -> {
            Vec3 toEntity = entity.m_20182_().m_82546_(player.m_20182_());
            double dotProduct = toEntity.m_82541_().m_82526_(direction.m_82541_());
            float damageFactor = dotProduct > 0.3 ? 2.0f : 1.0f;
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * damageFactor);
            Vec3 knockback = direction.m_82490_(2.0);
            entity.m_20256_(entity.m_20184_().m_82549_(knockback));
        });
    }

    @Override
    public void executeNonPlayerSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            this.activateFullClockDownForEntity(level, shooter);
            shooter.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 4));
            shooter.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 1));
            Vec3 velocity = direction.m_82490_(3.0);
            shooter.m_20256_(velocity);
            level.m_5594_(null, shooter.m_20183_(), SoundEvents.f_12312_, SoundSource.HOSTILE, 1.0f, 0.5f);
        }
        super.applyVisualEffects(level, shooter, direction);
    }

    private void activateFullClockDownForEntity(Level level, LivingEntity entity) {
        double effectRange = 10.0;
        level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(effectRange), target -> {
            if (target != entity && target.m_6084_()) {
                if (target instanceof Player) {
                    Player targetPlayer = (Player)target;
                    return !this.isPlayerInKabutoMode(targetPlayer);
                }
                return true;
            }
            return false;
        }).forEach(target -> {
            boolean isArcher;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 4));
            boolean bl = isArcher = target instanceof AbstractSkeleton || target instanceof Skeleton || target instanceof Stray || target instanceof WitherSkeleton || target instanceof Player && ((Player)target).m_21205_().m_41720_() instanceof BowItem;
            if (isArcher) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 300, 4));
            } else {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 200, 4));
            }
            target.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 1));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 150, 0));
        });
        level.m_45976_(Projectile.class, entity.m_20191_().m_82400_(effectRange)).forEach(projectile -> {
            if (!slowedTntEntities.containsKey(projectile.m_20148_())) {
                slowedTntEntities.put(projectile.m_20148_(), -1);
            }
            projectile.m_20256_(Vec3.f_82478_);
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                arrow.m_36781_(0.0);
                arrow.m_20256_(Vec3.f_82478_);
                arrow.m_20242_(true);
                if (arrow instanceof Arrow) {
                    Arrow minecraftArrow = (Arrow)arrow;
                    minecraftArrow.m_36790_(true);
                }
            }
        });
        level.m_45976_(PrimedTnt.class, entity.m_20191_().m_82400_(effectRange)).forEach(tnt -> {
            int currentFuse;
            if (!slowedTntEntities.containsKey(tnt.m_20148_())) {
                slowedTntEntities.put(tnt.m_20148_(), tnt.m_32100_());
            }
            if ((currentFuse = tnt.m_32100_()) > 0) {
                tnt.m_32085_(currentFuse + 10);
            }
        });
        this.stopRainParticles(level, entity, effectRange);
        this.scheduleEffectReset(level);
    }

    private void executeNonPlayerClockUpAttack(Level level, LivingEntity shooter, Vec3 direction) {
        level.m_6443_(LivingEntity.class, shooter.m_20191_().m_82400_(10.0), entity -> entity != shooter).forEach(entity -> {
            Vec3 toEntity = entity.m_20182_().m_82546_(shooter.m_20182_());
            double dotProduct = toEntity.m_82541_().m_82526_(direction.m_82541_());
            float damageFactor = dotProduct > 0.3 ? 1.5f : 1.0f;
            entity.m_6469_(level.m_269111_().m_269333_(shooter), this.getAttackDamage() * damageFactor * 0.8f);
            Vec3 knockback = direction.m_82490_(1.5);
            entity.m_20256_(entity.m_20184_().m_82549_(knockback));
        });
    }

    @Override
    public String getRiderName() {
        return "Kabuto";
    }

    @Override
    public String getActivationSoundName() {
        return "Clock Up! Clock Down!";
    }

    @Override
    public float getAttackDamage() {
        return 55.0f;
    }

    @Override
    public float getEffectRange() {
        return 10.0f;
    }

    public static void restoreProjectiles(Level level) {
        ArrayList<UUID> entitiesToProcess = new ArrayList<UUID>(slowedTntEntities.keySet());
        double range = 50.0;
        AABB searchBounds = new AABB(-range, -range, -range, range, range, range);
        for (Projectile projectile : level.m_45976_(Projectile.class, searchBounds)) {
            if (!entitiesToProcess.contains(projectile.m_20148_())) continue;
            if (projectile instanceof AbstractArrow) {
                projectile.m_20256_(projectile.m_20154_().m_82541_().m_82490_(2.5));
            } else {
                projectile.m_20256_(projectile.m_20154_().m_82541_().m_82490_(2.0));
            }
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                arrow.m_20242_(false);
                if (arrow instanceof Arrow) {
                    Arrow minecraftArrow = (Arrow)arrow;
                    minecraftArrow.m_36790_(false);
                }
                arrow.m_36781_(3.0);
            }
            slowedTntEntities.remove(projectile.m_20148_());
        }
        for (PrimedTnt tnt : level.m_45976_(PrimedTnt.class, searchBounds)) {
            if (!entitiesToProcess.contains(tnt.m_20148_()) || !slowedTntEntities.containsKey(tnt.m_20148_())) continue;
            Integer originalFuse = slowedTntEntities.get(tnt.m_20148_());
            if (originalFuse != null && originalFuse > 0) {
                int adjustedFuse = Math.max(0, originalFuse - 20);
                tnt.m_32085_(adjustedFuse);
            }
            slowedTntEntities.remove(tnt.m_20148_());
        }
    }

    public static void clearAllSlowedEffects(Level level) {
        KabutoEffect.restoreProjectiles(level);
        slowedTntEntities.clear();
    }

    @Override
    public double getEnergyCost() {
        return 40.0;
    }

    private void scheduleEffectReset(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().execute(() -> {
                Thread resetThread = new Thread(() -> {
                    try {
                        Thread.sleep(10000L);
                        serverLevel.m_7654_().execute(() -> {
                            try {
                                if (!serverLevel.f_46443_) {
                                    KabutoEffect.clearAllSlowedEffects((Level)serverLevel);
                                }
                            }
                            catch (Exception e) {
                                System.err.println("Error during effect reset: " + e.getMessage());
                                e.printStackTrace();
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        System.err.println("Error in reset thread: " + e.getMessage());
                        e.printStackTrace();
                    }
                });
                resetThread.setDaemon(true);
                resetThread.start();
            });
        }
    }

    private void stopRainParticles(Level level, LivingEntity entity, double range) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int x = (int)(entity.m_20185_() - range);
            while ((double)x <= entity.m_20185_() + range) {
                int y = (int)(entity.m_20186_() - range);
                while ((double)y <= entity.m_20186_() + range) {
                    int z = (int)(entity.m_20189_() - range);
                    while ((double)z <= entity.m_20189_() + range) {
                        double distance;
                        if (level.m_46758_(new BlockPos(x, y, z)) && (distance = Math.sqrt(Math.pow((double)x - entity.m_20185_(), 2.0) + Math.pow((double)y - entity.m_20186_(), 2.0) + Math.pow((double)z - entity.m_20189_(), 2.0))) <= range) {
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123803_, (double)x + level.f_46441_.m_188500_(), (double)y + level.f_46441_.m_188500_() * 2.0, (double)z + level.f_46441_.m_188500_(), 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }
}

