/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.ooo.OOOGeoEffect;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OOOEffect
extends AbstractHeiseiRiderEffect {
    private static final String PUTOTYRA = "putotyra";
    private static final double R = 0.8;
    private static final double G = 0.0;
    private static final double B = 0.8;

    @Override
    public void executePlayerSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            this.executeFullPowerAttack(level, player);
            this.executeCellMedalSlash(level, player, direction);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300, 1));
        }
    }

    @Override
    public void executeNonPlayerSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            this.executeNonPlayerRangeAttack(level, shooter);
            this.executeNonPlayerCellMedalSlash(level, shooter, direction);
        }
    }

    private void executeNonPlayerRangeAttack(Level level, LivingEntity shooter) {
        float attackDamage = this.getAttackDamage() * 0.7f;
        DamageSource damageSource = level.m_269111_().m_269333_(shooter);
        level.m_6443_(LivingEntity.class, shooter.m_20191_().m_82400_((double)(this.getEffectRange() / 2.0f)), entity -> entity != shooter && entity.m_6084_()).forEach(entity -> {
            entity.m_6469_(damageSource, attackDamage);
            if (!(entity instanceof Player)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 150, 0));
            }
        });
    }

    private void executeNonPlayerCellMedalSlash(Level level, LivingEntity shooter, Vec3 direction) {
        float attackDamage = this.getAttackDamage() * 1.5f;
        LivingEntity target = this.findNearestTargetInDirection(level, shooter, direction, 10.0);
        OOOGeoEffect.spawnCellMedalSwallow(level, shooter, direction, attackDamage, target);
    }

    private LivingEntity findNearestTargetInDirection(Level level, LivingEntity shooter, Vec3 direction, double maxRange) {
        Vec3 start = shooter.m_20299_(1.0f);
        Vec3 end = start.m_82549_(direction.m_82490_(maxRange));
        AABB searchBox = new AABB(start, end).m_82400_(2.0);
        return level.m_6443_(LivingEntity.class, searchBox, entity -> entity != shooter && entity.m_6084_()).stream().min((e1, e2) -> {
            double d1 = e1.m_20238_(start);
            double d2 = e2.m_20238_(start);
            return Double.compare(d1, d2);
        }).orElse(null);
    }

    private void executeBalancedAttack(Level level, Player player, Vec3 direction) {
        double reach = 8.0;
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(direction.m_82490_(reach));
        level.m_6443_(LivingEntity.class, new AABB(start, end).m_82400_(1.0), entity -> entity != player).forEach(entity -> entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 1.0f));
    }

    private void executePowerAttack(Level level, Player player) {
        level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(5.0), entity -> entity != player).forEach(entity -> {
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.8f);
            Vec3 knockback = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_(1.0);
            entity.m_20256_(entity.m_20184_().m_82549_(knockback));
        });
    }

    private void executeWaterAttack(Level level, Player player, Vec3 direction) {
        for (int i = 0; i < 3; ++i) {
            double spreadX = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            double spreadY = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            double spreadZ = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            Vec3 waterDir = new Vec3(direction.f_82479_ + spreadX, direction.f_82480_ + spreadY, direction.f_82481_ + spreadZ).m_82541_();
            double waterReach = 12.0;
            Vec3 waterStart = player.m_20299_(1.0f);
            Vec3 waterEnd = waterStart.m_82549_(waterDir.m_82490_(waterReach));
            level.m_6443_(LivingEntity.class, new AABB(waterStart, waterEnd).m_82400_(0.5), entity -> entity != player).forEach(entity -> entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.6f));
        }
    }

    private void executeFullPowerAttack(Level level, Player player) {
        level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(7.0), entity -> entity != player).forEach(entity -> {
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.7f);
            if (!(entity instanceof Player)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 150, 0));
            }
        });
    }

    private void executeDefenseAttack(Level level, Player player) {
        level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(6.0), entity -> entity != player).forEach(entity -> entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.8f));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 1));
    }

    private void executeCellMedalSlash(Level level, Player player, Vec3 direction) {
        float attackDamage = this.getAttackDamage();
        LivingEntity target = this.findNearestTargetInDirection(level, player, direction, 10.0);
        OOOGeoEffect.spawnCellMedalSwallow(level, (LivingEntity)player, direction, attackDamage * 1.5f, target);
    }

    private LivingEntity findNearestTargetInDirection(Level level, Player player, Vec3 direction, double maxRange) {
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(direction.m_82490_(maxRange));
        AABB searchBox = new AABB(start, end).m_82400_(2.0);
        return level.m_6443_(LivingEntity.class, searchBox, entity -> entity != player && entity.m_6084_() && player.m_6779_(entity)).stream().min((e1, e2) -> {
            double d1 = e1.m_20238_(start);
            double d2 = e2.m_20238_(start);
            return Double.compare(d1, d2);
        }).orElse(null);
    }

    @Override
    public String getRiderName() {
        return "OOO";
    }

    @Override
    public String getActivationSoundName() {
        return "Scanning Charge!";
    }

    @Override
    public float getAttackDamage() {
        return 51.0f;
    }

    @Override
    public float getEffectRange() {
        return 14.0f;
    }
}

